/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CheckFileService
extends AbstractFileService {
    public CheckFileService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        boolean exist = false;
        this.logger.info("JBI exchange receive - process checkFile operation");
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("checkFile", Message.MEPConstants.IN_OUT_PATTERN));
        }
        try {
            String filepath = this.extractFilePath(inMessageDoc);
            File file = new File(filepath);
            if (file != null && !file.isAbsolute()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "File [" + filepath + "] is not an absolute path, resolving the read-directory as a parent directory");
                }
                File directory = FileTransferUtils.getFolderPath(this.extensions);
                file = new File(directory, filepath);
            }
            exist = file.exists();
            this.addMonitBeginStepExtTrace(filepath, FileTransferUtils.getFolderPath(this.extensions).getName());
            String response = this.generateResponse(exist, exchange.getOperation(), file);
            exchange.getOutMessage().setContent(SourceUtil.createSource((String)response));
            this.addMonitEndStepExtTrace();
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, "resolved file path (Canonical form) : " + file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage());
            FileTransferUtils.setIOFaultOnExchange(exchange, e.getMessage());
        }
        catch (PEtALSCDKException e) {
            this.logger.log(Level.WARNING, e.getMessage());
            FileTransferUtils.setIOFaultOnExchange(exchange, e.getMessage());
        }
    }

    private String extractFilePath(Document inMessageDoc) throws MessagingException, FileNotFoundException {
        Node rootNode = inMessageDoc.getFirstChild();
        Node pattern = null;
        if (rootNode != null) {
            pattern = XMLHelper.findChild((Node)rootNode, null, (String)"filename", (boolean)false);
        }
        if (pattern == null) {
            throw new FileNotFoundException("Can't find filename node");
        }
        return pattern.getTextContent();
    }

    private String generateResponse(Boolean checkFile, QName operation, File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("<tns:" + operation.getLocalPart() + "Response xmlns:tns='");
        builder.append(operation.getNamespaceURI());
        builder.append("'>");
        builder.append("<tns:filename>");
        builder.append(file.getAbsolutePath());
        builder.append("</tns:filename>");
        builder.append("<tns:exist>");
        builder.append(checkFile != false ? "true" : "false");
        builder.append("</tns:exist>");
        builder.append("</tns:" + operation.getLocalPart() + "Response>");
        return builder.toString();
    }
}

