/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.provide;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.bc.filetransfer.service.provide.AbstractFileService;
import org.ow2.petals.bc.filetransfer.util.FileTransferUtils;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GetFileService
extends AbstractFileService {
    public GetFileService(ConfigurationExtensions extensions, Logger logger) {
        super(extensions, logger);
    }

    @Override
    public void process(Exchange exchange, Document inMessageDoc) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process GET operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FileTransferUtils.getValidMepMessageForOperation("get", Message.MEPConstants.IN_OUT_PATTERN));
        }
        Node filePatternNode = XMLHelper.findChild((Node)inMessageDoc.getFirstChild(), null, (String)"filename", (boolean)false);
        String filePattern = null;
        if (filePatternNode != null) {
            filePattern = filePatternNode.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(filePattern)) {
            FileTransferUtils.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            try {
                File readDirectory = FileTransferUtils.getFolderPath(this.extensions);
                this.logger.log(Level.INFO, "read files from : " + readDirectory.getAbsolutePath());
                this.logger.log(Level.INFO, "file pattern : " + filePattern);
                this.addMonitBeginStepExtTrace(filePattern, readDirectory.getName());
                Document outContent = this.get(filePattern, readDirectory, exchange.getOperation());
                exchange.setOutMessageContent(outContent);
                this.addMonitEndStepExtTrace();
            }
            catch (Exception e) {
                FileTransferUtils.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "]. Cause : " + e.getMessage());
            }
        }
        this.logger.log(Level.INFO, "GET service is correctly terminated");
    }

    private Document get(String filePattern, File readDirectory, QName operation) throws IOException {
        File[] files = FileTransferUtils.listFiles(readDirectory, filePattern);
        if (files.length > 0) {
            this.logger.log(Level.INFO, "file found : " + files[0].getName());
            if (!FileTransferUtils.checkAccess(files[0])) {
                throw new IOException("File " + files[0].getName() + " is locked.Permission denied");
            }
        } else {
            throw new IOException("file : '" + filePattern + "' not found");
        }
        File processedFile = FileTransferUtils.moveFile(files[0], this.extensions);
        Document result = this.getAsDocument(processedFile, operation);
        return result;
    }

    private Document getAsDocument(File processedFile, QName operation) throws IOException {
        Document doc;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("start receiving file " + processedFile.getName());
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(processedFile));
        try {
            doc = XMLUtil.loadDocument((InputStream)stream);
            Element rootElt = doc.createElementNS(operation.getNamespaceURI(), "ver:" + operation.getLocalPart() + "Response");
            rootElt.appendChild(doc.getDocumentElement());
            doc.appendChild(rootElt);
        }
        catch (SAXException e) {
            throw new IOException("processed file '" + processedFile.getName() + "' is not a valid xml file : " + e.getMessage());
        }
        finally {
            ((InputStream)stream).close();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(processedFile.getName() + " set as content");
        }
        return doc;
    }
}

