/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.util;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.activation.DataHandler;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.bc.filetransfer.service.consume.ConsumeConfiguration;
import org.ow2.petals.bc.filetransfer.util.LockFileFilter;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileTransferUtils {
    public static final String addDateToFileName(String filename) {
        String result;
        long time = System.nanoTime();
        String sTime = String.format("%1$014d", time);
        int index = filename.lastIndexOf(46);
        if (index > 0) {
            String prefix = filename.substring(0, filename.lastIndexOf(46));
            String suffix = filename.substring(filename.lastIndexOf(46), filename.length());
            result = prefix + "-" + sTime + suffix;
        } else {
            result = filename + "-" + sTime;
        }
        return result;
    }

    public static final void addFileAsAttachment(File file, String filename, NormalizedMessage message) throws MessagingException, IOException {
        DataHandler attachment = new DataHandler(file.toURI().toURL());
        message.addAttachment(filename, attachment);
    }

    public static ConsumeConfiguration buildConsumeConfiguration(ConfigurationExtensions extensions) throws MessagingException {
        String filePattern;
        String baseMsg = null;
        boolean baseMsgOn = false;
        String transferMode = "attachment";
        long pollingPeriod = 1000L;
        LockFileFilter regexFileNameFilter = null;
        File polledDirectory = null;
        File backupDirectory = null;
        int corePoolSize = 5;
        long corePoolTimeout = 10000L;
        baseMsg = extensions.get((Object)"base-message");
        try {
            if (!StringHelper.isNullOrEmpty((String)baseMsg)) {
                transferMode = FileTransferUtils.checkTransferModeInBaseMsg(baseMsg);
                baseMsgOn = true;
            } else {
                transferMode = FileTransferUtils.checkTransferModeInSU(extensions.get((Object)"transfer-mode"));
            }
        }
        catch (MessagingException e) {
            // empty catch block
        }
        String s_pollingPeriod = extensions.get((Object)"polling-period");
        if (!StringHelper.isNullOrEmpty((String)s_pollingPeriod)) {
            pollingPeriod = Long.parseLong(s_pollingPeriod);
        }
        regexFileNameFilter = StringHelper.isNullOrEmpty((String)(filePattern = extensions.get((Object)"filename"))) ? new LockFileFilter() : new LockFileFilter(filePattern);
        try {
            polledDirectory = FileTransferUtils.getFolderPath(extensions);
            backupDirectory = FileTransferUtils.getBackupDirectory(extensions);
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage());
        }
        try {
            corePoolSize = Integer.parseInt(extensions.get((Object)"processor-pool-size"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            corePoolTimeout = Long.parseLong(extensions.get((Object)"processor-pool-timeout"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new ConsumeConfiguration(backupDirectory, baseMsg, baseMsgOn, 0L, regexFileNameFilter, pollingPeriod, polledDirectory, transferMode, corePoolSize, corePoolTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean checkAccess(File file) {
        boolean result = false;
        FileChannel channel = null;
        FileLock lock = null;
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            lock = channel.lock();
            lock.release();
            result = true;
        }
        catch (OverlappingFileLockException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e1) {}
            }
        }
        return result;
    }

    public static String checkTransferModeInBaseMsg(String baseMsg) throws MessagingException {
        String transferMode = null;
        if (baseMsg.contains("$content")) {
            transferMode = "content";
        } else if (baseMsg.contains("$attachment")) {
            transferMode = "attachment";
        } else {
            throw new MessagingException("Transfer mode not recognized in the base-msg : " + baseMsg);
        }
        return transferMode;
    }

    public static String checkTransferModeInSU(String suTransferMode) throws MessagingException {
        String transferMode = null;
        if ("content".equalsIgnoreCase(suTransferMode)) {
            transferMode = "content";
        } else if ("attachment".equalsIgnoreCase(suTransferMode)) {
            transferMode = "attachment";
        } else {
            throw new MessagingException("Transfer mode not recognized :" + suTransferMode);
        }
        return transferMode;
    }

    public static final void copyFileToContent(File file, NormalizedMessage message) throws IOException, MessagingException {
        StreamSource source = new StreamSource(new FileInputStream(file));
        message.setContent((Source)source);
    }

    public static Document createMessageOnBaseMsg(File processedFile, String fileName, String baseMsg, String transferMode) throws IOException, MessagingException {
        Document processedFileAsDoc = null;
        Document finalMessage = null;
        Document baseMsgAsDoc = null;
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = DocumentBuilders.takeDocumentBuilder();
            baseMsgAsDoc = docBuilder.parse(new ByteArrayInputStream(baseMsg.getBytes()));
        }
        catch (SAXException e) {
            throw new MessagingException("The defined base message is invalid: [" + e.getMessage() + "]");
        }
        finally {
            if (docBuilder != null) {
                DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)docBuilder);
            }
        }
        if (transferMode.equalsIgnoreCase("content")) {
            try {
                processedFileAsDoc = XMLUtil.loadDocument((InputStream)new FileInputStream(processedFile));
            }
            catch (SAXException e) {
                throw new MessagingException(processedFile.getAbsolutePath() + " is not a valid xml file.can't process it in content transfer mode");
            }
            finalMessage = FileTransferUtils.replaceVariableByXmlFileContent(baseMsgAsDoc, processedFileAsDoc, "$content");
        } else if (transferMode.equalsIgnoreCase("attachment")) {
            finalMessage = FileTransferUtils.replaceVariableByXopElement(fileName, baseMsgAsDoc, "$attachment");
        }
        return finalMessage;
    }

    public static Document createMessageOnDefaultMsg(File processedFile, String fileName, String transferMode) throws IOException, MessagingException {
        Document inputXmlFile = null;
        Document finalMessage = null;
        if (transferMode.equals("content")) {
            try {
                inputXmlFile = XMLUtil.loadDocument((InputStream)new FileInputStream(processedFile));
            }
            catch (SAXException e) {
                throw new MessagingException(processedFile.getAbsolutePath() + " is not a valid xml file.can't process it in content transfer mode");
            }
            finalMessage = inputXmlFile;
        } else if (transferMode.equals("attachment")) {
            finalMessage = FileTransferUtils.injectAttachment(fileName);
        }
        return finalMessage;
    }

    public static final String evaluateFilePath(String filePath) {
        String result = filePath;
        List<String> keys = FileTransferUtils.extractPlaceHolderKeys(filePath);
        for (String key : keys) {
            if (StringHelper.isNullOrEmpty((String)System.getenv(key))) continue;
            result = filePath.replace("${" + key + "}", System.getenv(key));
        }
        result = File.separator.equals("/") ? result.replace("\\", "/") : result.replace("/", "\\");
        return result;
    }

    public static String extractFilePattern(Exchange exchange) throws MessagingException, FileNotFoundException {
        Document doc = exchange.getInMessageContentAsDocument();
        Node rootNode = doc.getFirstChild();
        Node pattern = null;
        if (rootNode != null) {
            pattern = XMLHelper.findChild((Node)rootNode, null, (String)"filepattern", (boolean)false);
        }
        if (pattern == null) {
            throw new FileNotFoundException("incorrect file filter found in filepattern node");
        }
        return pattern.getTextContent();
    }

    public static final Document generateMTOMListResponse(List<String> names, QName operation) {
        Document doc = DocumentBuilders.newDocument();
        Element root = doc.createElementNS(operation.getNamespaceURI(), "tns:" + operation.getLocalPart() + "Response");
        root.appendChild(MtomUtil.generateMtomStructure((Document)doc, names, (QName)new QName(operation.getNamespaceURI(), "attachments", "tns"), (QName)new QName(operation.getNamespaceURI(), "filename", "tns")));
        doc.appendChild(root);
        return doc;
    }

    public static Document generateMTOMResponse(String name, QName operation) {
        Document doc = DocumentBuilders.newDocument();
        Element root = doc.createElementNS(operation.getNamespaceURI(), "tns:" + operation.getLocalPart() + "Response");
        root.appendChild(MtomUtil.generateMtomStructure((Document)doc, Arrays.asList(name), (QName)new QName(operation.getNamespaceURI(), "attachment", "tns"), (QName)new QName(operation.getNamespaceURI(), "filename", "tns")));
        doc.appendChild(root);
        return doc;
    }

    public static final File getBackupDirectory(ConfigurationExtensions extensions) throws IOException {
        File working = null;
        String directory = extensions.get((Object)"backup-directory");
        if (!StringHelper.isNullOrEmpty((String)directory) && !(working = new File(directory = FileTransferUtils.evaluateFilePath(directory))).exists()) {
            throw new FileNotFoundException("backup-directory does not exist :" + directory);
        }
        return working;
    }

    public static final File getFolderPath(ConfigurationExtensions extensions) throws IOException {
        String directory = extensions.get((Object)"folder");
        if (StringHelper.isNullOrEmpty((String)directory)) {
            throw new FileNotFoundException("'folder' parameter is not set");
        }
        File working = new File(directory = FileTransferUtils.evaluateFilePath(directory));
        if (!working.exists()) {
            throw new FileNotFoundException("'folder' parameter with value '" + directory + "' does not exist");
        }
        return working;
    }

    public static final String getValidMepMessageForOperation(String operation, Message.MEPConstants ... mep) {
        StringBuilder builder = new StringBuilder();
        builder.append("Exchange pattern for the " + operation.toUpperCase() + " operation must be ");
        for (int i = 0; i < mep.length; ++i) {
            if (i > 0) {
                builder.append(" or ");
            }
            builder.append(mep[i]);
        }
        return builder.toString();
    }

    public static final File[] listFiles(File readDir, String filePattern) {
        return readDir.listFiles((FilenameFilter)FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(filePattern));
    }

    public static final File moveFile(File file, ConfigurationExtensions extensions) throws IOException {
        File processedFile = null;
        File backupDirectory = FileTransferUtils.getBackupDirectory(extensions);
        if (backupDirectory == null) {
            File tmpDirectory = new File(System.getProperty("java.io.tmpdir"));
            processedFile = new File(tmpDirectory, "petals-bc-filetransfer-" + file.getName() + System.nanoTime());
        } else {
            String target = "backup-" + FileTransferUtils.addDateToFileName(file.getName());
            processedFile = new File(backupDirectory, target);
        }
        if (!file.renameTo(processedFile)) {
            throw new IOException("Permission denied.Can not move file " + file.getName() + " to " + processedFile.getAbsolutePath());
        }
        return processedFile;
    }

    public static final void setIOFaultOnExchange(Exchange exchange, String ioMessage) throws MessagingException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        faultMessage.append("<tns:ioFault xmlns:tns=\"");
        faultMessage.append("http://petals.ow2.org/components/filetransfer/version-3");
        faultMessage.append("\"><tns:message>");
        faultMessage.append(ioMessage);
        faultMessage.append("</tns:message></tns:ioFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(SourceUtil.createSource((String)faultMessage.toString(), (String)"UTF-8"));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public static final void setMissingElementFaultOnExchange(Exchange exchange, String missingElement) throws MessagingException {
        StringBuffer faultMessage = new StringBuffer();
        faultMessage.append("<tns:missingElementFault xmlns:tns='");
        faultMessage.append("http://petals.ow2.org/components/filetransfer/version-3");
        faultMessage.append("'><tns:element>");
        faultMessage.append(missingElement);
        faultMessage.append("</tns:element></tns:missingElementFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(SourceUtil.createSource((String)faultMessage.toString()));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    private static final List<String> extractPlaceHolderKeys(String entryValue) {
        String[] keys;
        ArrayList<String> result = new ArrayList<String>();
        for (String string : keys = entryValue.split("[${]")) {
            int index = string.indexOf("}");
            if (index <= 0) continue;
            result.add(string.substring(0, index));
        }
        return result;
    }

    private static Document injectAttachment(String fileName) {
        Document doc = DocumentBuilders.newDocument();
        doc.appendChild(MtomUtil.generateMtomStructure((Document)doc, Arrays.asList(fileName), (QName)new QName("http://petals.ow2.org/components/filetransfer/version-3", "attachment")));
        return doc;
    }

    private static final Document replaceVariableByXmlFileContent(Document baseMsgDoc, Document processedFileDoc, String variable) throws MessagingException {
        Node node = XMLUtil.findVariable((NodeList)baseMsgDoc.getChildNodes(), (String)variable);
        if (node == null) {
            throw new MessagingException(variable + " variable not found in the base message.");
        }
        Node parentNode = node.getParentNode();
        Node importedNode = baseMsgDoc.importNode(processedFileDoc.getDocumentElement(), true);
        parentNode.replaceChild(importedNode, node);
        return baseMsgDoc;
    }

    private static final Document replaceVariableByXopElement(String filename, Document baseMsgDoc, String variable) throws MessagingException {
        if (baseMsgDoc != null) {
            Node node = XMLUtil.findVariable((NodeList)baseMsgDoc.getChildNodes(), (String)variable);
            if (node == null) {
                throw new MessagingException(variable + " variable not found in the base message.");
            }
            Node parentNode = node.getParentNode();
            parentNode.replaceChild(MtomUtil.generateMtomXopElement((Document)baseMsgDoc, (String)filename), node);
        }
        return baseMsgDoc;
    }
}

