/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Settablepositivestrictint;
import org.ow2.petals.component.framework.jbidescriptor.generated.Settablepositivestrictlong;

public abstract class AbstractMessageManager {
    protected static final int DEFAULT_ACCEPTOR_RETRY_MAX_TRY = 40;
    protected static final int DEFAULT_ACCEPTOR_RETRY_BASE_DURATION = 250;
    protected final Logger logger;
    protected final AbstractComponent component;

    public AbstractMessageManager(AbstractComponent component, Logger logger) {
        this.component = component;
        this.logger = logger;
    }

    public final int getRetryMaxTry() {
        int retryMaxTryValue;
        Settablepositivestrictint retryMaxTry = this.component.getComponentConfiguration().getAcceptorRetryNumber();
        if (retryMaxTry == null) {
            retryMaxTryValue = 40;
        } else {
            retryMaxTryValue = retryMaxTry.getValue();
            if (retryMaxTryValue <= 0) {
                retryMaxTryValue = 40;
                this.logger.warning("Invalid value for attribute 'acceptor-retry-number': The value must be upper or equals to 1. Default value used (40).");
            }
        }
        return retryMaxTryValue;
    }

    public final long getRetryBaseDuration() {
        long retryBaseDurationValue;
        Settablepositivestrictlong retryBaseDuration = this.component.getComponentConfiguration().getAcceptorRetryWait();
        if (retryBaseDuration == null) {
            retryBaseDurationValue = 250L;
        } else {
            retryBaseDurationValue = retryBaseDuration.getValue();
            if (retryBaseDurationValue <= 0L) {
                retryBaseDurationValue = 250L;
                this.logger.warning("Invalid value for attribute 'acceptor-retry-number': The value must be upper or equals to 1. Default value used (250).");
            }
        }
        return retryBaseDurationValue;
    }
}

