/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.filetransfer.service.consume;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.bc.filetransfer.FileTransferComponent;
import org.ow2.petals.bc.filetransfer.listeners.FileTransferExternalListener;
import org.ow2.petals.bc.filetransfer.service.consume.ConsumeConfiguration;
import org.ow2.petals.bc.filetransfer.service.consume.ExternalEventProcessor;
import org.ow2.petals.bc.filetransfer.service.consume.ExternalEventProcessorFactory;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class ExternalEventPoller
extends TimerTask {
    private final FileTransferComponent component;
    private final ConsumeConfiguration configuration;
    private final FileTransferExternalListener consumeContext;
    private final Logger logger;
    private final ThreadPoolExecutor poolExecutor;
    private Timer timer;

    public ExternalEventPoller(ConsumeConfiguration configuration, FileTransferExternalListener consumeContext) {
        this.configuration = configuration;
        this.consumeContext = consumeContext;
        this.component = (FileTransferComponent)consumeContext.getComponent();
        this.logger = consumeContext.getLogger();
        ServiceUnitDataHandler dtHandler = ((AbstractServiceUnitManager)this.component.getServiceUnitManager()).getSUDataHandlerForConsumes(this.consumeContext.getConsumes());
        this.timer = new Timer("petals-bc-filetransfer - External Event Poller Thread [" + dtHandler.getName() + "]");
        this.poolExecutor = new ThreadPoolExecutor(configuration.getCorePoolSize(), configuration.getCorePoolSize(), configuration.getCorePoolTimeout(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ExternalEventProcessorFactory());
        this.poolExecutor.allowCoreThreadTimeOut(true);
    }

    @Override
    public void run() {
        this.component.cleanPendingProcessors();
        if (this.configuration.getPolledDirectory().canRead()) {
            File[] list = this.configuration.getPolledDirectory().listFiles((FilenameFilter)((Object)this.configuration.getFilePattern()));
            if (list != null && list.length > 0) {
                for (File file : list) {
                    try {
                        Map<String, Future<?>> pendingProcessor = this.component.getPendingProcessors();
                        if (pendingProcessor.containsKey(file.getName())) continue;
                        Future<?> fileProcessor = this.poolExecutor.submit(new ExternalEventProcessor(file, this));
                        pendingProcessor.put(file.getName(), fileProcessor);
                    }
                    catch (RejectedExecutionException e) {
                        this.logger.info("Max ExternalEventProcessor pool size reached");
                    }
                    catch (Throwable e) {
                        this.logger.info(e.getClass().getName() + " : " + e.getMessage());
                    }
                }
            }
        } else {
            this.logger.info("Failed to read polled directory : [" + this.configuration.getPolledDirectory().getAbsolutePath() + "]");
        }
    }

    public void startPolling() {
        this.logger.info("start polling directory : [" + this.configuration.getPolledDirectory().getAbsolutePath() + "]");
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Configuration: [Transfer Mode: " + this.configuration.getTransferMode() + "; Polling Period: " + this.configuration.getPeriod() + "ms; Use message template: " + this.configuration.isBaseMsgOn() + "]");
        }
        this.timer.schedule((TimerTask)this, this.configuration.getDelay(), this.configuration.getPeriod());
    }

    public void stopPolling() {
        this.logger.info("stop polling directory : " + this.configuration.getPolledDirectory().getAbsolutePath());
        this.poolExecutor.shutdown();
        this.timer.cancel();
        this.timer.purge();
        this.timer = null;
    }

    protected ConsumeConfiguration getConfiguration() {
        return this.configuration;
    }

    protected FileTransferExternalListener getConsumeContext() {
        return this.consumeContext;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

