/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class IgnoreIrrelevantNodesDifferenceListener
implements DifferenceListener {
    protected abstract boolean isIrrelevantAttribute(Attr var1);

    protected abstract boolean isIrrelevantChildNode(Node var1);

    public void skippedComparison(Node arg0, Node arg1) {
    }

    private final boolean haveSameRelevantChildNodes(Node controlNode, Node testNode) {
        int c = 0;
        int t = 0;
        NodeList controlChildNodes = controlNode.getChildNodes();
        NodeList testChildNodes = testNode.getChildNodes();
        while (c < controlChildNodes.getLength() && t < testChildNodes.getLength()) {
            QName testNodeQName;
            Node controlChildNode = controlChildNodes.item(c);
            Node testChildNode = controlChildNodes.item(t);
            if (this.isIrrelevantChildNode(controlChildNode)) {
                ++c;
                continue;
            }
            if (this.isIrrelevantChildNode(testChildNode)) {
                ++t;
                continue;
            }
            if (controlNode.getNodeType() != testNode.getNodeType()) {
                return false;
            }
            QName controlNodeQName = new QName(controlNode.getNamespaceURI(), controlNode.getLocalName());
            if (!controlNodeQName.equals(testNodeQName = new QName(testNode.getNamespaceURI(), controlNode.getLocalName()))) {
                return false;
            }
            ++c;
            ++t;
        }
        return c >= controlChildNodes.getLength() && t >= controlChildNodes.getLength();
    }

    private final int getRelevantChildNodesCount(Node node) {
        NodeList childNodes = node.getChildNodes();
        int count = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (this.isIrrelevantChildNode(childNode)) continue;
            ++count;
        }
        return count;
    }

    private final boolean haveSameRelevantAttributes(Element controlElement, Element testElement) {
        NamedNodeMap attNodes = controlElement.getAttributes();
        for (int i = 0; i < attNodes.getLength(); ++i) {
            Attr attr = (Attr)attNodes.item(i);
            if (this.isIrrelevantAttribute(attr) || testElement.hasAttributeNS(attr.getNamespaceURI(), attr.getLocalName())) continue;
            return false;
        }
        return true;
    }

    private final int getRelevantAttributesCount(Element e) {
        NamedNodeMap attNodes = e.getAttributes();
        int count = 0;
        for (int i = 0; i < attNodes.getLength(); ++i) {
            Attr attr = (Attr)attNodes.item(i);
            if (this.isIrrelevantAttribute(attr)) continue;
            ++count;
        }
        return count;
    }

    public int differenceFound(Difference d) {
        Element testElement;
        Element controlElement;
        Node testNode;
        Node controlNode;
        if (d.getId() == 19) {
            controlNode = d.getControlNodeDetail().getNode();
            testNode = d.getTestNodeDetail().getNode();
            if (this.getRelevantChildNodesCount(controlNode) == this.getRelevantChildNodesCount(testNode)) {
                return 1;
            }
        }
        if (d.getId() == 20 && this.haveSameRelevantChildNodes(controlNode = d.getControlNodeDetail().getNode(), testNode = d.getTestNodeDetail().getNode())) {
            return 1;
        }
        if (d.getId() == 22) {
            controlNode = d.getControlNodeDetail().getNode();
            testNode = d.getTestNodeDetail().getNode();
            if (controlNode != null && this.isIrrelevantChildNode(controlNode) || testNode != null && this.isIrrelevantChildNode(testNode)) {
                return 1;
            }
        }
        if (d.getId() == 11) {
            controlElement = (Element)d.getControlNodeDetail().getNode();
            testElement = (Element)d.getTestNodeDetail().getNode();
            if (this.getRelevantAttributesCount(controlElement) == this.getRelevantAttributesCount(testElement)) {
                return 1;
            }
        }
        if (d.getId() == 2 && this.haveSameRelevantAttributes(controlElement = (Element)d.getControlNodeDetail().getNode(), testElement = (Element)d.getTestNodeDetail().getNode()) && this.haveSameRelevantAttributes(testElement, controlElement)) {
            return 1;
        }
        if (d.getId() == 15) {
            return 1;
        }
        return 0;
    }
}

