/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.SchemaReader;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.impl.SchemaReaderImpl;
import org.ow2.easywsdl.schema.util.URILocationResolver;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.xml.sax.InputSource;

public abstract class AbstractWSDLReaderImpl
implements WSDLReader {
    protected static final Logger LOG = Logger.getLogger(AbstractWSDLReaderImpl.class.getName());
    private Map<WSDLReader.FeatureConstants, Object> features = new HashMap<WSDLReader.FeatureConstants, Object>();
    private SchemaReader schemaReader = null;
    private final URILocationResolver uriLocationResolver = new URILocationResolver();
    private URI documentBaseURI;

    public AbstractWSDLReaderImpl() throws WSDLException {
        try {
            this.schemaReader = new SchemaReaderImpl();
            this.features.put(WSDLReader.FeatureConstants.VERBOSE, false);
            this.features.put(WSDLReader.FeatureConstants.IMPORT_DOCUMENTS, true);
        }
        catch (SchemaException schemaException) {
            throw new WSDLException(schemaException);
        }
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public void setDocumentBaseURI(URI uRI) {
        this.documentBaseURI = uRI;
        if (this.schemaReader != null) {
            this.schemaReader.setDocumentBaseURI(uRI);
        }
    }

    @Override
    public final void setFeature(WSDLReader.FeatureConstants featureConstants, Object object) throws WSDLException {
        this.features.put(featureConstants, object);
        LOG.finest("set proterty: " + (Object)((Object)featureConstants) + " - value = " + object);
    }

    @Override
    public final Object getFeature(WSDLReader.FeatureConstants featureConstants) {
        return this.features.get((Object)featureConstants);
    }

    @Override
    public final Map<WSDLReader.FeatureConstants, Object> getFeatures() {
        return this.features;
    }

    @Override
    public final void setFeatures(Map<WSDLReader.FeatureConstants, Object> map) {
        this.features = map;
    }

    @Override
    public abstract Description read(InputSource var1, Map<URI, AbsItfDescription> var2, Map<URI, AbsItfSchema> var3) throws WSDLException, MalformedURLException, URISyntaxException;

    protected Description readExternalPart(URI uRI, URI uRI2, Map<URI, AbsItfDescription> map, Map<URI, AbsItfSchema> map2) throws WSDLException, MalformedURLException, URISyntaxException {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(this.uriLocationResolver.resolve(uRI2, uRI).openStream());
            inputSource.setSystemId(this.uriLocationResolver.resolve(uRI2, uRI).toString());
        }
        catch (IOException iOException) {
            throw new WSDLException(iOException);
        }
        return this.read(inputSource, map, map2);
    }
}

