/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.impl.wsdl20;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.util.EasyXMLFilter;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.WSDLReader;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLReaderImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.impl.wsdl20.DescriptionImpl;
import org.ow2.easywsdl.wsdl.impl.wsdl20.WSDLJAXBContext;
import org.ow2.easywsdl.wsdl.org.w3.ns.wsdl.DescriptionType;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDLReaderImpl
extends AbstractWSDLReaderImpl
implements WSDLReader {
    private static final Logger LOG = Logger.getLogger(WSDLReaderImpl.class.getName());

    public WSDLReaderImpl() throws WSDLException {
        WSDLJAXBContext.getInstance();
    }

    @Override
    public Description read(URL uRL) throws WSDLException, IOException, URISyntaxException {
        InputStream inputStream = uRL.openStream();
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toString());
            Description description = this.read(inputSource);
            return description;
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("The provided well-formed URL has been detected as malformed !!");
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public Description read(InputSource inputSource) throws WSDLException, MalformedURLException, URISyntaxException {
        String string = inputSource.getSystemId();
        if (string != null) {
            this.setDocumentBaseURI(new URI(inputSource.getSystemId()));
        }
        return this.read(inputSource, null, null);
    }

    @Override
    public Description read(Document document) throws WSDLException, URISyntaxException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(document), streamResult);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            inputSource.setSystemId(document.getBaseURI());
            Description description = this.read(inputSource);
            return description;
        }
        catch (TransformerException transformerException) {
            throw new WSDLException(transformerException);
        }
        catch (IOException iOException) {
            throw new WSDLException(iOException);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
    }

    @Override
    public Description read(InputSource inputSource, Map<URI, AbsItfDescription> map, Map<URI, AbsItfSchema> map2) throws WSDLException, MalformedURLException, URISyntaxException {
        URI uRI;
        String string = inputSource.getSystemId();
        if (string != null) {
            uRI = new URI(string);
            this.setDocumentBaseURI(uRI);
        } else {
            uRI = new File(".").toURI();
        }
        DescriptionImpl descriptionImpl = null;
        try {
            Unmarshaller unmarshaller = WSDLJAXBContext.getInstance().getJaxbContext().createUnmarshaller();
            LOG.fine("Loading " + uRI);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            EasyXMLFilter easyXMLFilter = new EasyXMLFilter(xMLReader);
            SAXSource sAXSource = new SAXSource(easyXMLFilter, inputSource);
            JAXBElement jAXBElement = unmarshaller.unmarshal((Source)sAXSource, DescriptionType.class);
            DescriptionType descriptionType = (DescriptionType)jAXBElement.getValue();
            descriptionImpl = new DescriptionImpl(uRI, descriptionType, easyXMLFilter.getNamespaceMapper(), easyXMLFilter.getSchemaLocator(), this.getFeatures(), map, map2, this);
        }
        catch (JAXBException jAXBException) {
            throw new WSDLException("Can not get wsdl at: " + uRI.toString(), jAXBException);
        }
        catch (SAXException sAXException) {
            throw new WSDLException("Can not get wsdl at: " + uRI.toString(), sAXException);
        }
        catch (WSDLImportException wSDLImportException) {
            throw new WSDLException("Can not get wsdl at: " + uRI.toString(), wSDLImportException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WSDLException("Can not get wsdl at: " + uRI.toString() + " WSDL too large !", numberFormatException);
        }
        return descriptionImpl;
    }
}

