/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;

public class InputStreamForker {
    private InputStream originalInputStream;
    private final ForkedInputStream is1;
    private final ForkedInputStream is2;
    protected boolean originalInputStreamClosed = false;

    public InputStreamForker(InputStream inputStream) {
        this.originalInputStream = inputStream;
        this.is1 = new ForkedInputStream();
        this.is2 = new ForkedInputStream();
        this.is1.setOtherForkedInputStream(this.is2);
        this.is2.setOtherForkedInputStream(this.is1);
    }

    public InputStream getInputStreamOne() {
        return this.is1;
    }

    public InputStream getInputStreamTwo() {
        return this.is2;
    }

    protected class ForkedInputStream
    extends InputStream {
        private final LinkedList<byte[]> bufferList = new LinkedList();
        private boolean isClosed = false;
        private ForkedInputStream otherForkedInputStream;
        private LinkedList<byte[]> otherBufferList;

        public void setOtherForkedInputStream(ForkedInputStream forkedInputStream) {
            this.otherForkedInputStream = forkedInputStream;
            this.otherBufferList = this.otherForkedInputStream.getBufferList();
        }

        public LinkedList<byte[]> getBufferList() {
            return this.bufferList;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            InputStreamForker inputStreamForker = InputStreamForker.this;
            synchronized (inputStreamForker) {
                int n = 0;
                Iterator iterator = this.bufferList.iterator();
                while (iterator.hasNext()) {
                    n += ((byte[])iterator.next()).length;
                }
                if (!InputStreamForker.this.originalInputStreamClosed && !this.isClosed) {
                    n += InputStreamForker.this.originalInputStream.available();
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.isClosed) {
                InputStreamForker inputStreamForker = InputStreamForker.this;
                synchronized (inputStreamForker) {
                    this.isClosed = true;
                    if (this.otherForkedInputStream.isClosed) {
                        InputStreamForker.this.originalInputStream.close();
                        InputStreamForker.this.originalInputStreamClosed = true;
                    }
                }
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n != 1) {
                throw new IOException("No byte read.");
            }
            return byArray[0];
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.localRead(byArray, n, n2, false);
        }

        @Override
        public long skip(long l) throws IOException, IllegalArgumentException {
            if (l > Long.MAX_VALUE) {
                throw new IllegalArgumentException("Only value lesser 2147483647are accepted.");
            }
            return this.localRead(null, 0, (int)l, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int localRead(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            int n3 = n2;
            int n4 = n;
            InputStreamForker inputStreamForker = InputStreamForker.this;
            synchronized (inputStreamForker) {
                byte[] byArray2;
                for (int i = this.bufferList.size(); i > 0 && n3 != 0; --i) {
                    byArray2 = this.bufferList.getFirst();
                    if (n3 >= byArray2.length) {
                        if (!bl) {
                            System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
                        }
                        this.bufferList.removeFirst();
                        if ((n3 -= byArray2.length) == 0) {
                            return n2;
                        }
                        n4 += byArray2.length;
                        continue;
                    }
                    if (!bl) {
                        System.arraycopy(byArray2, 0, byArray, n4, n3);
                    }
                    byte[] byArray3 = new byte[byArray2.length - n3];
                    System.arraycopy(byArray2, n3, byArray3, 0, byArray2.length - n3);
                    this.bufferList.removeFirst();
                    this.bufferList.addFirst(byArray3);
                    return n2;
                }
                if (InputStreamForker.this.originalInputStreamClosed) {
                    throw new IOException("The original InputStream has been closed; cannot read from a closed InputStream.");
                }
                byArray2 = new byte[n3];
                int n5 = InputStreamForker.this.originalInputStream.read(byArray2, 0, n3);
                if (n5 != -1) {
                    if (!this.otherForkedInputStream.isClosed()) {
                        if (n5 == n3) {
                            this.otherBufferList.addLast(byArray2);
                        } else {
                            byte[] byArray4 = new byte[n5];
                            System.arraycopy(byArray2, 0, byArray4, 0, n5);
                            this.otherBufferList.addLast(byArray4);
                        }
                    }
                    if (!bl) {
                        System.arraycopy(byArray2, 0, byArray, n4, n3);
                    }
                    return n2 - n3 + n5;
                }
                if (n2 == n3) {
                    return -1;
                }
                return n2 - n3;
            }
        }
    }
}

