/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.jbidescriptor.generated.Retrypolicy;
import org.w3c.dom.Node;

public class FTPConnectionInfoBuilder {
    public static FTPConnectionInfo buildFTPConnectionInfo(Node node) throws MissingElementException {
        Node server = null;
        Node user = null;
        Node password = null;
        Node directory = null;
        Node port = null;
        Node connectionMode = null;
        Node transferType = null;
        Node deleteProcessedFile = null;
        Node encoding = null;
        Node overwrite = null;
        server = XMLHelper.findChild((Node)node, null, (String)"server", (boolean)false);
        port = XMLHelper.findChild((Node)node, null, (String)"port", (boolean)false);
        user = XMLHelper.findChild((Node)node, null, (String)"user", (boolean)false);
        password = XMLHelper.findChild((Node)node, null, (String)"password", (boolean)false);
        directory = XMLHelper.findChild((Node)node, null, (String)"folder", (boolean)false);
        connectionMode = XMLHelper.findChild((Node)node, null, (String)"connection-mode", (boolean)false);
        transferType = XMLHelper.findChild((Node)node, null, (String)"transfer-type", (boolean)false);
        deleteProcessedFile = XMLHelper.findChild((Node)node, null, (String)"delete-processed-files", (boolean)false);
        encoding = XMLHelper.findChild((Node)node, null, (String)"encoding", (boolean)false);
        overwrite = XMLHelper.findChild((Node)node, null, (String)"overwrite", (boolean)false);
        int portValue = 21;
        if (port != null) {
            try {
                portValue = Integer.parseInt(port.getTextContent());
            }
            catch (NumberFormatException e) {
                portValue = 0;
            }
        }
        FTPConnectionInfo result = new FTPConnectionInfo(server != null ? server.getTextContent() : null, portValue, user != null ? user.getTextContent() : null, password != null ? password.getTextContent() : null, directory != null ? directory.getTextContent() : null, connectionMode != null ? connectionMode.getTextContent() : null, transferType != null ? transferType.getTextContent() : null, 1, 0L, deleteProcessedFile != null ? Boolean.parseBoolean(deleteProcessedFile.getTextContent()) : false, encoding != null ? encoding.getTextContent() : null, overwrite != null ? Boolean.parseBoolean(overwrite.getTextContent()) : false);
        result.validate();
        return result;
    }

    public static FTPConnectionInfo buildFTPConnectionInfo(ConfigurationExtensions extensions, Retrypolicy retryPolicy) throws MissingElementException {
        int attempt = 1;
        long delay = 0L;
        if (retryPolicy != null) {
            attempt += retryPolicy.getAttempts();
            delay = retryPolicy.getDelay();
        }
        String server = null;
        String user = null;
        String password = null;
        String directory = null;
        int port = 21;
        String connectionMode = null;
        String transferType = null;
        boolean deleteProcessedFile = false;
        String encoding = null;
        boolean overwrite = false;
        int maxConnection = -1;
        long maxIdleTime = 10000L;
        try {
            port = Integer.parseInt(extensions.get((Object)"port"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            maxIdleTime = Long.parseLong(extensions.get((Object)"max-idle-time"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            maxConnection = Integer.parseInt(extensions.get((Object)"max-connection"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        server = extensions.get((Object)"server");
        user = extensions.get((Object)"user");
        password = extensions.get((Object)"password");
        directory = extensions.get((Object)"folder");
        connectionMode = extensions.get((Object)"connection-mode");
        transferType = extensions.get((Object)"transfer-type");
        deleteProcessedFile = Boolean.valueOf(extensions.get((Object)"delete-processed-files"));
        encoding = extensions.get((Object)"encoding");
        overwrite = Boolean.parseBoolean(extensions.get((Object)"overwrite"));
        FTPConnectionInfo result = new FTPConnectionInfo(server, port, user, password, directory, connectionMode, transferType, attempt, delay, deleteProcessedFile, encoding, overwrite);
        result.validate();
        result.setMaxConnection(maxConnection);
        result.setMaxIdleTime(maxIdleTime);
        return result;
    }
}

