/**
 * PETALS - PETALS Services Platform. Copyright (c) 2007 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.bc.ftp;

import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

/**
 * @author "Mathieu CARROLLE - mathieu.carrolle@petalslink.com"
 */
public class FTPComponent extends AbstractBindingComponent {

    /**
     * Store a pool of FTPClient object for each service-unit
     */
    private final ConcurrentHashMap<Provides, GenericObjectPool> mapOfPool = new ConcurrentHashMap<Provides, GenericObjectPool>();

    public ConcurrentHashMap<Provides, GenericObjectPool> getMapOfPool() {
        return mapOfPool;
    }

    @Override
    protected AbstractServiceUnitManager createServiceUnitManager() {
        return new FtpSuManager(this);
    }

}
