/**
 * PETALS - PETALS Services Platform. Copyright (c) 2007 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.bc.ftp.connection;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.commons.pool.PoolableObjectFactory;

/**
 * This factory create instance of FTPClient. It implements the lifecycle of the
 * pool
 * 
 * @author ”Mathieu CARROLLE - mathieu.carrolle@petalslink.com”
 * 
 */
public class WrappedFTPClientFactory implements PoolableObjectFactory {
    final FTPConnectionInfo connectionConfiguration;

    final Logger logger;

    public WrappedFTPClientFactory(final FTPConnectionInfo connectionConfiguration,
            final Logger logger) {
        this.logger = logger;
        this.connectionConfiguration = connectionConfiguration;
    }

    @Override
    public Object makeObject() throws Exception {
        this.logger.finest("Create new instance of FTPClient");
        final WrappedFTPClient client = new WrappedFTPClient(this.connectionConfiguration,
                this.logger);
        try {
            client.connectAndLog();
            client.configureConnection();
        } catch (IOException e) {
            // Prevent zombie connection (connection established but not
            // linked to an instance in the pool)
            this.destroyObject(client);
            throw e;
        }
        return client;
    }

    @Override
    public void destroyObject(Object obj) throws Exception {
        final WrappedFTPClient client = (WrappedFTPClient) obj;
        if (client != null && client.isConnected()) {
            if (this.logger.isLoggable(Level.FINEST))
                this.logger.finest("Log out user and disconnect FTP connection : ["
                        + connectionConfiguration.toString() + "]");
            client.logout();
            client.disconnect();
        }
    }

    @Override
    public boolean validateObject(Object obj) {
        this.logger.finest("Validate instance of FTPClientWrapped");
        final WrappedFTPClient client = (WrappedFTPClient) obj;
        Boolean result = false;
        try {
            if (client.isConnected() && client.sendNoOp()) {
                this.logger.finest("FTPClient is connected");
                result = true;
            }
        } catch (IOException e) {
        }
        return result;
    }

    @Override
    public void activateObject(Object obj) throws Exception {
    }

    @Override
    public void passivateObject(Object obj) throws Exception {
    }
}
