/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.bc.ftp.FTPComponent;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfoBuilder;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClientFactory;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class FtpSuManager
extends AbstractServiceUnitManager {
    public FtpSuManager(AbstractComponent component) {
        super(component);
    }

    protected void doDeploy(String serviceUnitName, String suRootPath, Jbi jbiDescriptor) throws PEtALSCDKException {
        FTPConnectionInfo connectionConfiguration;
        ServiceUnitDataHandler handler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        Provides provides = (Provides)handler.getDescriptor().getServices().getProvides().get(0);
        ConfigurationExtensions extensions = handler.getConfigurationExtensions((Object)provides);
        try {
            connectionConfiguration = FTPConnectionInfoBuilder.buildFTPConnectionInfo(extensions, provides.getRetrypolicy());
        }
        catch (MissingElementException e) {
            throw new PEtALSCDKException((Throwable)e);
        }
        WrappedFTPClientFactory factory = new WrappedFTPClientFactory(connectionConfiguration, this.logger);
        GenericObjectPool pool = new GenericObjectPool((PoolableObjectFactory)factory);
        pool.setConfig(this.configurePool(connectionConfiguration, pool));
        ((FTPComponent)this.component).getMapOfPool().put(provides, pool);
    }

    protected void doUndeploy(String serviceUnitName) throws PEtALSCDKException {
        ServiceUnitDataHandler handler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(serviceUnitName);
        Provides provides = (Provides)handler.getDescriptor().getServices().getProvides().get(0);
        ObjectPool pool = (ObjectPool)((FTPComponent)this.component).getMapOfPool().get(provides);
        try {
            this.logger.finest("Closing pool's resource");
            pool.clear();
            pool.close();
        }
        catch (Exception e) {
            this.logger.finest("Exception when closing pool's resource: " + e.getMessage());
        }
    }

    private GenericObjectPool.Config configurePool(FTPConnectionInfo connectionConfiguration, GenericObjectPool pool) {
        GenericObjectPool.Config conf = new GenericObjectPool.Config();
        int maxConnection = connectionConfiguration.getMaxConnection();
        if (maxConnection <= 0) {
            conf.whenExhaustedAction = (byte)2;
        } else {
            this.logger.finest("Number of maximum connection for the pool: " + maxConnection);
            conf.whenExhaustedAction = 1;
            conf.maxWait = -1L;
            conf.maxActive = maxConnection;
            conf.maxIdle = maxConnection;
        }
        conf.minEvictableIdleTimeMillis = connectionConfiguration.getMaxIdleTime();
        conf.timeBetweenEvictionRunsMillis = connectionConfiguration.getMaxIdleTime() / 2L;
        conf.testOnBorrow = true;
        return conf;
    }
}

