/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.listener;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.IOException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.petals.bc.ftp.FTPComponent;
import org.ow2.petals.bc.ftp.FTPUtil;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfoBuilder;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClient;
import org.ow2.petals.bc.ftp.service.FTPService;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JBIListener
extends AbstractJBIListener {
    private transient FTPService service = null;

    public void init() {
        this.service = new FTPService(this.getLogger());
    }

    private static final void validateExchange(Exchange exchange) throws MessagingException {
        QName operation = exchange.getOperation();
        if (operation == null) {
            throw new MessagingException("The JBI operation must be set by the consumer of the service.");
        }
        if (StringHelper.isNullOrEmpty((String)operation.getNamespaceURI())) {
            exchange.setOperation(new QName("http://petals.ow2.org/components/ftp/version-3", operation.getLocalPart()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean onJBIMessage(Exchange exchange) {
        block48: {
            GenericObjectPool pool = null;
            WrappedFTPClient client = null;
            if (exchange.isActiveStatus()) {
                block47: {
                    JBIListener.validateExchange(exchange);
                    QName operation = exchange.getOperation();
                    Document inMessage = exchange.getInMessageContentAsDocument();
                    Wsdl nativeWSDL = this.component.getNativeWsdl();
                    if (nativeWSDL != null && WSDLUtilImpl.isDescriptionContaining((Description)nativeWSDL.getDescription(), (ServiceEndpoint)exchange.getEndpoint())) {
                        Node connection = XMLHelper.findChild((Node)inMessage.getFirstChild(), null, (String)"connection", (boolean)false);
                        FTPConnectionInfo connectionInfo = FTPConnectionInfoBuilder.buildFTPConnectionInfo(connection);
                        client = new WrappedFTPClient(connectionInfo, this.getLogger());
                        client.connectAndLog();
                        client.configureConnection();
                    } else {
                        pool = ((FTPComponent)this.component).getMapOfPool().get(this.getProvides());
                        client = (WrappedFTPClient)((Object)pool.borrowObject());
                    }
                    if ("dir".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processDir(exchange, client);
                        break block47;
                    }
                    if ("get".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processGet(exchange, inMessage, client);
                        break block47;
                    }
                    if ("getAsAttachment".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processGetAsAttachment(exchange, inMessage, client);
                        break block47;
                    }
                    if ("mget".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processMGet(exchange, inMessage, client);
                        break block47;
                    }
                    if ("put".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processPut(exchange, inMessage, client);
                        break block47;
                    }
                    if ("mput".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processMPut(exchange, inMessage, client);
                        break block47;
                    }
                    if ("del".equalsIgnoreCase(operation.getLocalPart())) {
                        this.service.processDel(exchange, inMessage, client);
                        break block47;
                    }
                    String message = "The operation '" + operation + "' is not recognized";
                    throw new MessagingException(message);
                }
                try {
                    if (pool == null) {
                        if (client != null && client.isConnected()) {
                            this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                            client.logout();
                            client.disconnect();
                        }
                    } else if (client != null) {
                        this.getLogger().finest("Return FTPClient to the pool");
                        pool.returnObject((Object)client);
                    }
                    break block48;
                }
                catch (IOException e) {
                    this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + e.getMessage() + "]");
                }
                catch (Exception e2) {
                    this.getLogger().finest("Cannot release object of the pool : [" + e2.getMessage() + "]");
                }
                break block48;
                catch (MissingElementException e) {
                    block49: {
                        this.getLogger().log(Level.WARNING, e.getClass().getSimpleName() + " : " + e.getMessage());
                        if (exchange.isInOnlyPattern()) {
                            exchange.setError((Exception)e);
                            break block49;
                        }
                        try {
                            FTPUtil.setMissingElementFaultOnExchange(exchange, e.getElement());
                        }
                        catch (MessagingException e1) {
                            exchange.setError((Exception)((Object)e1));
                        }
                    }
                    try {
                        if (pool == null) {
                            if (client != null && client.isConnected()) {
                                this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                                client.logout();
                                client.disconnect();
                            }
                        } else if (client != null) {
                            this.getLogger().finest("Return FTPClient to the pool");
                            pool.returnObject((Object)client);
                        }
                    }
                    catch (IOException e2) {
                        this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + e2.getMessage() + "]");
                    }
                    catch (Exception e2) {
                        this.getLogger().finest("Cannot release object of the pool : [" + e2.getMessage() + "]");
                    }
                }
                catch (Exception e2) {
                    this.getLogger().log(Level.WARNING, e2.getClass().getSimpleName() + " : " + e2.getMessage());
                    exchange.setError(e2);
                    {
                        catch (Throwable throwable) {
                            try {
                                if (pool == null) {
                                    if (client != null && client.isConnected()) {
                                        this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                                        client.logout();
                                        client.disconnect();
                                    }
                                } else if (client != null) {
                                    this.getLogger().finest("Return FTPClient to the pool");
                                    pool.returnObject(client);
                                }
                            }
                            catch (IOException e3) {
                                this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + e3.getMessage() + "]");
                            }
                            catch (Exception e22) {
                                this.getLogger().finest("Cannot release object of the pool : [" + e22.getMessage() + "]");
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (pool == null) {
                            if (client != null && client.isConnected()) {
                                this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                                client.logout();
                                client.disconnect();
                            }
                        } else if (client != null) {
                            this.getLogger().finest("Return FTPClient to the pool");
                            pool.returnObject((Object)client);
                        }
                    }
                    catch (IOException e4) {
                        this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + e4.getMessage() + "]");
                    }
                    catch (Exception e22) {
                        this.getLogger().finest("Cannot release object of the pool : [" + e22.getMessage() + "]");
                    }
                }
            }
        }
        return true;
    }
}

