/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.service;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import org.ow2.petals.bc.ftp.FTPUtil;
import org.ow2.petals.bc.ftp.FtpProvideExtFlowStepBeginLogData;
import org.ow2.petals.bc.ftp.FtpProvideExtFlowStepEndLogData;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClient;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FTPService {
    private final Logger logger;

    public FTPService(Logger logger) {
        this.logger = logger;
    }

    public void processDel(Exchange exchange, Document inMessage, WrappedFTPClient client) throws MessagingException, MissingElementException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process DEL operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("del", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node filePatternNode = XMLHelper.findChild((Node)inMessage.getFirstChild(), null, (String)"filename", (boolean)false);
        String filePattern = null;
        if (filePatternNode == null) {
            throw new MissingElementException("filename");
        }
        filePattern = filePatternNode.getTextContent();
        if (filePattern != null) {
            if (PetalsExecutionContext.getFlowAttributes() != null) {
                this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory(), "(" + filePattern + ")"));
            }
            try {
                client.del(filePattern);
            }
            catch (IOException e) {
                StringBuilder errorSB = new StringBuilder();
                errorSB.append("Can not delete file on FTP server [");
                errorSB.append(client.getConnectionInfo().getServer());
                errorSB.append("] : IOException : ");
                errorSB.append(e.getMessage());
                throw new MessagingException(errorSB.toString());
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("DEL operation ended");
            }
        }
    }

    public void processDir(Exchange exchange, WrappedFTPClient client) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process DIR operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("dir", Message.MEPConstants.IN_OUT_PATTERN));
        }
        if (PetalsExecutionContext.getFlowAttributes() != null) {
            this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory()));
        }
        try {
            List<String> fileNames = client.listFolderContent();
            String result = FTPUtil.generateFileNameList(fileNames, exchange.getOperation());
            exchange.getOutMessage().setContent(SourceUtil.createSource((String)result));
        }
        catch (IOException e) {
            FTPUtil.setIOFaultOnExchange(exchange, "Can not list files on FTP server [" + client.getConnectionInfo().getServer() + "]. Cause : " + e.getMessage());
        }
        catch (PEtALSCDKException e) {
            throw new MessagingException((Throwable)e);
        }
        if (PetalsExecutionContext.getFlowAttributes() != null) {
            this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepEndLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId()));
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("DIR operation ended");
        }
    }

    public void processGet(Exchange exchange, Document inMessage, WrappedFTPClient client) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process GET operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("get", Message.MEPConstants.IN_OUT_PATTERN));
        }
        Node filePatternNode = XMLHelper.findChild((Node)inMessage.getFirstChild(), null, (String)"filename", (boolean)false);
        String filePattern = null;
        if (filePatternNode != null) {
            filePattern = filePatternNode.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(filePattern)) {
            FTPUtil.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            if (PetalsExecutionContext.getFlowAttributes() != null) {
                this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory(), "(" + filePattern + ")"));
            }
            try {
                Document doc = client.get(filePattern);
                Element rootElt = doc.createElementNS(exchange.getOperation().getNamespaceURI(), "ver:getResponse");
                rootElt.appendChild(doc.getDocumentElement());
                doc.appendChild(rootElt);
                exchange.setOutMessageContent(doc);
                if (client.getConnectionInfo().getDeleteProcessedFile()) {
                    client.del(filePattern);
                }
                if (PetalsExecutionContext.getFlowAttributes() != null) {
                    this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepEndLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId()));
                }
            }
            catch (IOException e) {
                FTPUtil.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "] on FTP server [" + client.getConnectionInfo().getServer() + "]. Cause : " + e.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("GET operation ended");
        }
    }

    public void processGetAsAttachment(Exchange exchange, Document inMessage, WrappedFTPClient client) throws MessagingException {
        this.logger.info("JBI exchange received - Process GET AS ATTACHMENT operation");
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("getAsAttachment", Message.MEPConstants.IN_OUT_PATTERN));
        }
        Node filePatternNode = XMLHelper.findChild((Node)inMessage.getFirstChild(), null, (String)"filename", (boolean)true);
        String filePattern = null;
        if (filePatternNode != null) {
            filePattern = filePatternNode.getTextContent();
        }
        if (StringHelper.isNullOrEmpty(filePattern)) {
            FTPUtil.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            if (PetalsExecutionContext.getFlowAttributes() != null) {
                this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory(), "(" + filePattern + ")"));
            }
            try {
                DataHandler file = client.getFileAsAttachment(filePattern);
                exchange.setOutMessageAttachment(file.getName(), file);
                Document outDoc = FTPUtil.generateMTOMResponse(file.getName(), exchange.getOperation());
                exchange.setOutMessageContent(outDoc);
                if (client.getConnectionInfo().getDeleteProcessedFile()) {
                    client.del(file.getName());
                }
                if (PetalsExecutionContext.getFlowAttributes() != null) {
                    this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepEndLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId()));
                }
            }
            catch (IOException e) {
                FTPUtil.setIOFaultOnExchange(exchange, "Can not get file [" + filePattern + "] on FTP server [" + client.getConnectionInfo().getServer() + "]. Cause : " + e.getMessage());
            }
        }
        this.logger.info("GET AS ATTACHMENT operation ended");
    }

    private final String filenamesAsPatterns(Collection<String> filenames) {
        assert (!filenames.isEmpty());
        StringBuffer sb = new StringBuffer("(");
        for (String filename : filenames) {
            sb.append(filename);
            sb.append("|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public void processMGet(Exchange exchange, Document inMessage, WrappedFTPClient client) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MGET operation");
        }
        if (!exchange.isInOutPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("mget", Message.MEPConstants.IN_OUT_PATTERN));
        }
        NodeList list = inMessage.getFirstChild().getChildNodes();
        LinkedList<String> filenames = new LinkedList<String>();
        for (int index = 0; index < list.getLength(); ++index) {
            if (!"filename".equalsIgnoreCase(list.item(index).getLocalName())) continue;
            filenames.add(list.item(index).getTextContent());
        }
        if (filenames.size() == 0) {
            FTPUtil.setMissingElementFaultOnExchange(exchange, "filename");
        } else {
            String filenamesAsPatterns = this.filenamesAsPatterns(filenames);
            if (PetalsExecutionContext.getFlowAttributes() != null) {
                this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory(), filenamesAsPatterns));
            }
            try {
                Map<String, DataHandler> files = client.mGet(filenames);
                for (Map.Entry<String, DataHandler> entry : files.entrySet()) {
                    exchange.getOutMessage().addAttachment(entry.getKey(), entry.getValue());
                }
                LinkedList<String> retrievedFilenames = new LinkedList<String>(files.keySet());
                Document outDoc = FTPUtil.generateMTOMListResponse(retrievedFilenames, exchange.getOperation());
                exchange.setOutMessageContent(outDoc);
                if (client.getConnectionInfo().getDeleteProcessedFile()) {
                    client.mDel(retrievedFilenames);
                }
                if (PetalsExecutionContext.getFlowAttributes() != null) {
                    this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepEndLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId()));
                }
            }
            catch (IOException e) {
                FTPUtil.setIOFaultOnExchange(exchange, "Can not get files [" + filenames + "] on FTP server [" + client.getConnectionInfo().getServer() + "]. Cause : " + e.getMessage());
            }
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MGET operation ended");
        }
    }

    public void processMPut(Exchange exchange, Document inputDocument, WrappedFTPClient client) throws MessagingException {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process MPUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("mput", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        if (exchange.getInMessageAttachments().isEmpty()) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("One or more attachments expected.");
            throw new MessagingException(errorSB.toString());
        }
        try {
            MtomUtil.MtomMapping mapping = MtomUtil.getMtomMapping((Exchange)exchange, (Element)inputDocument.getDocumentElement());
            Map attachments = mapping.getContentIdToDataHandler();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(mapping.toString());
            }
            String filenamesAsPatterns = this.filenamesAsPatterns(attachments.keySet());
            if (PetalsExecutionContext.getFlowAttributes() != null) {
                this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory(), filenamesAsPatterns));
            }
            client.mPut(attachments);
        }
        catch (IOException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put files on FTP server [");
            errorSB.append(client.getConnectionInfo().getServer());
            errorSB.append("] : IOException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        this.logger.info("MPUT operation ended");
    }

    public void processPut(Exchange exchange, Document inMessage, WrappedFTPClient client) throws MessagingException, MissingElementException {
        if (exchange == null) {
            throw new MessagingException("exchange parameter is null");
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("JBI exchange received - Process PUT operation");
        }
        if (!exchange.isInOnlyPattern()) {
            throw new MessagingException(FTPUtil.getOperationValidMep("put", Message.MEPConstants.IN_ONLY_PATTERN));
        }
        Node root = inMessage.getFirstChild();
        if (root == null || !"put".equalsIgnoreCase(root.getLocalName())) {
            throw new MissingElementException("put");
        }
        Node fileNameNode = XMLHelper.findChild((Node)root, null, (String)"filename", (boolean)false);
        if (fileNameNode == null || !"filename".equalsIgnoreCase(fileNameNode.getLocalName())) {
            throw new MissingElementException("filename");
        }
        Node bodyNode = XMLHelper.findChild((Node)root, null, (String)"body", (boolean)false);
        if (bodyNode == null) {
            throw new MissingElementException("body");
        }
        try {
            if (PetalsExecutionContext.getFlowAttributes() != null) {
                this.logger.log(Level.MONIT, "", (Object)new FtpProvideExtFlowStepBeginLogData(PetalsExecutionContext.getFlowAttributes().getFlowInstanceId(), PetalsExecutionContext.getFlowAttributes().getFlowStepId(), client.getConnectionInfo().getDirectory(), fileNameNode.getTextContent()));
            }
            String body = XMLHelper.toString((NodeList)bodyNode.getChildNodes());
            client.putString(fileNameNode.getTextContent(), body);
        }
        catch (IOException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put XML content on FTP server [");
            errorSB.append(client.getConnectionInfo().getServer());
            errorSB.append("] : IOException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        catch (DOMException e) {
            StringBuilder errorSB = new StringBuilder();
            errorSB.append("Can not put XML content on FTP server [");
            errorSB.append(client.getConnectionInfo().getServer());
            errorSB.append("] : DOMException : ");
            errorSB.append(e.getMessage());
            throw new MessagingException(errorSB.toString());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("PUT operation ended");
        }
    }
}

