/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.util;

import java.io.IOException;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.util.Util;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class WSDLVersionDetector
extends DefaultHandler {
    AbsItfDescription.WSDLVersionConstants version = null;

    public AbsItfDescription.WSDLVersionConstants getVersion() {
        return this.version;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("description") && string.equals("http://www.w3.org/ns/wsdl")) {
            this.version = AbsItfDescription.WSDLVersionConstants.WSDL20;
        }
        if (string2.equals("definitions") && string.equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.version = AbsItfDescription.WSDLVersionConstants.WSDL11;
        }
        if (this.version != null) {
            throw new SAXException("Cool! We found the WSDL version");
        }
        super.startElement(string, string2, string3, attributes);
    }

    public static AbsItfDescription.WSDLVersionConstants getVersion(InputSource inputSource) throws WSDLException {
        WSDLVersionDetector wSDLVersionDetector = new WSDLVersionDetector();
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(wSDLVersionDetector);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            throw new WSDLException("Unable to get WSDL version.", iOException);
        }
        return wSDLVersionDetector.getVersion();
    }

    public static AbsItfDescription.WSDLVersionConstants getVersion(Document document) {
        String string = Util.getLocalPartWithoutPrefix(document.getDocumentElement().getNodeName());
        AbsItfDescription.WSDLVersionConstants wSDLVersionConstants = null;
        if (string.equals("description")) {
            wSDLVersionConstants = AbsItfDescription.WSDLVersionConstants.WSDL20;
        }
        if (string.equals("definitions")) {
            wSDLVersionConstants = AbsItfDescription.WSDLVersionConstants.WSDL11;
        }
        return wSDLVersionConstants;
    }
}

