/**
 * PETALS - PETALS Services Platform. Copyright (c) 2007 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id:
 * -------------------------------------------------------------------------
 */

package org.ow2.petals.bc.ftp;

/**
 * 
 * @author alouis
 */
public interface FTPConstants {

    public final static String FTP_SERVICE_NS = "http://petals.ow2.org/components/ftp/version-3";

    public final static String FTP_INTERFACE = "ftp";

    // --------------------------------------------------------
    // Default value
    // --------------------------------------------------------
    
    public final static long DEFAULT_MAX_IDLE_TIME = 10000;

    public final static int DEFAULT_MAX_CONNECTION = -1;
    
    // --------------------------------------------------------
    // Component configuration
    // --------------------------------------------------------

    /**
     * the FTP server property.
     */
    public final static String FTP_SERVER = "server";

    /**
     * the FTP port property.
     */
    public final static String FTP_PORT = "port";

    /**
     * the FTP login property.
     */
    public final static String FTP_USER = "user";

    /**
     * the FTP password property.
     */
    public final static String FTP_PASSWORD = "password";

    /**
     * the FTP folder.
     */
    public final static String FTP_FOLDER = "folder";

    /**
     * the FTP connection element
     */
    public final static String FTP_CONNECTION = "connection";

    /**
     * the FTP filename element
     */
    public final static String FTP_FILENAME = "filename";

    /**
     * the FTP deleteProcessedFilename element
     */
    public final static String FTP_DELETE_PROCESSED_FILES = "delete-processed-files";

    /**
     * The ftp "overwrite" element
     */
    public final static String FTP_OVERWRITE = "overwrite";

    /***
     * Encoding element
     */
    public final static String FTP_ENCODING = "encoding";

    /**
     * MaxIdleTime element (milliseconds)
     */
    public static final String FTP_MAX_IDLE_TIME = "max-idle-time";

    /**
     * Unique connection allowed
     */
    public static final String FTP_MAX_CONNECTION = "max-connection";

    public final static String BODY = "body";

    public final static String CONNECTION_MODE = "connection-mode";

    public final static String TRANSFER_TYPE = "transfer-type";

    public final static String CONNECTION_MODE_PASSIVE = "passive";

    public final static String CONNECTION_MODE_ACTIVE = "active";

    public final static String TRANSFER_TYPE_ASCII = "ascii";

    public final static String TRANSFER_TYPE_BINARY = "binary";

    // --------------------------------------------------------
    // Component operation
    // --------------------------------------------------------

    /**
     * Operation local name : getAsAttachment
     */
    public final static String GET_ATTACHMENT_OPERATION = "getAsAttachment";

    /**
     * Operation local name : dir
     */
    public final static String DIR_OPERATION = "dir";

    /**
     * Operation local name : get
     */
    public final static String GET_OPERATION = "get";

    /**
     * Operation local name : mget
     */
    public final static String MGET_OPERATION = "mget";

    /**
     * Operation local name : put
     */
    public final static String PUT_OPERATION = "put";

    /**
     * Operation local name : mput
     */
    public final static String MPUT_OPERATION = "mput";

    /**
     * Operation local name : del
     */
    public final static String DEL_OPERATION = "del";

    /**
     * Operation local name : standard_put
     */
    public final static String STANDARD_PUT_OPERATION = "standard_put";

    public final static String UTF_8 = "UTF-8";
}
