/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.bc.ftp.FTPComponent;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfoBuilder;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClientFactory;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class FtpSuManager
extends AbstractServiceUnitManager {
    public FtpSuManager(AbstractComponent abstractComponent) {
        super(abstractComponent);
    }

    protected void doDeploy(String string, String string2, Jbi jbi) throws PEtALSCDKException {
        FTPConnectionInfo fTPConnectionInfo;
        ServiceUnitDataHandler serviceUnitDataHandler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(string);
        Provides provides = (Provides)serviceUnitDataHandler.getDescriptor().getServices().getProvides().get(0);
        ConfigurationExtensions configurationExtensions = serviceUnitDataHandler.getConfigurationExtensions((Object)provides);
        try {
            fTPConnectionInfo = FTPConnectionInfoBuilder.buildFTPConnectionInfo(configurationExtensions, provides.getRetrypolicy());
        }
        catch (MissingElementException missingElementException) {
            throw new PEtALSCDKException((Throwable)missingElementException);
        }
        WrappedFTPClientFactory wrappedFTPClientFactory = new WrappedFTPClientFactory(fTPConnectionInfo, this.logger);
        GenericObjectPool genericObjectPool = new GenericObjectPool((PoolableObjectFactory)wrappedFTPClientFactory);
        genericObjectPool.setConfig(this.configurePool(fTPConnectionInfo, genericObjectPool));
        ((FTPComponent)this.component).getMapOfPool().put(provides, genericObjectPool);
    }

    protected void doUndeploy(String string) throws PEtALSCDKException {
        ServiceUnitDataHandler serviceUnitDataHandler = (ServiceUnitDataHandler)this.getServiceUnitDataHandlers().get(string);
        Provides provides = (Provides)serviceUnitDataHandler.getDescriptor().getServices().getProvides().get(0);
        ObjectPool objectPool = (ObjectPool)((FTPComponent)this.component).getMapOfPool().get(provides);
        try {
            this.logger.finest("Closing pool's resource");
            objectPool.clear();
            objectPool.close();
        }
        catch (Exception exception) {
            this.logger.finest("Exception when closing pool's resource: " + exception.getMessage());
        }
    }

    private GenericObjectPool.Config configurePool(FTPConnectionInfo fTPConnectionInfo, GenericObjectPool genericObjectPool) {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        int n = fTPConnectionInfo.getMaxConnection();
        if (n <= 0) {
            config.whenExhaustedAction = (byte)2;
        } else {
            this.logger.finest("Number of maximum connection for the pool: " + n);
            config.whenExhaustedAction = 1;
            config.maxWait = -1L;
            config.maxActive = n;
            config.maxIdle = n;
        }
        config.minEvictableIdleTimeMillis = fTPConnectionInfo.getMaxIdleTime();
        config.timeBetweenEvictionRunsMillis = fTPConnectionInfo.getMaxIdleTime() / 2L;
        config.testOnBorrow = true;
        return config;
    }
}

