/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.nio.charset.Charset;
import org.ow2.petals.bc.ftp.MissingElementException;

public class FTPConnectionInfo {
    private int attempt;
    private String connectionMode;
    private long delay;
    private boolean deleteProcessedFile;
    private String encoding;
    private String folder;
    private int maxConnection;
    private long maxIdleTime;
    private boolean overwrite;
    private String password;
    private int port;
    private String server;
    private String transferType;
    private String user;

    public FTPConnectionInfo(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, long l, boolean bl, String string7, boolean bl2) {
        this.connectionMode = string5;
        this.folder = string4;
        this.password = string3;
        this.port = n;
        this.server = string;
        this.transferType = string6;
        this.user = string2;
        this.attempt = n2;
        this.delay = l;
        this.deleteProcessedFile = bl;
        this.encoding = string7;
        this.overwrite = bl2;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public String getConnectionMode() {
        return this.connectionMode;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean getDeleteProcessedFile() {
        return this.deleteProcessedFile;
    }

    public String getDirectory() {
        return this.folder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getServer() {
        return this.server;
    }

    public String getTransferType() {
        return this.transferType;
    }

    public String getUser() {
        return this.user;
    }

    public boolean isActiveMode() {
        return !this.isPassiveMode();
    }

    public boolean isAsciiTransferType() {
        return "ascii".equalsIgnoreCase(this.transferType);
    }

    public boolean isBinaryTransferType() {
        return "binary".equalsIgnoreCase(this.transferType);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isPassiveMode() {
        return "passive".equalsIgnoreCase(this.connectionMode);
    }

    public void setAttempt(int n) {
        this.attempt = n;
    }

    public void setDelay(long l) {
        this.delay = l;
    }

    public void setDeleteProcessedFile(boolean bl) {
        this.deleteProcessedFile = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setMaxConnection(int n) {
        this.maxConnection = n;
    }

    public void setMaxIdleTime(long l) {
        this.maxIdleTime = l;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    public String toString() {
        return "FTP Connection Info :server=" + this.server + "; port=" + this.port + "; user=" + this.user + "; password=" + this.password + "; directory=" + this.folder + "; transfer-type=" + this.transferType + "; connection-mode :" + this.connectionMode + "; encoding :" + this.encoding + "; overwrite :" + this.overwrite + "; delete processed  file :" + this.deleteProcessedFile;
    }

    public void validate() throws MissingElementException {
        if (StringHelper.isNullOrEmpty((String)this.server)) {
            throw new MissingElementException("server");
        }
        if (StringHelper.isNullOrEmpty((String)this.user)) {
            throw new MissingElementException("user");
        }
        if (StringHelper.isNullOrEmpty((String)this.password)) {
            throw new MissingElementException("password");
        }
        if (this.port == 0) {
            throw new MissingElementException("port");
        }
        if (this.connectionMode != null && !this.connectionMode.equalsIgnoreCase("active") && !this.connectionMode.equalsIgnoreCase("passive")) {
            throw new MissingElementException("connection-mode");
        }
        if (this.transferType != null && !this.transferType.equalsIgnoreCase("ascii") && !this.transferType.equalsIgnoreCase("binary")) {
            throw new MissingElementException("transfer-type");
        }
        if (this.encoding == null || !Charset.isSupported(this.encoding)) {
            this.encoding = Charset.defaultCharset().toString();
        }
    }
}

