/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.PoolableObjectFactory;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClient;

public class WrappedFTPClientFactory
implements PoolableObjectFactory {
    final FTPConnectionInfo connectionConfiguration;
    final Logger logger;

    public WrappedFTPClientFactory(FTPConnectionInfo fTPConnectionInfo, Logger logger) {
        this.logger = logger;
        this.connectionConfiguration = fTPConnectionInfo;
    }

    public Object makeObject() throws Exception {
        this.logger.finest("Create new instance of FTPClient");
        WrappedFTPClient wrappedFTPClient = new WrappedFTPClient(this.connectionConfiguration, this.logger);
        try {
            wrappedFTPClient.connectAndLog();
            wrappedFTPClient.configureConnection();
        }
        catch (IOException iOException) {
            this.destroyObject((Object)wrappedFTPClient);
            throw iOException;
        }
        return wrappedFTPClient;
    }

    public void destroyObject(Object object) throws Exception {
        WrappedFTPClient wrappedFTPClient = (WrappedFTPClient)((Object)object);
        if (wrappedFTPClient != null && wrappedFTPClient.isConnected()) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Log out user and disconnect FTP connection : [" + this.connectionConfiguration.toString() + "]");
            }
            wrappedFTPClient.logout();
            wrappedFTPClient.disconnect();
        }
    }

    public boolean validateObject(Object object) {
        this.logger.finest("Validate instance of FTPClientWrapped");
        WrappedFTPClient wrappedFTPClient = (WrappedFTPClient)((Object)object);
        Boolean bl = false;
        try {
            if (wrappedFTPClient.isConnected() && wrappedFTPClient.sendNoOp()) {
                this.logger.finest("FTPClient is connected");
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public void activateObject(Object object) throws Exception {
    }

    public void passivateObject(Object object) throws Exception {
    }
}

