/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easywsdl.wsdl.api.abstractElmt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ow2.easywsdl.schema.SchemaFactory;
import org.ow2.easywsdl.schema.api.Attribute;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Include;
import org.ow2.easywsdl.schema.api.Redefine;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.Type;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaImpl;
import org.ow2.easywsdl.wsdl.api.abstractElmt.AbstractWSDLElementImpl;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfTypes;

public abstract class AbstractTypesImpl<E, S extends Schema, Impt extends AbsItfImport>
extends AbstractWSDLElementImpl<E>
implements AbsItfTypes<S, Impt> {
    private static final long serialVersionUID = 1L;
    protected AbsItfDescription desc;
    protected List<S> schemas = new ArrayList<S>();
    protected List<Impt> importedSchemas = new ArrayList<Impt>();

    public AbstractTypesImpl(E e, AbstractWSDLElementImpl abstractWSDLElementImpl) {
        super(e, abstractWSDLElementImpl);
    }

    protected void addImportedSchemasInAllList() {
        for (AbsItfImport absItfImport : this.importedSchemas) {
            if (absItfImport.getSchema() == null) continue;
            this.schemas.add((Schema)absItfImport.getSchema());
        }
    }

    @Override
    public List<S> getSchemas() {
        if (this.schemas == null) {
            this.schemas = new ArrayList<S>();
        }
        return this.schemas;
    }

    @Override
    public List<Impt> getImportedSchemas() {
        if (this.importedSchemas == null) {
            this.importedSchemas = new ArrayList<Impt>();
        }
        return this.importedSchemas;
    }

    protected void setAllNamespacesInAllSchemas() {
        for (Schema schema : this.schemas) {
            Map<String, String> map = this.desc.getNamespaces().getNamespaces();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                schema.getAllNamespaces().addNamespace(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public String toString() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void addSchema(S s) {
        this.schemas.add(s);
    }

    protected void reloadAllListInAllSchema() {
        ArrayList<Schema> arrayList = new ArrayList<Schema>();
        for (AbsItfSchema<Type, Element, Attribute, Include, Import, Redefine> absItfSchema : this.schemas) {
            if (!arrayList.contains(absItfSchema)) {
                arrayList.add((Schema)absItfSchema);
            }
            for (AbsItfImport absItfImport : absItfSchema.getImports()) {
                if (absItfImport.getSchema() == null || arrayList.contains(absItfImport.getSchema())) continue;
                arrayList.add((Schema)absItfImport.getSchema());
            }
        }
        for (AbsItfSchema<Type, Element, Attribute, Include, Import, Redefine> absItfSchema : arrayList) {
            ((AbstractSchemaImpl)absItfSchema).addImportElementsInAllList();
            ((AbstractSchemaImpl)absItfSchema).addIncludeElementsInAllList();
            ((AbstractSchemaImpl)absItfSchema).addRedefineElementsInAllList();
        }
    }

    protected void setSchemaInAllImport() {
        boolean bl = false;
        for (Schema schema : this.schemas) {
            for (AbsItfImport absItfImport : schema.getImports()) {
                if (absItfImport.getSchema() != null) continue;
                absItfImport.setSchema(this.findSchema(absItfImport.getNamespaceURI()));
                bl = true;
            }
        }
        if (bl) {
            this.reloadAllListInAllSchema();
        }
    }

    protected AbsItfSchema findSchema(String string) {
        AbsItfSchema absItfSchema = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(string)) {
            absItfSchema = SchemaFactory.getDefaultSchema();
        } else {
            for (Schema schema : this.schemas) {
                if (schema == null || schema.getTargetNamespace() == null || !schema.getTargetNamespace().equals(string)) continue;
                absItfSchema = schema;
                break;
            }
        }
        return absItfSchema;
    }
}

