/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.component.framework.ComponentWsdl;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.PetalsComponent;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.ComponentInterceptor;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.mbean.InterceptorManager;
import org.ow2.petals.component.framework.mbean.MBeanHelper;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.process.JBIAcceptorManager;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.async.AsyncMessageManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class AbstractComponent
implements PetalsComponent {
    protected ComponentContext context;
    private JBIAcceptorManager acceptorManager;
    private AsyncMessageManager asyncManager;
    private DeliveryChannel channel;
    private ConfigurationExtensions componentExtensions;
    private Map<ServiceEndpointKey, ServiceEndpoint> componentServiceEndpoints;
    private InterceptorManager interceptorManager;
    private Map<String, Interceptor> interceptors;
    private Jbi jbiComponentConfiguration;
    private Logger logger;
    private Wsdl nativeWsdl;
    private JBIProcessorManager processorManager;
    private RuntimeConfigurationNotifier runtimeConfigurationNotifier;
    private AbstractServiceUnitManager suManager;

    public AsyncMessageManager getAsyncManager() {
        return this.asyncManager;
    }

    public DeliveryChannel getChannel() {
        return this.channel;
    }

    public Component getComponentConfiguration() {
        return this.jbiComponentConfiguration.getComponent();
    }

    public ConfigurationExtensions getComponentExtensions() {
        return this.componentExtensions;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public Interceptor getInterceptor(String string) {
        Interceptor interceptor = null;
        if (this.interceptors != null) {
            interceptor = this.interceptors.get(string);
        }
        return interceptor;
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Wsdl getNativeWsdl() {
        return this.nativeWsdl;
    }

    public Document getServiceDescription(ServiceEndpoint serviceEndpoint) {
        if (serviceEndpoint == null) {
            return null;
        }
        if (this.componentServiceEndpoints != null && !this.componentServiceEndpoints.isEmpty() && this.componentServiceEndpoints.get(new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName())) != null && this.nativeWsdl != null && WSDLUtilImpl.isDescriptionContaining(this.nativeWsdl.getDescription(), serviceEndpoint)) {
            return this.nativeWsdl.getDocument();
        }
        return this.suManager.getServiceDescription(serviceEndpoint);
    }

    public ServiceUnitManager getServiceUnitManager() {
        return this.suManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init(ComponentContext componentContext) throws JBIException {
        this.context = componentContext;
        this.logger = this.context.getLogger("", this.getResourceBundleName());
        this.logger.info("Init component...");
        this.channel = this.context.getDeliveryChannel();
        File file = new File(componentContext.getInstallRoot() + File.separator + "META-INF" + File.separator + "jbi.xml");
        try {
            File file2;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.jbiComponentConfiguration = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)fileInputStream);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.componentExtensions = this.jbiComponentConfiguration.getComponent().getPropertiesFile() != null && !StringHelper.isNullOrEmpty((String)this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) ? new ConfigurationExtensions(this.jbiComponentConfiguration.getComponent().getAny(), this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) : new ConfigurationExtensions(this.jbiComponentConfiguration.getComponent().getAny());
            this.runtimeConfigurationNotifier = new RuntimeConfigurationNotifier(this.jbiComponentConfiguration, file, this.logger);
            this.interceptors = this.loadInterceptors();
            this.interceptorManager = new InterceptorManager(this, this.jbiComponentConfiguration, file);
            if (this.suManager == null) {
                this.suManager = this.createServiceUnitManager();
            }
            if ((file2 = new File(componentContext.getWorkspaceRoot() + File.separator + "native-service" + File.separator + "component.wsdl")) != null && file2.exists()) {
                Description description = WSDLUtilImpl.createWsdlDescription(file2.toURI().toURL());
                this.nativeWsdl = new ComponentWsdl(description);
            }
            this.componentServiceEndpoints = new ConcurrentHashMap<ServiceEndpointKey, ServiceEndpoint>();
        }
        catch (CDKJBIDescriptorException cDKJBIDescriptorException) {
            throw new JBIException((Throwable)cDKJBIDescriptorException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JBIException((Throwable)fileNotFoundException);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new JBIException((Throwable)pEtALSCDKException);
        }
        catch (WSDLException wSDLException) {
            throw new JBIException((Throwable)wSDLException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new JBIException((Throwable)malformedURLException);
        }
        this.logger.fine("Calling initialization method on component implementation...");
        this.doInit();
        this.logger.fine("Specific initialization done.");
        this.processorManager = new JBIProcessorManager(this, this.runtimeConfigurationNotifier, this.logger);
        this.acceptorManager = new JBIAcceptorManager(this, this.processorManager, this.runtimeConfigurationNotifier, this.logger);
        this.asyncManager = new AsyncMessageManager(this.logger, this.processorManager);
        this.logger.info("Component initialized");
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) {
        return true;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint serviceEndpoint, MessageExchange messageExchange) {
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment documentFragment) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutDown() throws JBIException {
        this.logger.info("Shut down component...");
        try {
            this.logger.fine("Calling specific shut down...");
            this.doShutdown();
            this.logger.fine("Specific shut down done.");
        }
        finally {
            this.nativeWsdl = null;
            this.channel = null;
            this.runtimeConfigurationNotifier = null;
            this.interceptors = null;
            this.interceptorManager = null;
            this.acceptorManager = null;
            this.processorManager = null;
            this.asyncManager = null;
        }
        this.logger.info("Component shut down");
    }

    public final void start() throws JBIException {
        this.logger.info("Start component...");
        if (this.channel == null) {
            this.channel = this.context.getDeliveryChannel();
        }
        this.registerRuntimeConfigMBean();
        this.registerInterceptorManagerMBean();
        this.processorManager.start();
        this.acceptorManager.start();
        this.asyncManager.start();
        this.activateServiceEndpointList();
        this.logger.fine("Calling specific start...");
        this.doStart();
        this.logger.info("Component started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws JBIException {
        this.logger.info("Stop component...");
        try {
            this.logger.fine("Calling specific stop...");
            this.doStop();
            this.logger.fine("Specific stop done.");
        }
        finally {
            this.deactivateServiceEndpointList();
            this.unregisterRuntimeConfigurationMBean();
            this.unregisterInterceptorManagerMBean();
            this.acceptorManager.stop();
            this.processorManager.stop();
            this.asyncManager.stop();
        }
        this.logger.info("Component stopped");
    }

    protected abstract AbstractServiceUnitManager createServiceUnitManager();

    protected void doInit() throws JBIException {
    }

    protected void doShutdown() throws JBIException {
    }

    protected void doStart() throws JBIException {
    }

    protected void doStop() throws JBIException {
    }

    protected String getResourceBundleName() {
        return null;
    }

    public ServiceEndpoint activateEndpoint(QName qName, String string) throws JBIException {
        ServiceEndpointKey serviceEndpointKey = new ServiceEndpointKey(qName, string);
        this.componentServiceEndpoints.put(serviceEndpointKey, new ComponentServiceEndpoint(qName, string));
        ServiceEndpoint serviceEndpoint = this.context.activateEndpoint(qName, string);
        this.componentServiceEndpoints.put(serviceEndpointKey, serviceEndpoint);
        return serviceEndpoint;
    }

    private void activateServiceEndpointList() throws JBIException {
        Iterator<Endpoint> iterator;
        QName qName = null;
        String string = null;
        List<Endpoint> list = null;
        if (this.nativeWsdl != null && (list = WSDLUtilImpl.getEndpointList(this.nativeWsdl.getDescription())) != null && (iterator = list.iterator()) != null) {
            while (iterator.hasNext()) {
                Endpoint endpoint = iterator.next();
                if (endpoint == null) continue;
                qName = ((Service)endpoint.getService()).getQName();
                string = endpoint.getName();
                this.activateEndpoint(qName, string);
            }
        }
    }

    private void deactivateServiceEndpointList() throws JBIException {
        if (this.componentServiceEndpoints != null) {
            for (ServiceEndpointKey serviceEndpointKey : this.componentServiceEndpoints.keySet()) {
                this.deactivateEndpoint(this.componentServiceEndpoints.get(serviceEndpointKey));
            }
            this.componentServiceEndpoints.clear();
        }
    }

    public void deactivateEndpoint(ServiceEndpoint serviceEndpoint) throws JBIException {
        this.context.deactivateEndpoint(serviceEndpoint);
        this.componentServiceEndpoints.remove(new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()));
    }

    private final Map<String, Interceptor> loadInterceptors() {
        HashMap<String, Interceptor> hashMap = new HashMap<String, Interceptor>();
        if (this.jbiComponentConfiguration.getComponent().getComponentInterceptors() != null) {
            for (ComponentInterceptor componentInterceptor : this.jbiComponentConfiguration.getComponent().getComponentInterceptors().getInterceptor()) {
                try {
                    this.logger.info("Loading interceptor : " + componentInterceptor.getName());
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(componentInterceptor.getClazz());
                    Interceptor interceptor = (Interceptor)clazz.newInstance();
                    ConfigurationExtensions configurationExtensions = this.jbiComponentConfiguration.getComponent().getPropertiesFile() != null && !StringHelper.isNullOrEmpty((String)this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) ? new ConfigurationExtensions(componentInterceptor.getParam(), this.jbiComponentConfiguration.getComponent().getPropertiesFile().getValue()) : new ConfigurationExtensions(componentInterceptor.getParam());
                    interceptor.init((PetalsComponent)this, componentInterceptor.getName(), componentInterceptor.isActive(), (Map)configurationExtensions, this.logger);
                    hashMap.put(componentInterceptor.getName(), interceptor);
                }
                catch (PEtALSCDKException pEtALSCDKException) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", pEtALSCDKException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    this.logger.log(Level.WARNING, "Could not load or initialize interceptor '" + componentInterceptor.getName() + "' from class '" + componentInterceptor.getClazz() + "', this interceptor is skipped. Cause : ", classCastException);
                }
            }
        }
        return hashMap;
    }

    private void registerInterceptorManagerMBean() throws JBIException {
        ObjectName objectName = this.context.getMBeanNames().createCustomComponentMBeanName("interceptors_" + this.context.getComponentName());
        this.interceptorManager.setMBeanName(objectName);
        MBeanHelper.registerMBean(this.context.getMBeanServer(), objectName, this.interceptorManager);
    }

    private void registerRuntimeConfigMBean() throws JBIException {
        ObjectName objectName = this.context.getMBeanNames().createCustomComponentMBeanName("runtime_configuration_" + this.context.getComponentName());
        this.runtimeConfigurationNotifier.setMBeanName(objectName);
        MBeanHelper.registerMBean(this.context.getMBeanServer(), objectName, this.runtimeConfigurationNotifier);
    }

    private void unregisterInterceptorManagerMBean() throws JBIException {
        MBeanHelper.unregisterMBean(this.context.getMBeanServer(), this.interceptorManager.getMBeanName());
    }

    private void unregisterRuntimeConfigurationMBean() throws JBIException {
        MBeanHelper.unregisterMBean(this.context.getMBeanServer(), this.runtimeConfigurationNotifier.getMBeanName());
    }

    public JBIProcessorManager getProcessorManager() {
        return this.processorManager;
    }

    private static class ComponentServiceEndpoint
    implements ServiceEndpoint {
        private QName s = null;
        private String e = null;

        public ComponentServiceEndpoint(QName qName, String string) {
            this.s = qName;
            this.e = string;
        }

        public DocumentFragment getAsReference(QName qName) {
            return null;
        }

        public String getEndpointName() {
            return this.e;
        }

        public QName[] getInterfaces() {
            return null;
        }

        public QName getServiceName() {
            return this.s;
        }
    }
}

