/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.ow2.petals.component.framework.DefaultBootstrap;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.Runtimepositivestrictint;

public class ExtensionMBean
implements DynamicMBean {
    private static final String PROCESSOR_MAX_POOL_SIZE_ATTR_NAME = "processorMaxPoolSize";
    private static final String PROCESSOR_POOL_SIZE_ATTR_NAME = "processorPoolSize";
    private final List<AttributeSetterGetter> attributeSetterGetterList = new ArrayList<AttributeSetterGetter>();
    private static final Hashtable<String, Class<?>> primitiveClasses;
    private final DefaultBootstrap bootstrap;

    public ExtensionMBean(DefaultBootstrap defaultBootstrap) {
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.bootstrap = defaultBootstrap;
    }

    @Override
    public synchronized Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object = null;
        try {
            Field field = Component.class.getDeclaredField(string);
            field.setAccessible(true);
            Object object2 = field.get(this.bootstrap.getJbiComponentConfiguration().getComponent());
            if (object2 != null) {
                String string2 = "getValue";
                if (field.getType().getSimpleName().endsWith("boolean")) {
                    string2 = "isValue";
                }
                Method method = object2.getClass().getMethod(string2, new Class[0]);
                object = method.invoke(object2, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
            throw new AttributeNotFoundException("Attribute '" + string + "' is not reachable");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            boolean bl = false;
            try {
                for (AttributeSetterGetter attributeSetterGetter : this.attributeSetterGetterList) {
                    if (!attributeSetterGetter.attributeName.equals(string)) continue;
                    object = attributeSetterGetter.getter.invoke((Object)this.bootstrap, new Object[0]);
                    bl = true;
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ReflectionException(noSuchFieldException, noSuchFieldException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(noSuchFieldException, noSuchFieldException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ReflectionException(noSuchFieldException, noSuchFieldException.getMessage());
            }
            if (!bl) {
                throw new AttributeNotFoundException("Attribute '" + string + "' does not exist");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException, invocationTargetException.getMessage());
        }
        return object;
    }

    @Override
    public synchronized AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        for (String string : stringArray) {
            try {
                attributeList.add(new Attribute(string, this.getAttribute(string)));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                this.bootstrap.getLogger().warning("Failed to get attribute '" + string + "' in the extension MBean : " + attributeNotFoundException.getClass().getSimpleName() + " : " + attributeNotFoundException.getMessage());
            }
            catch (MBeanException mBeanException) {
                this.bootstrap.getLogger().warning("Failed to get attribute '" + string + "' in the extension MBean : " + mBeanException.getClass().getSimpleName() + " : " + mBeanException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                this.bootstrap.getLogger().warning("Failed to get attribute '" + string + "' in the extension MBean : " + reflectionException.getClass().getSimpleName() + " : " + reflectionException.getMessage());
            }
        }
        return attributeList;
    }

    private Field findInheritedField(Class<?> clazz, String string) throws NoSuchFieldException {
        Class<?> clazz2 = clazz;
        while (clazz2 != null) {
            try {
                return clazz2.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clazz2 = clazz2.getSuperclass()) != null) continue;
                throw noSuchFieldException;
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Field field = Component.class.getDeclaredField(attribute.getName());
            if (field.getType().equals(Runtimepositivestrictint.class)) {
                if (field.getName().equals(PROCESSOR_MAX_POOL_SIZE_ATTR_NAME) && (Integer)attribute.getValue() <= (Integer)this.getAttribute(PROCESSOR_POOL_SIZE_ATTR_NAME)) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to the processor core pool size.");
                }
                if (field.getName().equals(PROCESSOR_POOL_SIZE_ATTR_NAME) && (Integer)attribute.getValue() > (Integer)this.getAttribute(PROCESSOR_MAX_POOL_SIZE_ATTR_NAME)) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be lower or equals to the processor max pool size.");
                }
                if ((Integer)attribute.getValue() <= 0) {
                    throw new InvalidAttributeValueException("Invalid value for attribute '" + attribute.getName() + "': The value must be upper or equals to 1.");
                }
            }
            field.setAccessible(true);
            Object object = field.get(this.bootstrap.getJbiComponentConfiguration().getComponent());
            Field field2 = this.findInheritedField(field.getType(), "value");
            Method method = object.getClass().getMethod("setValue", field2.getType());
            method.invoke(object, attribute.getValue());
        }
        catch (SecurityException securityException) {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' is not reachable");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            boolean bl = false;
            try {
                for (AttributeSetterGetter attributeSetterGetter : this.attributeSetterGetterList) {
                    if (!attributeSetterGetter.attributeName.equals(attribute.getName())) continue;
                    attributeSetterGetter.setter.invoke((Object)this.bootstrap, attribute.getValue());
                    bl = true;
                    break;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ReflectionException(noSuchFieldException, noSuchFieldException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(noSuchFieldException, noSuchFieldException.getMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ReflectionException(noSuchFieldException, noSuchFieldException.getMessage());
            }
            if (!bl) {
                throw new AttributeNotFoundException("Attribute '" + attribute + "' does not exist");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException);
        }
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        for (Object e : attributeList) {
            try {
                this.setAttribute((Attribute)e);
            }
            catch (Throwable throwable) {
                this.bootstrap.getLogger().warning("Failed to set attribute '" + ((Attribute)e).getName() + "' in the extension MBean : " + throwable.getClass().getSimpleName() + " : " + throwable.getMessage());
            }
        }
        return attributeList2;
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object = null;
        Class<?>[] classArray = null;
        Class<?> clazz = this.bootstrap.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        if (stringArray != null) {
            classArray = this.findSignatureClasses(stringArray, classLoader);
        }
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (method == null) {
            throw new ReflectionException(new NoSuchMethodException(string), "The operation with name " + string + " could not be found");
        }
        try {
            object = method.invoke((Object)this.bootstrap, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "IllegalAccessException occured trying to invoke operation " + string);
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeOperationsException(runtimeException, "RuntimeException occured trying to invoke operation " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MBeanException(invocationTargetException, "Exception thrown in operation " + string);
        }
        return object;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.getAttributesInfos();
        MBeanOperationInfo[] mBeanOperationInfoArray = this.getOperationsInfos();
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", mBeanAttributeInfoArray, null, mBeanOperationInfoArray, null);
    }

    protected MBeanAttributeInfo[] getAttributesInfos() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = null;
        Field[] fieldArray = Component.class.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Component component = this.bootstrap.getJbiComponentConfiguration().getComponent();
        try {
            Method method;
            Object object;
            for (Field object22 : fieldArray) {
                if (!object22.getType().getSimpleName().startsWith("Runtime") && !object22.getType().getSimpleName().startsWith("Settable")) continue;
                object22.setAccessible(true);
                if (object22.get(component) == null) continue;
                arrayList.add(object22);
            }
            List<String> list = this.bootstrap.getAttributeList();
            int n = 0;
            mBeanAttributeInfoArray = new MBeanAttributeInfo[arrayList.size() + list.size()];
            Method[] methodArray = this.bootstrap.getClass().getMethods();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object = null;
                method = null;
                for (Method method2 : methodArray) {
                    if (method2.getName().equalsIgnoreCase("set" + string)) {
                        object = method2;
                        continue;
                    }
                    if (!method2.getName().equalsIgnoreCase("get" + string) && !method2.getName().equalsIgnoreCase("is" + string)) continue;
                    method = method2;
                }
                mBeanAttributeInfoArray[n] = new MBeanAttributeInfo(string, "Property " + string, method, (Method)object);
                this.attributeSetterGetterList.add(new AttributeSetterGetter(string, method, (Method)object));
                ++n;
            }
            for (Field field : arrayList) {
                object = field.get(component);
                method = field.getType().getSimpleName().endsWith("boolean") ? object.getClass().getMethod("isValue", new Class[0]) : object.getClass().getMethod("getValue", new Class[0]);
                Field field2 = this.findInheritedField(field.getType(), "value");
                Method method3 = object.getClass().getMethod("setValue", field2.getType());
                mBeanAttributeInfoArray[n] = new MBeanAttributeInfo(field.getName(), "Property " + field.getName(), method, method3);
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + illegalArgumentException.getClass().getSimpleName() + " : " + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + illegalAccessException.getClass().getSimpleName() + " : " + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + securityException.getClass().getSimpleName() + " : " + securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + noSuchMethodException.getClass().getSimpleName() + " : " + noSuchMethodException.getMessage());
        }
        catch (IntrospectionException introspectionException) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + introspectionException.getClass().getSimpleName() + " : " + introspectionException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.bootstrap.getLogger().warning("Failed to initialize fields of the Bootstrap extension MBean : " + noSuchFieldException.getClass().getSimpleName() + " : " + noSuchFieldException.getMessage());
        }
        return mBeanAttributeInfoArray;
    }

    protected MBeanOperationInfo[] getOperationsInfos() {
        List<String> list = this.bootstrap.getMethodList();
        ArrayList<MBeanOperationInfo> arrayList = new ArrayList<MBeanOperationInfo>();
        Method[] methodArray = this.bootstrap.getClass().getMethods();
        for (Method method : methodArray) {
            String string = method.getName();
            if (!list.contains(string)) continue;
            MBeanOperationInfo mBeanOperationInfo = new MBeanOperationInfo("Operation description", method);
            arrayList.add(mBeanOperationInfo);
        }
        Object[] objectArray = new MBeanOperationInfo[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private Class<?>[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        Class[] classArray = new Class[n];
        if (n == 0) {
            return classArray;
        }
        try {
            for (int i = 0; i < n; ++i) {
                Class<?> clazz = primitiveClasses.get(stringArray[i]);
                classArray[i] = clazz != null ? clazz : Class.forName(stringArray[i], false, classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        return classArray;
    }

    static {
        try {
            Component.class.getDeclaredField(PROCESSOR_MAX_POOL_SIZE_ATTR_NAME);
            Component.class.getDeclaredField(PROCESSOR_POOL_SIZE_ATTR_NAME);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        primitiveClasses = new Hashtable(8);
    }

    private static class AttributeSetterGetter {
        public String attributeName;
        public Method getter;
        public Method setter;

        public AttributeSetterGetter(String string, Method method, Method method2) {
            this.attributeName = string;
            this.getter = method;
            this.setter = method2;
        }
    }
}

