/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.interceptor;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.SUInterceptor;

public class MessageInterceptorManager {
    private Map<String, Interceptor> inputOrderedInterceptors;
    private Map<String, Interceptor> inputResponseOrderedInterceptors;
    private Map<String, Interceptor> outputOrderedInterceptors;
    private Map<String, Interceptor> outputResponseOrderedInterceptors;
    private Map<String, ConfigurationExtensions> inputAdditionalConfiguration;
    private Map<String, ConfigurationExtensions> inputResponseAdditionalConfiguration;
    private Map<String, ConfigurationExtensions> outputAdditionalConfiguration;
    private Map<String, ConfigurationExtensions> outputResponseAdditionalConfiguration;
    private Logger logger;
    private String propertiesFilePath;

    public MessageInterceptorManager(Logger logger) {
        this.logger = logger;
        this.inputOrderedInterceptors = new LinkedHashMap<String, Interceptor>();
        this.inputResponseOrderedInterceptors = new LinkedHashMap<String, Interceptor>();
        this.outputOrderedInterceptors = new LinkedHashMap<String, Interceptor>();
        this.outputResponseOrderedInterceptors = new LinkedHashMap<String, Interceptor>();
        this.inputAdditionalConfiguration = new HashMap<String, ConfigurationExtensions>();
        this.inputResponseAdditionalConfiguration = new HashMap<String, ConfigurationExtensions>();
        this.outputAdditionalConfiguration = new HashMap<String, ConfigurationExtensions>();
        this.outputResponseAdditionalConfiguration = new HashMap<String, ConfigurationExtensions>();
    }

    public MessageInterceptorManager(String string, Logger logger) {
        this(logger);
        this.propertiesFilePath = string;
    }

    public void init(Map<String, Interceptor> map, List<SUInterceptor> list, List<SUInterceptor> list2, List<SUInterceptor> list3, List<SUInterceptor> list4) {
        this.logger.fine("Initializing interceptor manager");
        this.initInterceptor(map, list, this.inputOrderedInterceptors, this.inputAdditionalConfiguration);
        this.initInterceptor(map, list3, this.inputResponseOrderedInterceptors, this.inputResponseAdditionalConfiguration);
        this.initInterceptor(map, list2, this.outputOrderedInterceptors, this.outputAdditionalConfiguration);
        this.initInterceptor(map, list4, this.outputResponseOrderedInterceptors, this.outputResponseAdditionalConfiguration);
    }

    protected void initInterceptor(Map<String, Interceptor> map, List<SUInterceptor> list, Map<String, Interceptor> map2, Map<String, ConfigurationExtensions> map3) {
        this.logger.fine("Initializing interceptors...");
        for (Interceptor interceptor : map.values()) {
            if (!interceptor.isActive()) continue;
            map2.put(interceptor.getName(), interceptor);
        }
        if (list != null) {
            for (SUInterceptor sUInterceptor : list) {
                String string = sUInterceptor.getName();
                try {
                    ConfigurationExtensions configurationExtensions = this.propertiesFilePath != null ? new ConfigurationExtensions(sUInterceptor.getParam(), this.propertiesFilePath) : new ConfigurationExtensions(sUInterceptor.getParam());
                    map3.put(string, configurationExtensions);
                }
                catch (PEtALSCDKException pEtALSCDKException) {
                    this.logger.warning("Failed to set additional configuration for interceptor '" + string + "'. Skip it");
                }
                Interceptor interceptor = map.get(string);
                if (interceptor != null && !map2.containsKey(string)) {
                    map2.put(interceptor.getName(), interceptor);
                    continue;
                }
                this.logger.warning("Interceptor '" + string + "' not found in component available interceptors. Skip it");
            }
        }
    }

    public void addGlobalInterceptor(Interceptor interceptor) {
        this.inputOrderedInterceptors.put(interceptor.getName(), interceptor);
        this.inputResponseOrderedInterceptors.put(interceptor.getName(), interceptor);
        this.outputOrderedInterceptors.put(interceptor.getName(), interceptor);
        this.outputResponseOrderedInterceptors.put(interceptor.getName(), interceptor);
    }

    public Map<String, Interceptor> getInputOrderedInterceptors() {
        return this.inputOrderedInterceptors;
    }

    public Map<String, Interceptor> getOutputOrderedInterceptors() {
        return this.outputOrderedInterceptors;
    }

    public Map<String, ConfigurationExtensions> getInputAdditionalConfiguration() {
        return this.inputAdditionalConfiguration;
    }

    public Map<String, ConfigurationExtensions> getOutputAdditionalConfiguration() {
        return this.outputAdditionalConfiguration;
    }

    public Map<String, Interceptor> getInputResponseOrderedInterceptors() {
        return this.inputResponseOrderedInterceptors;
    }

    public Map<String, Interceptor> getOutputResponseOrderedInterceptors() {
        return this.outputResponseOrderedInterceptors;
    }

    public Map<String, ConfigurationExtensions> getInputResponseAdditionalConfiguration() {
        return this.inputResponseAdditionalConfiguration;
    }

    public Map<String, ConfigurationExtensions> getOutputResponseAdditionalConfiguration() {
        return this.outputResponseAdditionalConfiguration;
    }
}

