/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.listener;

import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.ExchangeProperties;
import org.ow2.petals.component.framework.jbidescriptor.generated.MEPType;
import org.ow2.petals.component.framework.jbidescriptor.generated.MessageParam;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.MessageInterceptorProcessor;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;

public abstract class AbstractListener {
    protected AbstractComponent component;
    protected MessageExchangeFactory factory;
    private Consumes consumes;
    private Provides provides;
    private ConfigurationExtensions extensions;
    private Transaction currentTransaction;
    protected MessageInterceptorProcessor messageInterceptorProcessor;

    public Exchange createConsumeExchange(Consumes consumes) throws MessagingException, PEtALSCDKException {
        Message.MEPConstants mEPConstants = this.retrievePattern(consumes);
        Exchange exchange = this.createConsumeExchange(consumes, mEPConstants);
        return exchange;
    }

    public Exchange createConsumeExchange(Consumes consumes, Message.MEPConstants mEPConstants) throws MessagingException, PEtALSCDKException {
        Exchange exchange = this.createExchange(mEPConstants);
        this.setOperation(exchange, consumes);
        this.setProperties(exchange, consumes);
        this.setEndpoint(exchange, consumes);
        return exchange;
    }

    public Exchange createExchange(Message.MEPConstants mEPConstants) throws MessagingException, PEtALSCDKException {
        MessageExchange messageExchange = null;
        if (mEPConstants == null) {
            throw new PEtALSCDKException("MEP cannot be null when creating an exchange");
        }
        messageExchange = this.factory.createExchange(mEPConstants.value());
        try {
            if (this.currentTransaction != null && this.currentTransaction.getStatus() == 0) {
                messageExchange.setProperty("javax.jbi.transaction.jta", (Object)this.currentTransaction);
            }
        }
        catch (SystemException systemException) {
            throw new PEtALSCDKException("Failed to get current transaction", (Throwable)systemException);
        }
        return new ExchangeImpl(messageExchange);
    }

    public AbstractComponent getComponent() {
        return this.component;
    }

    @Deprecated
    public ComponentContext getComponentContext() {
        return this.component.getContext();
    }

    public Consumes getConsumes() {
        return this.consumes;
    }

    public Transaction getCurrentTransaction() throws PEtALSCDKException {
        TransactionManager transactionManager;
        if (this.currentTransaction == null && (transactionManager = (TransactionManager)this.component.getContext().getTransactionManager()) != null) {
            try {
                transactionManager.begin();
                this.currentTransaction = transactionManager.getTransaction();
            }
            catch (NotSupportedException notSupportedException) {
                throw new PEtALSCDKException("Failed to create a Transaction", (Throwable)notSupportedException);
            }
            catch (SystemException systemException) {
                throw new PEtALSCDKException("Failed to create a Transaction", (Throwable)systemException);
            }
        }
        return this.currentTransaction;
    }

    public ConfigurationExtensions getExtensions() {
        return this.extensions;
    }

    public String getInstallRoot() {
        AbstractServiceUnitManager abstractServiceUnitManager = (AbstractServiceUnitManager)this.getComponent().getServiceUnitManager();
        String string = null;
        string = this.consumes != null ? abstractServiceUnitManager.getSUDataHandlerForConsumes(this.consumes).getInstallRoot() : abstractServiceUnitManager.getSUDataHandlerForProvides(this.provides).getInstallRoot();
        return string;
    }

    public Logger getLogger() {
        return this.component.getLogger();
    }

    public MessageInterceptorProcessor getMessageInterceptorProcessor() {
        return this.messageInterceptorProcessor;
    }

    public Provides getProvides() {
        return this.provides;
    }

    public void init() {
    }

    public final void init(AbstractComponent abstractComponent) {
        this.component = abstractComponent;
        this.messageInterceptorProcessor = new MessageInterceptorProcessor(this.component, this.getLogger());
        this.factory = this.getComponent().getChannel().createExchangeFactory();
    }

    public void send(Exchange exchange) throws MessagingException {
        this.component.getLogger().fine("Send an asynchronous exchange with id : " + exchange.getExchangeId());
        if (exchange.isOutMessage() || exchange.getFault() != null) {
            try {
                this.interceptAcceptResponse(exchange);
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                throw new MessagingException((Throwable)pEtALSCDKException);
            }
        }
        try {
            this.interceptSend(exchange);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException((Throwable)pEtALSCDKException);
        }
        if (exchange.getProperty("org.ow2.petals.component.framework.asynchronous.original") != null) {
            this.component.getAsyncManager().removeAsyncContext(exchange.getExchangeId());
        }
        this.getComponent().getChannel().send(((ExchangeImpl)exchange).getMessageExchange());
    }

    public void sendAsync(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        this.component.getAsyncManager().addAsyncContext(exchange, asyncContext);
        try {
            this.send(exchange);
        }
        catch (MessagingException messagingException) {
            this.component.getAsyncManager().removeAsyncContext(exchange.getExchangeId());
            throw messagingException;
        }
    }

    public boolean sendSync(Exchange exchange) throws MessagingException {
        long l = 30000L;
        if (this.consumes != null && this.consumes.getTimeout() != null) {
            l = this.consumes.getTimeout();
        } else if (this.provides != null && this.provides.getTimeout() != null) {
            l = this.provides.getTimeout();
        }
        return this.sendSync(exchange, l);
    }

    public boolean sendSync(Exchange exchange, long l) throws MessagingException {
        boolean bl = false;
        try {
            this.interceptSend(exchange);
            this.component.getLogger().finest("Send a synchronous exchange with id : " + exchange.getExchangeId());
            bl = this.getComponent().getChannel().sendSync(((ExchangeImpl)exchange).getMessageExchange(), l);
            this.interceptSendResponse(exchange);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException((Throwable)pEtALSCDKException);
        }
        catch (JBIException jBIException) {
            throw new MessagingException((Throwable)jBIException);
        }
        return bl;
    }

    public final void setConsumes(Consumes consumes) {
        this.consumes = consumes;
    }

    public final void setCurrentTransaction(Transaction transaction) {
        this.currentTransaction = transaction;
    }

    public final void setExtensions(ConfigurationExtensions configurationExtensions) {
        this.extensions = configurationExtensions;
    }

    public final void setProvides(Provides provides) {
        this.provides = provides;
    }

    protected final Message.MEPConstants retrievePattern(Consumes consumes) throws MessagingException {
        Message.MEPConstants mEPConstants = null;
        if (consumes.getMep() != null) {
            if (MEPType.IN_ONLY.equals((Object)consumes.getMep())) {
                mEPConstants = Message.MEPConstants.IN_ONLY_PATTERN;
            } else if (MEPType.ROBUST_IN_ONLY.equals((Object)consumes.getMep())) {
                mEPConstants = Message.MEPConstants.ROBUST_IN_ONLY_PATTERN;
            } else if (MEPType.IN_OUT.equals((Object)consumes.getMep())) {
                mEPConstants = Message.MEPConstants.IN_OUT_PATTERN;
            } else if (MEPType.IN_OPTIONAL_OUT.equals((Object)consumes.getMep())) {
                mEPConstants = Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN;
            } else {
                throw new MessagingException("MEP pattern '" + consumes.getMep().value() + "' is not valid");
            }
        }
        return mEPConstants;
    }

    private void interceptSend(Exchange exchange) throws PEtALSCDKException {
        if (this.consumes != null) {
            this.messageInterceptorProcessor.intercept(exchange, this.consumes, Message.InterceptorPhase.SEND);
        }
    }

    private void interceptSendResponse(Exchange exchange) throws PEtALSCDKException {
        if (this.consumes != null) {
            this.messageInterceptorProcessor.intercept(exchange, this.consumes, Message.InterceptorPhase.SEND_RESPONSE);
        }
    }

    private void interceptAcceptResponse(Exchange exchange) throws PEtALSCDKException {
        Provides provides = ((AbstractServiceUnitManager)this.getComponent().getServiceUnitManager()).getProvidesFromEndpoint(exchange.getEndpoint());
        if (provides != null) {
            this.messageInterceptorProcessor.intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
        }
    }

    private void setEndpoint(Exchange exchange, Consumes consumes) {
        ServiceEndpoint serviceEndpoint = null;
        if (consumes.getEndpointName() != null && consumes.getServiceName() != null) {
            serviceEndpoint = this.getComponent().getContext().getEndpoint(consumes.getServiceName(), consumes.getEndpointName());
        }
        exchange.setInterfaceName(consumes.getInterfaceName());
        exchange.setService(consumes.getServiceName());
        exchange.setEndpoint(serviceEndpoint);
        if (consumes.getLinkType() != null) {
            exchange.setProperty("org.ow2.petals.router.provider.linktype", (Object)consumes.getLinkType().value());
        }
    }

    private final void setOperation(Exchange exchange, Consumes consumes) {
        if (consumes.getOperation() != null) {
            exchange.setOperation(consumes.getOperation());
        }
    }

    private final void setProperties(Exchange exchange, Consumes consumes) throws MessagingException {
        Object object;
        ExchangeProperties exchangeProperties = consumes.getExchangeProperties();
        if (exchangeProperties != null) {
            object = exchangeProperties.getExchangeProperty().iterator();
            while (object.hasNext()) {
                Param param = (Param)object.next();
                exchange.setProperty(param.getName(), (Object)param.getValue());
            }
        }
        if ((object = consumes.getMessageProperties()) != null) {
            for (MessageParam messageParam : object.getMessageProperty()) {
                NormalizedMessage normalizedMessage = ((ExchangeImpl)exchange).getMessageExchange().getMessage(messageParam.getMessage().name());
                normalizedMessage.setProperty(messageParam.getName(), (Object)messageParam.getValue());
            }
        }
    }
}

