/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.mbean;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.ObjectName;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.PetalsComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.ComponentInterceptor;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.mbean.InterceptorManagerMBean;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class InterceptorManager
implements InterceptorManagerMBean {
    private AbstractComponent component;
    private Logger logger;
    private ObjectName mBeanName;
    private Jbi jbiComponentConfiguration;
    private File jbiComponentFile;

    public InterceptorManager(AbstractComponent abstractComponent, Jbi jbi, File file) {
        this.component = abstractComponent;
        this.jbiComponentConfiguration = jbi;
        this.jbiComponentFile = file;
        this.logger = abstractComponent.getLogger();
    }

    @Override
    public void addInterceptor(String string, String string2) throws MBeanException {
        Interceptor interceptor;
        ComponentInterceptor componentInterceptor;
        this.logger.log(Level.INFO, "Add interceptor " + string2);
        if (this.component.getInterceptor(string2) != null) {
            throw new MBeanException(new Exception("This interceptor is already registered"));
        }
        try {
            componentInterceptor = Thread.currentThread().getContextClassLoader().loadClass(string);
            interceptor = (Interceptor)componentInterceptor.newInstance();
            interceptor.init((PetalsComponent)this.component, string2, false, new HashMap(), this.logger);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MBeanException((Exception)((Object)pEtALSCDKException));
        }
        catch (InstantiationException instantiationException) {
            throw new MBeanException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MBeanException(illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new MBeanException(classCastException);
        }
        componentInterceptor = new ComponentInterceptor();
        componentInterceptor.setActive(false);
        componentInterceptor.setClazz(string);
        componentInterceptor.setName(string2);
        Map<String, Interceptor> map = this.component.getInterceptors();
        map.put(string2, interceptor);
        List list = this.component.getComponentConfiguration().getComponentInterceptors().getInterceptor();
        list.add(componentInterceptor);
        this.save();
    }

    @Override
    public void engageInterceptor(String string) throws MBeanException {
        this.logger.log(Level.INFO, "Engage interceptor " + string);
        Interceptor interceptor = this.component.getInterceptor(string);
        if (interceptor == null) {
            throw new MBeanException(new Exception("Failed to retrieve interceptor named '" + string + "'"));
        }
        if (!interceptor.isActive()) {
            AbstractServiceUnitManager abstractServiceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
            for (ServiceUnitDataHandler object2 : abstractServiceUnitManager.getServiceUnitDataHandlers().values()) {
                for (MessageInterceptorManager messageInterceptorManager : object2.getMessageInterceptorManagersMap().values()) {
                    messageInterceptorManager.addGlobalInterceptor(interceptor);
                }
            }
            interceptor.setActive(true);
            List list = this.component.getComponentConfiguration().getComponentInterceptors().getInterceptor();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ComponentInterceptor componentInterceptor = (ComponentInterceptor)iterator.next();
                if (!componentInterceptor.getName().equals(interceptor.getName())) continue;
                componentInterceptor.setActive(true);
                this.save();
                break;
            }
        }
    }

    public void setMBeanName(ObjectName objectName) {
        this.mBeanName = objectName;
    }

    public ObjectName getMBeanName() {
        return this.mBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.jbiComponentFile);
            try {
                JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)this.jbiComponentConfiguration, (OutputStream)fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (CDKJBIDescriptorException cDKJBIDescriptorException) {
            this.logger.warning("Failed to persist modification of the Interceptor manager MBean : " + ((Object)((Object)cDKJBIDescriptorException)).getClass().getSimpleName() + " : " + cDKJBIDescriptorException.getMessage());
        }
        catch (IOException iOException) {
            this.logger.warning("Failed to persist modification of the Interceptor manager MBean : " + iOException.getClass().getSimpleName() + " : " + iOException.getMessage());
        }
    }
}

