/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.mbean;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Component;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;

public class RuntimeConfigurationNotifier
implements DynamicMBean,
NotificationEmitter {
    private final NotificationBroadcasterSupport broadcasterSupport;
    private ObjectName mbeanName;
    private final AtomicLong seqNumber;
    private final Logger logger;
    private final Jbi jbiComponentConfiguration;
    private final File jbiComponentFile;

    public RuntimeConfigurationNotifier(Jbi jbi, File file, Logger logger) {
        this.jbiComponentConfiguration = jbi;
        this.jbiComponentFile = file;
        this.broadcasterSupport = new NotificationBroadcasterSupport();
        this.seqNumber = new AtomicLong(0L);
        this.logger = logger;
    }

    @Override
    public synchronized Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object = null;
        try {
            Field field = Component.class.getDeclaredField(string);
            field.setAccessible(true);
            Object object2 = field.get(this.jbiComponentConfiguration.getComponent());
            if (object2 != null) {
                String string2 = "getValue";
                if (field.getType().getSimpleName().endsWith("boolean")) {
                    string2 = "isValue";
                }
                Method method = object2.getClass().getMethod(string2, new Class[0]);
                object = method.invoke(object2, new Object[0]);
            }
        }
        catch (SecurityException securityException) {
            throw new AttributeNotFoundException("Attribute '" + string + "' is not reachable");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AttributeNotFoundException("Attribute '" + string + "' does not exist");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, illegalAccessException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException, invocationTargetException.getMessage());
        }
        return object;
    }

    @Override
    public synchronized AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        for (String string : stringArray) {
            try {
                attributeList.add(new Attribute(string, this.getAttribute(string)));
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                this.logger.warning("Failed to get attribute '" + string + "' in the runtime configuration MBean : " + attributeNotFoundException.getClass().getSimpleName() + " : " + attributeNotFoundException.getMessage());
            }
            catch (MBeanException mBeanException) {
                this.logger.warning("Failed to get attribute '" + string + "' in the runtime configuration MBean : " + mBeanException.getClass().getSimpleName() + " : " + mBeanException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                this.logger.warning("Failed to get attribute '" + string + "' in the runtime configuration MBean : " + reflectionException.getClass().getSimpleName() + " : " + reflectionException.getMessage());
            }
        }
        return attributeList;
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            Field field = Component.class.getDeclaredField(attribute.getName());
            field.setAccessible(true);
            Object object = field.get(this.jbiComponentConfiguration.getComponent());
            String string = "getValue";
            if (field.getType().getSimpleName().endsWith("boolean")) {
                string = "isValue";
            }
            Method method = object.getClass().getMethod(string, new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            Field field2 = field.getType().getDeclaredField("value");
            method = object.getClass().getMethod("setValue", field2.getType());
            method.invoke(object, attribute.getValue());
            this.saveAndNotifyListeners(attribute.getName() + "modified", attribute.getName(), object2, attribute.getValue());
        }
        catch (SecurityException securityException) {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' is not reachable");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' does not exist");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ReflectionException(invocationTargetException);
        }
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        for (Object e : attributeList) {
            Attribute attribute = (Attribute)e;
            try {
                this.setAttribute(attribute);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + attributeNotFoundException.getClass().getSimpleName() + " : " + attributeNotFoundException.getMessage());
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + invalidAttributeValueException.getClass().getSimpleName() + " : " + invalidAttributeValueException.getMessage());
            }
            catch (MBeanException mBeanException) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + mBeanException.getClass().getSimpleName() + " : " + mBeanException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                this.logger.warning("Failed to set attribute '" + attribute.getName() + "' in the runtime configuration MBean : " + reflectionException.getClass().getSimpleName() + " : " + reflectionException.getMessage());
            }
        }
        return attributeList2;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = this.getAttributesInfos();
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(null, "Runtime MBean notifier", "Runtime configuration modification notifier");
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{mBeanNotificationInfo};
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", mBeanAttributeInfoArray, null, null, mBeanNotificationInfoArray);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Change runtime configuration attribute")};
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        this.broadcasterSupport.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    public ObjectName getMBeanName() {
        return this.mbeanName;
    }

    public void setMBeanName(ObjectName objectName) {
        this.mbeanName = objectName;
    }

    protected MBeanAttributeInfo[] getAttributesInfos() {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = null;
        Field[] fieldArray = Component.class.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        try {
            for (AccessibleObject accessibleObject : fieldArray) {
                if (!accessibleObject.getType().getSimpleName().startsWith("Runtime")) continue;
                accessibleObject.setAccessible(true);
                if (accessibleObject.get(this.jbiComponentConfiguration.getComponent()) == null) continue;
                arrayList.add((Field)accessibleObject);
            }
            mBeanAttributeInfoArray = new MBeanAttributeInfo[arrayList.size()];
            for (Field field : arrayList) {
                AccessibleObject accessibleObject;
                Object object = field.get(this.jbiComponentConfiguration.getComponent());
                accessibleObject = field.getType().getSimpleName().endsWith("boolean") ? object.getClass().getMethod("isValue", new Class[0]) : object.getClass().getMethod("getValue", new Class[0]);
                Field field2 = field.getType().getDeclaredField("value");
                Method method = object.getClass().getMethod("setValue", field2.getType());
                mBeanAttributeInfoArray[arrayList.indexOf((Object)field)] = new MBeanAttributeInfo(field.getName(), "Property " + field.getName(), (Method)accessibleObject, method);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + illegalArgumentException.getClass().getSimpleName() + " : " + illegalArgumentException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + illegalAccessException.getClass().getSimpleName() + " : " + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + securityException.getClass().getSimpleName() + " : " + securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + noSuchMethodException.getClass().getSimpleName() + " : " + noSuchMethodException.getMessage());
        }
        catch (IntrospectionException introspectionException) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + introspectionException.getClass().getSimpleName() + " : " + introspectionException.getMessage());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.logger.warning("Failed to initialize fields of the runtime configuration MBean : " + noSuchFieldException.getClass().getSimpleName() + " : " + noSuchFieldException.getMessage());
        }
        return mBeanAttributeInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAndNotifyListeners(String string, String string2, Object object, Object object2) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.jbiComponentFile);
            JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)this.jbiComponentConfiguration, (OutputStream)fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warning("Failed to pesist modification of the runtime configuration MBean : " + fileNotFoundException.getClass().getSimpleName() + " : " + fileNotFoundException.getMessage());
        }
        catch (CDKJBIDescriptorException cDKJBIDescriptorException) {
            this.logger.warning("Failed to pesist modification of the runtime configuration MBean : " + ((Object)((Object)cDKJBIDescriptorException)).getClass().getSimpleName() + " : " + cDKJBIDescriptorException.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                this.logger.warning("Can't close jbi component file output stream : " + iOException.getMessage());
            }
        }
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, this.seqNumber.getAndIncrement(), System.currentTimeMillis(), string, string2, String.class.getName(), object, object2);
        this.broadcasterSupport.sendNotification(attributeChangeNotification);
    }
}

