/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.message;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.component.framework.util.WSAHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class ExchangeImpl
implements Exchange {
    private Map<QName, String> addressingCache;
    private boolean checkRole;
    private final MessageExchange exchange;
    private NormalizedMessage inNormalizedExchange;
    private NormalizedMessage outNormalizedExchange;

    public ExchangeImpl(MessageExchange messageExchange) {
        this.exchange = messageExchange;
        this.inNormalizedExchange = this.exchange.getMessage("in");
        this.outNormalizedExchange = this.exchange.getMessage("out");
        this.checkRole = true;
    }

    private static final void copyAttachments(Map<String, DataHandler> map, NormalizedMessage normalizedMessage) throws MessagingException {
        for (Map.Entry<String, DataHandler> entry : map.entrySet()) {
            normalizedMessage.addAttachment(entry.getKey(), entry.getValue());
        }
    }

    private static final void copyMessageProperties(Map<String, Object> map, NormalizedMessage normalizedMessage) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            normalizedMessage.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public void addInMessageAttachment(String string, DataHandler dataHandler) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.addAttachment(string, dataHandler);
        this.setInMessage(normalizedMessage);
    }

    public void addOutMessageAttachment(String string, DataHandler dataHandler) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.addAttachment(string, dataHandler);
        this.setOutMessage(normalizedMessage);
    }

    public Fault createFault() throws MessagingException {
        return this.exchange.createFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return this.exchange.createMessage();
    }

    public ServiceEndpoint getEndpoint() {
        return this.exchange.getEndpoint();
    }

    public String getEndpointName() throws MessagingException {
        ServiceEndpoint serviceEndpoint = this.exchange.getEndpoint();
        if (serviceEndpoint == null) {
            throw new MessagingException("You must specify an endpoint in the message exchange");
        }
        return serviceEndpoint.getEndpointName();
    }

    public Exception getError() {
        return this.exchange.getError();
    }

    public String getExchangeId() {
        return this.exchange.getExchangeId();
    }

    public URI getExchangePattern() throws MessagingException {
        URI uRI = this.exchange.getPattern();
        if (uRI == null) {
            throw new MessagingException("You must specify a message exchange pattern in the message exchange");
        }
        return uRI;
    }

    public Fault getFault() {
        return this.exchange.getFault();
    }

    public Map<QName, String> getInAddressing() {
        Map<QName, String> map = null;
        if (this.addressingCache == null) {
            Object object;
            if (this.inNormalizedExchange != null && (object = this.inNormalizedExchange.getProperty("javax.jbi.messaging.protocol.headers")) != null && object instanceof Map) {
                String string;
                String string2;
                Map map2 = (Map)object;
                map = new HashMap<QName, String>();
                String string3 = WSAHelper.getTo(map2);
                if (string3 != null) {
                    map.put(Constants.WSStar.Addressing.TO_QNAME, string3);
                }
                if ((string2 = WSAHelper.getFrom(map2)) != null) {
                    map.put(Constants.WSStar.Addressing.FROM_QNAME, string2);
                }
                if ((string = WSAHelper.getReplyTo(map2)) != null) {
                    map.put(Constants.WSStar.Addressing.REPLY_TO_QNAME, string);
                }
            }
            this.addressingCache = map;
        } else {
            map = this.addressingCache;
        }
        return map;
    }

    public NormalizedMessage getInMessage() {
        if (this.inNormalizedExchange == null) {
            if (this.exchange.getMessage("in") != null) {
                return this.exchange.getMessage("in");
            }
            try {
                this.inNormalizedExchange = this.exchange.createMessage();
                this.exchange.setMessage(this.inNormalizedExchange, "in");
            }
            catch (MessagingException messagingException) {
                return null;
            }
        }
        return this.inNormalizedExchange;
    }

    public DataHandler getInMessageAttachment(String string) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return normalizedMessage.getAttachment(string);
    }

    public Set<String> getInMessageAttachmentNames() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return normalizedMessage.getAttachmentNames();
    }

    public Set<DataHandler> getInMessageAttachments() throws MessagingException {
        HashSet<DataHandler> hashSet = new HashSet<DataHandler>();
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        Set set = normalizedMessage.getAttachmentNames();
        for (Object e : set) {
            DataHandler dataHandler = normalizedMessage.getAttachment((String)e);
            if (dataHandler == null) continue;
            hashSet.add(dataHandler);
        }
        return hashSet;
    }

    public Document getInMessageContentAsDocument() throws MessagingException {
        return this.getInMessageContentAsDocument(false);
    }

    public Document getInMessageContentAsDocument(boolean bl) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        Document document = null;
        Source source = normalizedMessage.getContent();
        try {
            if (source != null) {
                document = SourceUtil.createDocument(source, bl);
            }
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException((Throwable)pEtALSCDKException);
        }
        return document;
    }

    public Source getInMessageContentAsSource() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return normalizedMessage.getContent();
    }

    public Object getInMessageProperty(String string) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return normalizedMessage.getProperty(string);
    }

    public Set<String> getInMessagePropertyNames() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return normalizedMessage.getPropertyNames();
    }

    public Subject getInSubject() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("In message must not be null");
        }
        return normalizedMessage.getSecuritySubject();
    }

    public QName getInterfaceName() {
        return this.exchange.getInterfaceName();
    }

    public MessageExchange getMessageExchange() throws MessagingException {
        if (this.inNormalizedExchange != null && this.exchange.getMessage("in") == null) {
            this.exchange.setMessage(this.inNormalizedExchange, "in");
        }
        if (this.outNormalizedExchange != null && this.exchange.getMessage("out") == null) {
            this.exchange.setMessage(this.outNormalizedExchange, "out");
        }
        return this.exchange;
    }

    public QName getOperation() {
        return this.exchange.getOperation();
    }

    public String getOperationName() {
        QName qName = this.exchange.getOperation();
        if (qName == null) {
            return null;
        }
        return qName.getLocalPart();
    }

    public NormalizedMessage getOutMessage() {
        if (this.outNormalizedExchange == null) {
            if (this.exchange.getMessage("out") != null) {
                return this.exchange.getMessage("out");
            }
            try {
                this.outNormalizedExchange = this.exchange.createMessage();
            }
            catch (MessagingException messagingException) {
                return null;
            }
        }
        return this.outNormalizedExchange;
    }

    public DataHandler getOutMessageAttachment(String string) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return normalizedMessage.getAttachment(string);
    }

    public Set<String> getOutMessageAttachmentNames() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return normalizedMessage.getAttachmentNames();
    }

    public Set<DataHandler> getOutMessageAttachments() throws MessagingException {
        HashSet<DataHandler> hashSet = new HashSet<DataHandler>();
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        Set set = normalizedMessage.getAttachmentNames();
        for (Object e : set) {
            DataHandler dataHandler = normalizedMessage.getAttachment((String)e);
            if (dataHandler == null) continue;
            hashSet.add(dataHandler);
        }
        return hashSet;
    }

    public Document getOutMessageContentAsDocument() throws MessagingException {
        return this.getOutMessageContentAsDocument(true);
    }

    public Document getOutMessageContentAsDocument(boolean bl) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        Document document = null;
        Source source = normalizedMessage.getContent();
        try {
            if (source != null) {
                document = SourceUtil.createDocument(source, bl);
            }
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException((Throwable)pEtALSCDKException);
        }
        return document;
    }

    public Source getOutMessageContentAsSource() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return normalizedMessage.getContent();
    }

    public Object getOutMessageProperty(String string) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return normalizedMessage.getProperty(string);
    }

    public Set<?> getOutMessagePropertyNames() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return normalizedMessage.getPropertyNames();
    }

    public Subject getOutSubject() throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            throw new MessagingException("Out message must not be null");
        }
        return normalizedMessage.getSecuritySubject();
    }

    public URI getPattern() {
        return this.exchange.getPattern();
    }

    public Object getProperty(String string) {
        return this.exchange.getProperty(string);
    }

    public Set<?> getPropertyNames() {
        return this.exchange.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        return this.exchange.getRole();
    }

    public QName getService() {
        return this.exchange.getService();
    }

    public ExchangeStatus getStatus() {
        return this.exchange.getStatus();
    }

    public boolean isActiveStatus() {
        return ExchangeStatus.ACTIVE.equals(this.getStatus());
    }

    public boolean isConsumerRole() {
        return MessageExchange.Role.CONSUMER.equals(this.getRole());
    }

    public boolean isDoneStatus() {
        return ExchangeStatus.DONE.equals(this.getStatus());
    }

    public boolean isErrorStatus() {
        return ExchangeStatus.ERROR.equals(this.getStatus());
    }

    public boolean isInMessage() {
        return this.exchange.getMessage("in") != null && this.exchange.getMessage("in").getContent() != null || this.inNormalizedExchange != null && this.inNormalizedExchange.getContent() != null;
    }

    public boolean isInOnlyPattern() {
        return Message.MEPConstants.IN_ONLY_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isInOptionalOutPattern() {
        return Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isInOutPattern() {
        return Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isOutMessage() {
        return this.exchange.getMessage("out") != null && this.exchange.getMessage("out").getContent() != null || this.outNormalizedExchange != null && this.outNormalizedExchange.getContent() != null;
    }

    public boolean isProviderRole() {
        return MessageExchange.Role.PROVIDER.equals(this.getRole());
    }

    public boolean isRobustInOnlyPattern() {
        return Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern());
    }

    public boolean isTransacted() {
        return this.exchange.isTransacted();
    }

    public void setActiveStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.ACTIVE);
    }

    public void setCheckRole(boolean bl) {
        this.checkRole = bl;
    }

    public void setDoneStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.DONE);
    }

    public void setEndpoint(ServiceEndpoint serviceEndpoint) {
        this.exchange.setEndpoint(serviceEndpoint);
    }

    public void setError(Exception exception) {
        String string = exception.getClass().getPackage().getName();
        if (exception instanceof MessagingException || string.startsWith("java") || string.startsWith("org.w3c") || string.startsWith("org.xml")) {
            this.exchange.setError(exception);
        } else {
            MessagingException messagingException = new MessagingException(ExceptionUtil.getExtendedMessage((Exception)exception));
            this.exchange.setError((Exception)((Object)messagingException));
        }
    }

    public void setErrorStatus() throws MessagingException {
        this.setStatus(ExchangeStatus.ERROR);
    }

    public void setFault(Fault fault) throws MessagingException {
        this.exchange.setFault(fault);
    }

    public void setFault(Throwable throwable) throws MessagingException {
        Fault fault = this.exchange.createFault();
        Document document = SourceUtil.createSoapFaultDocument(throwable, Exchange.DEFAULT_FAULT_QNAME);
        if (SourceUtil.isDOM3(document)) {
            fault.setContent((Source)SourceUtil.createDOMSource(document));
        } else {
            try {
                fault.setContent((Source)SourceUtil.createStreamSource(document));
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                throw new MessagingException((Throwable)pEtALSCDKException);
            }
        }
        this.exchange.setFault(fault);
    }

    public void setInAddressing(Map<QName, String> map) {
        DocumentFragment documentFragment;
        QName qName;
        NormalizedMessage normalizedMessage = this.getInMessage();
        Object object = normalizedMessage.getProperty("javax.jbi.messaging.protocol.headers");
        HashMap<QName, String> hashMap = new HashMap<QName, String>(map);
        HashMap<String, DocumentFragment> hashMap2 = null;
        if (object != null && object instanceof Map) {
            hashMap2 = (HashMap<String, DocumentFragment>)object;
            for (Map.Entry<QName, String> entry : map.entrySet()) {
                qName = entry.getKey();
                documentFragment = (DocumentFragment)hashMap2.get(qName.toString());
                if (documentFragment == null || documentFragment.getFirstChild() == null || !(documentFragment.getFirstChild() instanceof Element)) continue;
                documentFragment.getFirstChild().setTextContent(entry.getValue());
                hashMap.remove(qName);
            }
        } else {
            hashMap2 = new HashMap<String, DocumentFragment>(hashMap.size());
        }
        for (Map.Entry<QName, String> entry : hashMap.entrySet()) {
            qName = entry.getKey();
            documentFragment = WSAHelper.getElement(qName, entry.getValue());
            if (documentFragment == null) continue;
            hashMap2.put(qName.toString(), documentFragment);
        }
        normalizedMessage.setProperty("javax.jbi.messaging.protocol.headers", hashMap2);
    }

    public void setInMessage(NormalizedMessage normalizedMessage) throws MessagingException {
        this.checkPatternMatching("in");
        this.checkRoleMatching("in");
        this.inNormalizedExchange = normalizedMessage;
    }

    public void setInMessageAttachment(String string, DataHandler dataHandler) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.addAttachment(string, dataHandler);
        this.setInMessage(normalizedMessage);
    }

    public void setInMessageAttachments(Map<String, DataHandler> map) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        ExchangeImpl.copyAttachments(map, normalizedMessage);
        this.setInMessage(normalizedMessage);
    }

    public void setInMessageContent(Document document) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        if (SourceUtil.isDOM3(document)) {
            normalizedMessage.setContent((Source)SourceUtil.createDOMSource(document));
        } else {
            try {
                normalizedMessage.setContent((Source)SourceUtil.createStreamSource(document));
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                throw new MessagingException((Throwable)pEtALSCDKException);
            }
        }
        this.setInMessage(normalizedMessage);
    }

    public void setInMessageContent(InputStream inputStream) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.setContent((Source)new StreamSource(inputStream));
    }

    public void setInMessageContent(Source source) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.setContent(source);
        this.setInMessage(normalizedMessage);
    }

    public void setInMessageProperties(Map<String, Object> map) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        ExchangeImpl.copyMessageProperties(map, normalizedMessage);
        this.setInMessage(normalizedMessage);
    }

    public void setInMessageProperty(String string, Object object) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getInMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.setProperty(string, object);
        this.setInMessage(normalizedMessage);
    }

    public void setInSubject(Subject subject) {
        this.getInMessage().setSecuritySubject(subject);
    }

    public void setInterfaceName(QName qName) {
        this.exchange.setInterfaceName(qName);
    }

    public void setOperation(QName qName) {
        this.exchange.setOperation(qName);
    }

    public void setOutMessage(NormalizedMessage normalizedMessage) throws MessagingException {
        this.checkPatternMatching("out");
        this.checkRoleMatching("out");
        this.outNormalizedExchange = normalizedMessage;
    }

    public void setOutMessageAttachment(String string, DataHandler dataHandler) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.addAttachment(string, dataHandler);
        this.setOutMessage(normalizedMessage);
    }

    public void setOutMessageAttachments(Map<String, DataHandler> map) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        ExchangeImpl.copyAttachments(map, normalizedMessage);
        this.setOutMessage(normalizedMessage);
    }

    public void setOutMessageContent(Document document) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        if (SourceUtil.isDOM3(document)) {
            normalizedMessage.setContent((Source)SourceUtil.createDOMSource(document));
        } else {
            try {
                normalizedMessage.setContent((Source)SourceUtil.createStreamSource(document));
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                throw new MessagingException((Throwable)pEtALSCDKException);
            }
        }
        this.setOutMessage(normalizedMessage);
    }

    public void setOutMessageContent(InputStream inputStream) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.setContent((Source)new StreamSource(inputStream));
    }

    public void setOutMessageContent(Source source) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.setContent(source);
        this.setOutMessage(normalizedMessage);
    }

    public void setOutMessageProperties(Map<String, Object> map) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        ExchangeImpl.copyMessageProperties(map, normalizedMessage);
        this.setOutMessage(normalizedMessage);
    }

    public void setOutMessageProperty(String string, Object object) throws MessagingException {
        NormalizedMessage normalizedMessage = this.getOutMessage();
        if (normalizedMessage == null) {
            normalizedMessage = this.exchange.createMessage();
        }
        normalizedMessage.setProperty(string, object);
        this.setOutMessage(normalizedMessage);
    }

    public void setOutSubject(Subject subject) {
        this.getOutMessage().setSecuritySubject(subject);
    }

    public void setProperty(String string, Object object) {
        this.exchange.setProperty(string, object);
    }

    public void setService(QName qName) {
        this.exchange.setService(qName);
    }

    public void setStatus(ExchangeStatus exchangeStatus) throws MessagingException {
        this.checkStatus(exchangeStatus);
        this.exchange.setStatus(exchangeStatus);
    }

    protected void checkPatternMatching(String string) throws MessagingException {
        if (string == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if ("out".equalsIgnoreCase(string) && (Message.MEPConstants.IN_ONLY_PATTERN.equals(this.exchange.getPattern()) || Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern()))) {
            throw new MessagingException("the MessageExchange state does not allow this operation.");
        }
    }

    protected void checkRoleMatching(String string) throws MessagingException {
        if (string == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (!this.checkRole) {
            return;
        }
        if (MessageExchange.Role.CONSUMER.equals(this.exchange.getRole()) ? "in".equalsIgnoreCase(string) : MessageExchange.Role.PROVIDER.equals(this.exchange.getRole()) && "out".equalsIgnoreCase(string)) {
            return;
        }
        throw new MessagingException("The Role does not allow this operation.");
    }

    private void checkStatus(ExchangeStatus exchangeStatus) throws MessagingException {
        if (ExchangeStatus.DONE.equals(exchangeStatus)) {
            if (MessageExchange.Role.CONSUMER.equals(this.exchange.getRole())) {
                if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern()) && this.getFault() == null && this.exchange.getMessage("out") == null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if (Message.MEPConstants.ROBUST_IN_ONLY_PATTERN.equals(this.exchange.getPattern()) && this.getFault() != null) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern())) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (Message.MEPConstants.IN_OPTIONAL_OUT_PATTERN.equals(this.exchange.getPattern())) {
                    if (this.exchange.getFault() != null && this.exchange.getMessage("out") == null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (this.exchange.getFault() == null && this.exchange.getMessage("out") != null) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        }
    }

    public FlowAttributes getFlowAttributes() {
        return this.exchange.getFlowAttributes();
    }
}

