/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;

public class ExternalListenerManager {
    private Map<String, List<AbstractExternalListener>> externalListeners;
    private AbstractComponent component;

    public ExternalListenerManager(AbstractComponent abstractComponent) {
        this.component = abstractComponent;
        this.externalListeners = new Hashtable<String, List<AbstractExternalListener>>();
    }

    public void createListeners(String string, List<Consumes> list) throws PEtALSCDKException {
        for (Consumes consumes : list) {
            AbstractExternalListener abstractExternalListener = this.createAndInitExternalListener(consumes);
            if (abstractExternalListener != null) {
                this.addExternalListerner(string, abstractExternalListener);
                continue;
            }
            throw new PEtALSCDKException("No ExternalListener can be created. Check if you have provided an ExternalListener class name in your component descriptor (jbi.xml)");
        }
    }

    public void startListening(String string) throws PEtALSCDKException {
        if (this.externalListeners.containsKey(string)) {
            for (AbstractExternalListener abstractExternalListener : this.externalListeners.get(string)) {
                abstractExternalListener.start();
            }
        }
    }

    public void stopListening(String string) throws PEtALSCDKException {
        if (this.externalListeners.containsKey(string)) {
            for (AbstractExternalListener abstractExternalListener : this.externalListeners.get(string)) {
                abstractExternalListener.stop();
            }
        }
    }

    public void removeListeners(String string) {
        this.externalListeners.remove(string);
    }

    private AbstractExternalListener createAndInitExternalListener(Consumes consumes) throws PEtALSCDKException {
        AbstractExternalListener abstractExternalListener = null;
        String string = this.component.getComponentConfiguration().getExternalListenerClassName();
        String string2 = string.replaceAll("\\s", "");
        if (!StringHelper.isNullOrEmpty((String)string2)) {
            ClassLoader classLoader;
            try {
                classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass(string2);
                abstractExternalListener = (AbstractExternalListener)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new PEtALSCDKException("Can't instanciate ExternaListener", (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PEtALSCDKException("Can't instanciate ExternaListener", (Throwable)illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PEtALSCDKException("Can't find ExternaListener class : " + string2, (Throwable)classNotFoundException);
            }
            abstractExternalListener.init(this.component);
            abstractExternalListener.setConsumes(consumes);
            classLoader = new ConfigurationExtensions(consumes.getAny());
            abstractExternalListener.setExtensions((ConfigurationExtensions)classLoader);
            abstractExternalListener.init();
        }
        return abstractExternalListener;
    }

    private void addExternalListerner(String string, AbstractExternalListener abstractExternalListener) {
        List<AbstractExternalListener> list = this.externalListeners.get(string);
        if (list == null) {
            list = new ArrayList<AbstractExternalListener>();
            this.externalListeners.put(string, list);
        }
        list.add(abstractExternalListener);
    }
}

