/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.mbean.RuntimeConfigurationNotifier;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManagerObservable;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

public class JBIProcessorManager
extends JBIProcessorManagerObservable {
    private ThreadPoolExecutor processorPool = null;
    protected GenericObjectPool objectPool = null;
    protected AbstractComponent component;
    private final RuntimeConfigurationNotifier runtimeConfiguration;
    protected Logger logger;

    public JBIProcessorManager(AbstractComponent abstractComponent, RuntimeConfigurationNotifier runtimeConfigurationNotifier, Logger logger) {
        this.component = abstractComponent;
        this.runtimeConfiguration = runtimeConfigurationNotifier;
        this.logger = logger;
        this.runtimeConfiguration.addNotificationListener(new RuntimeConfigurationListener(), null, null);
    }

    public void start() throws JBIException {
        this.logger.fine("Creating JBI Processor pool, core pool size is " + this.component.getComponentConfiguration().getProcessorPoolSize().getValue());
        int n = 50;
        if (this.component.getComponentConfiguration().getProcessorMaxPoolSize() != null) {
            n = this.component.getComponentConfiguration().getProcessorMaxPoolSize().getValue().intValue();
        }
        this.objectPool = new GenericObjectPool((PoolableObjectFactory)new MessageExchangeProcessorObjectFactory(), n);
        try {
            PoolUtils.prefill((ObjectPool)this.objectPool, (int)this.component.getComponentConfiguration().getProcessorPoolSize().getValue().intValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JBIException((Throwable)illegalArgumentException);
        }
        catch (Exception exception) {
            throw new JBIException((Throwable)exception);
        }
        this.processorPool = new MessageExchangeProcessorThreadPoolExecutor(this.component.getComponentConfiguration().getProcessorPoolSize().getValue().intValue(), n, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new JBIProcessorThreadFactory());
        this.processorPool.prestartAllCoreThreads();
    }

    public void stop() {
        this.processorPool.shutdown();
        try {
            long l = 15000L;
            if (this.component.getComponentConfiguration().getProcessorStopMaxWait() != null) {
                l = this.component.getComponentConfiguration().getProcessorStopMaxWait().getValue();
            }
            this.processorPool.awaitTermination(l, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.logger.log(Level.SEVERE, "Workers pool interrupted : " + interruptedException.getMessage());
        }
        this.processorPool.shutdownNow();
        try {
            this.objectPool.close();
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to close the Messsage Exchange Processor Object pool properly", exception);
        }
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.processorPool;
    }

    public GenericObjectPool getObjectPool() {
        return this.objectPool;
    }

    private void setCorePoolSize(int n) {
        this.logger.info("Reset the processor thread pool size to " + n);
        this.processorPool.setCorePoolSize(n);
    }

    private void setMaxCorePoolSize(int n) {
        this.logger.info("Reset the maximum processor thread pool size to " + n);
        this.processorPool.setMaximumPoolSize(n);
    }

    private class MessageExchangeProcessorObjectFactory
    implements PoolableObjectFactory {
        private MessageExchangeProcessorObjectFactory() {
        }

        public void activateObject(Object object) throws Exception {
        }

        public void destroyObject(Object object) throws Exception {
        }

        public Object makeObject() throws Exception {
            AbstractJBIListener abstractJBIListener = this.createAndInitJBIListener();
            MessageExchangeProcessor messageExchangeProcessor = new MessageExchangeProcessor(JBIProcessorManager.this.component, abstractJBIListener, JBIProcessorManager.this.logger);
            return messageExchangeProcessor;
        }

        public void passivateObject(Object object) throws Exception {
        }

        public boolean validateObject(Object object) {
            return true;
        }

        private AbstractJBIListener createAndInitJBIListener() throws PEtALSCDKException {
            AbstractJBIListener abstractJBIListener = null;
            String string = JBIProcessorManager.this.component.getComponentConfiguration().getJbiListenerClassName();
            String string2 = string.replaceAll("\\s", "");
            if (!StringHelper.isNullOrEmpty((String)string2)) {
                try {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    Class<?> clazz = classLoader.loadClass(string2);
                    abstractJBIListener = (AbstractJBIListener)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    throw new PEtALSCDKException("Can't instanciate JBIListener : " + string2, (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new PEtALSCDKException("Can't instanciate JBIListener : " + string2, (Throwable)illegalAccessException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PEtALSCDKException("Can't find JBIListener class : " + string2, (Throwable)classNotFoundException);
                }
            } else {
                throw new PEtALSCDKException("JBIListener class name can not be empty");
            }
            abstractJBIListener.init(JBIProcessorManager.this.component);
            abstractJBIListener.init();
            return abstractJBIListener;
        }
    }

    private class MessageExchangeProcessorThreadPoolExecutor
    extends ThreadPoolExecutor {
        public MessageExchangeProcessorThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
            super(n, n2, l, timeUnit, blockingQueue, threadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            super.beforeExecute(thread, runnable);
            ExchangeImpl exchangeImpl = ((MessageExchangeProcessor)runnable).getMessageExchange();
            JBIProcessorManager.this.notifyObserversBeforeProcessing(exchangeImpl);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            ExchangeImpl exchangeImpl = ((MessageExchangeProcessor)runnable).getMessageExchange();
            JBIProcessorManager.this.notifyObserversAfterProcessing(exchangeImpl);
            ((MessageExchangeProcessor)runnable).clean();
            try {
                JBIProcessorManager.this.objectPool.returnObject((Object)runnable);
            }
            catch (Exception exception) {
                JBIProcessorManager.this.logger.log(Level.SEVERE, "Failed to return a Message Exchange Processor instance to the Object pool", exception);
            }
            super.afterExecute(runnable, throwable);
        }
    }

    private class JBIProcessorThreadFactory
    implements ThreadFactory {
        final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String componentName;

        public JBIProcessorThreadFactory() {
            this.componentName = JBIProcessorManager.this.component.getComponentConfiguration().getIdentification().getName();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            String string = this.componentName + " - MessageExchange Processor thread #" + Integer.toString(this.threadNumber.getAndIncrement());
            JBIProcessorManager.this.logger.log(Level.FINE, "Creating new JBI Processor Thread : " + string);
            return new Thread(Thread.currentThread().getThreadGroup(), runnable, string);
        }
    }

    private class RuntimeConfigurationListener
    implements NotificationListener {
        private RuntimeConfigurationListener() {
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof AttributeChangeNotification) {
                AttributeChangeNotification attributeChangeNotification = (AttributeChangeNotification)notification;
                JBIProcessorManager.this.logger.log(Level.FINE, "Notification received for attribute : " + attributeChangeNotification.getAttributeName());
                if (attributeChangeNotification.getAttributeName().equals("processorPoolSize")) {
                    Integer n = (Integer)attributeChangeNotification.getNewValue();
                    JBIProcessorManager.this.setCorePoolSize(n);
                } else if (attributeChangeNotification.getAttributeName().equals("processorMaxPoolSize")) {
                    Integer n = (Integer)attributeChangeNotification.getNewValue();
                    JBIProcessorManager.this.setMaxCorePoolSize(n);
                }
            }
        }
    }
}

