/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.logger.Level;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;

public class MessageExchangeAcceptor
extends Thread {
    private Logger logger;
    private DeliveryChannel deliveryChannel;
    private boolean running = false;
    private ThreadPoolExecutor jbiProcessorThreadPool;
    private GenericObjectPool jbiProcessorObjectPool;

    public MessageExchangeAcceptor(AbstractComponent abstractComponent, ThreadPoolExecutor threadPoolExecutor, GenericObjectPool genericObjectPool, Logger logger, ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
        this.jbiProcessorThreadPool = threadPoolExecutor;
        this.jbiProcessorObjectPool = genericObjectPool;
        this.deliveryChannel = abstractComponent.getChannel();
        this.logger = logger;
    }

    @Override
    public void run() {
        this.logger.log(Level.FINE, "Starting MessageExchangeAcceptor Thread " + this.getName());
        this.running = true;
        while (this.running) {
            Object object;
            try {
                ExchangeImpl exchangeImpl = new ExchangeImpl(this.deliveryChannel.accept());
                this.logger.fine("Accepting a JBI message with Id : " + exchangeImpl.getExchangeId());
                object = (MessageExchangeProcessor)this.jbiProcessorObjectPool.borrowObject();
                ((MessageExchangeProcessor)object).setMessageExchange(exchangeImpl);
                this.jbiProcessorThreadPool.execute((Runnable)object);
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                this.logger.log(Level.SEVERE, pEtALSCDKException.getMessage(), pEtALSCDKException);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.logger.log(Level.SEVERE, "No more JBI worker available", rejectedExecutionException);
            }
            catch (Exception exception) {
                for (object = exception; object != null && this.running; object = ((Throwable)object).getCause()) {
                    if (!(object instanceof InterruptedException)) continue;
                    this.running = false;
                    this.logger.fine("Thread '" + this.getName() + "' interrupted, stop accepting JBI messages");
                }
                if (!this.running) continue;
                this.logger.log(Level.INFO, "An unexpected exception occurs during the processing of the JBI acceptor '" + this.getName() + "'", exception);
            }
        }
    }
}

