/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.QualifiedUUIDGenerator;
import java.util.Set;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.commons.logger.ProvideFlowStepBeginLogData;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.exception.SOAP11FaultServerException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.ExchangeProperties;
import org.ow2.petals.component.framework.jbidescriptor.generated.IgnoreStatus;
import org.ow2.petals.component.framework.jbidescriptor.generated.MessageParam;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.async.AsyncContext;
import org.ow2.petals.component.framework.process.async.AsyncMessageManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class MessageExchangeProcessor
implements Runnable {
    private final AbstractComponent component;
    private final Logger logger;
    private final DeliveryChannel deliveryChannel;
    private final Object transactionManager;
    private final AbstractJBIListener jbiListener;
    private final AbstractServiceUnitManager suManager;
    private final AsyncMessageManager asyncManager;
    private final String componentName;
    private final IgnoreStatus ignoreStatus;
    private ExchangeImpl exchange = null;

    public MessageExchangeProcessor(AbstractComponent abstractComponent, AbstractJBIListener abstractJBIListener, Logger logger) {
        this.component = abstractComponent;
        this.jbiListener = abstractJBIListener;
        this.logger = logger;
        this.deliveryChannel = abstractComponent.getChannel();
        this.suManager = (AbstractServiceUnitManager)abstractComponent.getServiceUnitManager();
        this.asyncManager = abstractComponent.getAsyncManager();
        this.transactionManager = abstractComponent.getContext().getTransactionManager();
        this.componentName = abstractComponent.getContext().getComponentName();
        this.ignoreStatus = abstractComponent.getComponentConfiguration().getIgnoredStatus();
    }

    public void setMessageExchange(ExchangeImpl exchangeImpl) {
        this.exchange = exchangeImpl;
    }

    public ExchangeImpl getMessageExchange() {
        return this.exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.isIgnored(this.exchange)) {
            try {
                this.process(this.exchange);
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, exception.getMessage(), exception);
                if (this.exchange.isActiveStatus()) {
                    try {
                        if (Message.MEPConstants.IN_OUT_PATTERN.equals(this.exchange.getPattern())) {
                            this.exchange.setFault(exception);
                        } else {
                            this.exchange.setError((Exception)((Object)new MessagingException(ExceptionUtil.getExtendedMessage((Exception)exception))));
                        }
                        this.deliveryChannel.send(this.exchange.getMessageExchange());
                    }
                    catch (MessagingException messagingException) {
                        this.logger.log(Level.SEVERE, "Cannot send back an error acknowledgement or a Fault", messagingException);
                    }
                }
            }
            finally {
                ExecutionContext.getProperties().clear();
            }
        }
    }

    protected final void clean() {
        this.jbiListener.setConsumes(null);
        this.jbiListener.setProvides(null);
        this.jbiListener.setExtensions(null);
        this.jbiListener.setCurrentTransaction(null);
        this.exchange = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void process(Exchange exchange) throws MessagingException {
        this.setCurrentTransaction();
        if (exchange.isProviderRole()) {
            try {
                this.processAsProvider(exchange);
                return;
            }
            catch (RuntimeException runtimeException) {
                if (!exchange.isProviderRole()) return;
                throw runtimeException;
            }
            catch (MessagingException messagingException) {
                if (!exchange.isProviderRole()) return;
                throw messagingException;
            }
        }
        try {
            this.processAsConsumer(exchange);
            return;
        }
        catch (RuntimeException runtimeException) {
            if (!exchange.isConsumerRole()) return;
            throw runtimeException;
        }
        catch (MessagingException messagingException) {
            if (!exchange.isConsumerRole()) return;
            throw messagingException;
        }
    }

    private final void processAsConsumer(Exchange exchange) throws MessagingException {
        AsyncContext asyncContext = null;
        this.logger.finest("Process an exchange as CONSUMER with id : " + exchange.getExchangeId());
        Consumes consumes = this.getConsumesFromExchange(exchange);
        if (consumes != null) {
            this.jbiListener.setConsumes(consumes);
            this.jbiListener.setExtensions(this.getExtensions(consumes));
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, consumes, Message.InterceptorPhase.SEND_RESPONSE);
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                throw new MessagingException((Throwable)pEtALSCDKException);
            }
        }
        if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous") != null) {
            asyncContext = this.asyncManager.getAsyncContext(this.exchange.getExchangeId());
            if (asyncContext == null && exchange.isActiveStatus()) {
                exchange.setError(new Exception("A response message do not match any Asynchronous Context. Its bound Asynchronous Context has probably already expired!"));
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            }
        } else if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous.original") != null) {
            asyncContext = this.asyncManager.removeAsyncContext(this.exchange.getExchangeId());
        } else {
            this.logger.fine("The exchange '" + exchange.getExchangeId() + "' refers to an unknown consumer on the component : " + this.componentName + ". The listener will not have the consumes and the extensions for this exchange");
        }
        if (exchange.isInOnlyPattern()) {
            this.processInOnlyAsConsumer(exchange, asyncContext);
        } else if (exchange.isRobustInOnlyPattern()) {
            this.processRobustInOnlyAsConsumer(exchange, asyncContext);
        } else if (exchange.isInOutPattern()) {
            this.processInOutAsConsumer(exchange, asyncContext);
        } else if (exchange.isInOptionalOutPattern()) {
            this.processInOptionalOutAsConsumer(exchange, asyncContext);
        } else {
            throw new MessagingException("Message Exchange Pattern not recognized :" + exchange.getPattern());
        }
    }

    private final void processAsProvider(Exchange exchange) throws MessagingException {
        Object object;
        Object object2;
        MessageExchange messageExchange;
        this.logger.log(Level.FINEST, "Process an exchange as PROVIDER with id : " + exchange.getExchangeId());
        if (exchange.isActiveStatus()) {
            messageExchange = this.exchange.getMessageExchange();
            object2 = messageExchange.getFlowAttributes();
            if (object2 != null) {
                PetalsExecutionContext.putFlowAttributes((FlowAttributes)object2);
                PetalsExecutionContext.nextFlowStepId();
                object = PetalsExecutionContext.getFlowAttributes();
                messageExchange.setFlowAttributes(object);
            }
            this.logger.log(Level.MONIT, "", this.newProvideFlowStepBeginLogData(exchange));
        }
        if ((messageExchange = this.getProvidesFromExchange(exchange)) == null) {
            if (this.component.getServiceDescription(exchange.getEndpoint()) == null) {
                throw new MessagingException("The endpoint '" + exchange.getEndpoint() + "' is unknown on the component : " + this.componentName);
            }
            this.logger.fine("Process an exchange managed directly by the component");
        } else {
            this.jbiListener.setProvides((Provides)messageExchange);
            this.jbiListener.setExtensions(this.getExtensions(messageExchange));
            try {
                this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, messageExchange, Message.InterceptorPhase.ACCEPT);
            }
            catch (PEtALSCDKException pEtALSCDKException) {
                throw new MessagingException((Throwable)pEtALSCDKException);
            }
        }
        object2 = null;
        if (this.exchange.getProperty("org.ow2.petals.component.framework.asynchronous.expired") != null) {
            object2 = this.asyncManager.removeAsyncContext(this.exchange.getExchangeId());
        }
        if (exchange.getProperty("org.ow2.petals.propagate.correlation") == null) {
            object = new QualifiedUUIDGenerator("petals:uid").getNewID();
            exchange.setProperty("org.ow2.petals.propagate.correlation", object);
        }
        if (exchange.isInOnlyPattern()) {
            this.processInOnlyAsProvider(exchange, (AsyncContext)object2, (Provides)messageExchange);
        } else if (exchange.isRobustInOnlyPattern()) {
            this.processRobustInOnlyAsProvider(exchange, (AsyncContext)object2, (Provides)messageExchange);
        } else if (exchange.isInOutPattern()) {
            this.processInOutAsProvider(exchange, (AsyncContext)object2, (Provides)messageExchange);
        } else if (exchange.isInOptionalOutPattern()) {
            this.processInOptionalOutAsProvider(exchange, (AsyncContext)object2, (Provides)messageExchange);
        } else {
            throw new MessagingException("Message Exchange Pattern not recognized :" + exchange.getPattern());
        }
    }

    protected final ProvideFlowStepBeginLogData newProvideFlowStepBeginLogData(Exchange exchange) {
        String string = "";
        QName qName = null;
        if (exchange.getEndpoint() != null) {
            string = exchange.getEndpoint().getEndpointName();
            qName = exchange.getEndpoint().getServiceName();
        }
        return new ProvideFlowStepBeginLogData(ExecutionContext.getProperties().getProperty("flowInstanceId"), ExecutionContext.getProperties().getProperty("flowStepId"), StringHelper.nonNullValue((Object)exchange.getInterfaceName()), StringHelper.nonNullValue((Object)qName), StringHelper.nonNullValue((Object)exchange.getOperation()), string, ExecutionContext.getProperties().getProperty("flowPreviousStepId"));
    }

    private final void processInOnlyAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        if (asyncContext == null) {
            this.jbiListener.onJBIMessage(exchange);
        } else {
            this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
    }

    private final void processInOnlyAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean bl = false;
        bl = asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext);
        if (bl) {
            if (exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException pEtALSCDKException) {
                    throw new MessagingException((Throwable)pEtALSCDKException);
                }
                this.setProperties(provides);
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOptionalOutAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        boolean bl = false;
        boolean bl2 = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            bl2 = true;
        }
        if ((bl = asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onAsyncJBIMessage(exchange, asyncContext)) && !bl2) {
            if (exchange.getFault() == null && exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOptionalOutAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            bl3 = true;
        } else if (exchange.getFault() != null) {
            bl2 = true;
        }
        bl = asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext);
        if (provides != null && exchange.isOutMessage()) {
            MessageExchangeProcessor.forwardMessageData(exchange, provides);
        }
        if (bl) {
            if (!bl3 && exchange.isActiveStatus() && (bl2 || exchange.getFault() == null && !((ExchangeImpl)exchange).isOutMessage())) {
                exchange.setDoneStatus();
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException pEtALSCDKException) {
                    throw new MessagingException((Throwable)pEtALSCDKException);
                }
                this.setProperties(provides);
            }
            if (!bl3) {
                this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
            }
        }
    }

    private final void processInOutAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        boolean bl = false;
        bl = asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        if (bl) {
            if (exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processInOutAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean bl;
        boolean bl2;
        block11: {
            bl2 = false;
            bl = false;
            try {
                if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
                    bl = true;
                }
                bl2 = asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext);
                if (provides != null && exchange.isOutMessage()) {
                    MessageExchangeProcessor.forwardMessageData(exchange, provides);
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.WARNING, "An unexpected exception occured during an exchange processing", exception);
                if (exchange.getFault() != null) break block11;
                exchange.setFault((Throwable)new SOAP11FaultServerException(exception.getMessage(), Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName), (Throwable)exception));
                bl2 = true;
            }
        }
        if (bl2 && !bl) {
            if (exchange.getFault() == null && !exchange.isOutMessage()) {
                if (exchange.getError() != null) {
                    exchange.setFault((Throwable)new SOAP11FaultServerException(exchange.getError().getMessage(), Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName), (Throwable)exchange.getError()));
                } else {
                    exchange.setFault((Throwable)new SOAP11FaultServerException("The Provider do not return any response", Constants.Exception.NAMESPACE_URI.resolve("/" + this.componentName)));
                }
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException pEtALSCDKException) {
                    throw new MessagingException((Throwable)pEtALSCDKException);
                }
                this.setProperties(provides);
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final void processRobustInOnlyAsConsumer(Exchange exchange, AsyncContext asyncContext) throws MessagingException {
        if (asyncContext == null) {
            this.jbiListener.onJBIMessage(exchange);
        } else {
            this.jbiListener.onAsyncJBIMessage(exchange, asyncContext);
        }
    }

    private final void processRobustInOnlyAsProvider(Exchange exchange, AsyncContext asyncContext, Provides provides) throws MessagingException {
        boolean bl = false;
        boolean bl2 = false;
        if (exchange.isDoneStatus() || exchange.isErrorStatus()) {
            bl2 = true;
        }
        if ((bl = asyncContext == null ? this.jbiListener.onJBIMessage(exchange) : this.jbiListener.onExpiredAsyncJBIMessage(exchange, asyncContext)) && !bl2) {
            if (exchange.getFault() == null && exchange.isActiveStatus()) {
                exchange.setDoneStatus();
            }
            if (provides != null) {
                try {
                    this.jbiListener.getMessageInterceptorProcessor().intercept(exchange, provides, Message.InterceptorPhase.ACCEPT_RESPONSE);
                }
                catch (PEtALSCDKException pEtALSCDKException) {
                    throw new MessagingException((Throwable)pEtALSCDKException);
                }
                this.setProperties(provides);
            }
            this.deliveryChannel.send(((ExchangeImpl)exchange).getMessageExchange());
        }
    }

    private final ConfigurationExtensions getExtensions(Object object) {
        ConfigurationExtensions configurationExtensions = null;
        if (object == null) {
            return null;
        }
        ServiceUnitDataHandler serviceUnitDataHandler = this.suManager.getSUDataHandlerForService(object);
        if (serviceUnitDataHandler != null) {
            configurationExtensions = serviceUnitDataHandler.getConfigurationExtensions(object);
        }
        return configurationExtensions;
    }

    private final Consumes getConsumesFromExchange(Exchange exchange) {
        ServiceEndpoint serviceEndpoint = exchange.getEndpoint();
        return this.suManager.getConsumesFromDestination(serviceEndpoint.getEndpointName(), exchange.getService(), exchange.getInterfaceName());
    }

    private final Provides getProvidesFromExchange(Exchange exchange) {
        ServiceEndpoint serviceEndpoint = exchange.getEndpoint();
        Provides provides = this.suManager.getProvidesFromEndpoint(serviceEndpoint);
        return provides;
    }

    private final void setCurrentTransaction() {
        if (this.exchange.isTransacted()) {
            Transaction transaction = (Transaction)this.exchange.getProperty("javax.jbi.transaction.jta");
            if (transaction == null) {
                try {
                    transaction = ((TransactionManager)this.transactionManager).getTransaction();
                }
                catch (SystemException systemException) {
                    this.logger.log(Level.WARNING, "Failed to retrieve Transaction for exchange '" + this.exchange.getExchangeId() + "'", systemException);
                }
            }
            this.jbiListener.setCurrentTransaction(transaction);
        }
    }

    private final void setProperties(Provides provides) throws MessagingException {
        Object object;
        ExchangeProperties exchangeProperties = provides.getExchangeProperties();
        if (exchangeProperties != null) {
            object = exchangeProperties.getExchangeProperty().iterator();
            while (object.hasNext()) {
                Param param = (Param)object.next();
                this.exchange.setProperty(param.getName(), param.getValue());
            }
        }
        if ((object = provides.getMessageProperties()) != null) {
            for (MessageParam messageParam : object.getMessageProperty()) {
                NormalizedMessage normalizedMessage = this.exchange.getMessageExchange().getMessage(messageParam.getMessage().name());
                normalizedMessage.setProperty(messageParam.getName(), (Object)messageParam.getValue());
            }
        }
    }

    private final boolean isIgnored(Exchange exchange) {
        boolean bl = false;
        if (exchange.isDoneStatus()) {
            bl = IgnoreStatus.DONE_IGNORED == this.ignoreStatus || IgnoreStatus.DONE_AND_ERROR_IGNORED == this.ignoreStatus;
        } else if (exchange.isErrorStatus()) {
            bl = IgnoreStatus.ERROR_IGNORED == this.ignoreStatus || IgnoreStatus.DONE_AND_ERROR_IGNORED == this.ignoreStatus;
        }
        return bl;
    }

    private static final void forwardMessageData(Exchange exchange, Provides provides) throws MessagingException {
        if (provides == null) {
            return;
        }
        if (provides.isForwardSecuritySubject() != null && provides.isForwardSecuritySubject().booleanValue() && exchange.getInSubject() != null && exchange.getOutSubject() == null) {
            exchange.setOutSubject(exchange.getInSubject());
        }
        if (provides.isForwardMessageProperties() != null && provides.isForwardMessageProperties().booleanValue()) {
            for (Object object : exchange.getInMessagePropertyNames()) {
                if (exchange.getOutMessageProperty((String)object) != null) continue;
                exchange.setOutMessageProperty((String)object, exchange.getInMessageProperty((String)object));
            }
        }
        if (provides.isForwardAttachments() != null && provides.isForwardAttachments().booleanValue()) {
            Object object;
            Set set = exchange.getInMessageAttachmentNames();
            object = set.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (exchange.getOutMessageAttachment(string) != null) continue;
                exchange.setOutMessageAttachment(string, exchange.getInMessageAttachment(string));
            }
        }
    }
}

