/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.Interceptor;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class MessageInterceptorProcessor {
    protected AbstractComponent component;
    protected Logger logger;

    public MessageInterceptorProcessor(AbstractComponent abstractComponent, Logger logger) {
        this.component = abstractComponent;
        this.logger = logger;
    }

    public void intercept(Exchange exchange, Object object, Message.InterceptorPhase interceptorPhase) throws PEtALSCDKException {
        this.logger.fine("Intercepting message processing on " + interceptorPhase);
        this.checkInterceptorPhase(interceptorPhase, object);
        AbstractServiceUnitManager abstractServiceUnitManager = (AbstractServiceUnitManager)this.component.getServiceUnitManager();
        ServiceUnitDataHandler serviceUnitDataHandler = abstractServiceUnitManager.getSUDataHandlerForService(object);
        if (serviceUnitDataHandler != null) {
            MessageInterceptorManager messageInterceptorManager = serviceUnitDataHandler.getMessageInterceptorManager(object);
            if (Message.InterceptorPhase.ACCEPT.equals((Object)interceptorPhase)) {
                ((ExchangeImpl)exchange).setCheckRole(false);
            }
            this.intercept(exchange, object, messageInterceptorManager, interceptorPhase);
            if (Message.InterceptorPhase.ACCEPT.equals((Object)interceptorPhase)) {
                ((ExchangeImpl)exchange).setCheckRole(true);
            }
        }
    }

    private void checkInterceptorPhase(Message.InterceptorPhase interceptorPhase, Object object) throws PEtALSCDKException {
        if (Message.InterceptorPhase.ACCEPT.equals((Object)interceptorPhase) || Message.InterceptorPhase.ACCEPT_RESPONSE.equals((Object)interceptorPhase)) {
            if (!(object instanceof Provides)) {
                throw new PEtALSCDKException("The InterceptorPhase is not a Provides InterceptorPhase");
            }
        } else if (!(object instanceof Consumes)) {
            throw new PEtALSCDKException("The InterceptorPhase is not a Consumes InterceptorPhase");
        }
    }

    private void intercept(Exchange exchange, Object object, MessageInterceptorManager messageInterceptorManager, Message.InterceptorPhase interceptorPhase) {
        Map<String, Interceptor> map = null;
        Map<String, ConfigurationExtensions> map2 = null;
        if (interceptorPhase == Message.InterceptorPhase.ACCEPT) {
            map = messageInterceptorManager.getInputOrderedInterceptors();
            map2 = messageInterceptorManager.getInputAdditionalConfiguration();
        } else if (interceptorPhase == Message.InterceptorPhase.SEND) {
            map = messageInterceptorManager.getOutputOrderedInterceptors();
            map2 = messageInterceptorManager.getOutputAdditionalConfiguration();
        } else if (interceptorPhase == Message.InterceptorPhase.ACCEPT_RESPONSE) {
            map = messageInterceptorManager.getInputResponseOrderedInterceptors();
            map2 = messageInterceptorManager.getInputResponseAdditionalConfiguration();
        } else if (interceptorPhase == Message.InterceptorPhase.SEND_RESPONSE) {
            map = messageInterceptorManager.getOutputResponseOrderedInterceptors();
            map2 = messageInterceptorManager.getOutputResponseAdditionalConfiguration();
        } else {
            throw new IllegalArgumentException("Unknown InterceptorPhase: " + interceptorPhase.toString());
        }
        for (Map.Entry<String, Interceptor> entry : map.entrySet()) {
            Interceptor interceptor = entry.getValue();
            String string = entry.getKey();
            this.logger.fine("Calling message interceptor " + string);
            HashMap hashMap = new HashMap();
            hashMap.putAll(interceptor.getComponentParameters());
            if (map2.get(string) != null) {
                hashMap.putAll((Map)map2.get(string));
            }
            if (interceptorPhase == Message.InterceptorPhase.ACCEPT) {
                this.logger.fine("Intercepting message on accept InterceptorPhase");
                interceptor.handleMessageAccept(exchange, (Provides)object, hashMap);
                continue;
            }
            if (interceptorPhase == Message.InterceptorPhase.SEND) {
                this.logger.fine("Intercepting message on send InterceptorPhase");
                interceptor.handleMessageSent(exchange, (Consumes)object, hashMap);
                continue;
            }
            if (interceptorPhase == Message.InterceptorPhase.ACCEPT_RESPONSE) {
                this.logger.fine("Intercepting message on accept response InterceptorPhase");
                interceptor.handleMessageAcceptResponse(exchange, (Provides)object, hashMap);
                continue;
            }
            if (interceptorPhase != Message.InterceptorPhase.SEND_RESPONSE) continue;
            this.logger.fine("Intercepting message on send response InterceptorPhase");
            interceptor.handleMessageSentResponse(exchange, (Consumes)object, hashMap);
        }
    }
}

