/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.process.async;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.message.ExchangeImpl;
import org.ow2.petals.component.framework.process.JBIProcessorManager;
import org.ow2.petals.component.framework.process.MessageExchangeProcessor;
import org.ow2.petals.component.framework.process.async.AsyncContext;

public class AsyncMessageManager {
    public static final String ASYNC_MESSAGE_PROPERTY = "org.ow2.petals.component.framework.asynchronous";
    public static final String ASYNC_ORIGINAL_MESSAGE_PROPERTY = "org.ow2.petals.component.framework.asynchronous.original";
    public static final String ASYNC_EXPIRED_MESSAGE_PROPERTY = "org.ow2.petals.component.framework.asynchronous.expired";
    protected final Logger logger;
    private Timer timer = null;
    protected ThreadPoolExecutor jbiProcessorThreadPool;
    protected GenericObjectPool jbiProcessorObjectPool;
    protected final JBIProcessorManager jbiProcessorManager;
    protected final Map<String, AsyncContext> asynchronousContexts;
    protected final Map<String, AsyncContext> originalAsynchronousContexts;

    public AsyncMessageManager(Logger logger, JBIProcessorManager jBIProcessorManager) {
        this.logger = logger;
        this.asynchronousContexts = new ConcurrentHashMap<String, AsyncContext>();
        this.originalAsynchronousContexts = new ConcurrentHashMap<String, AsyncContext>();
        this.jbiProcessorManager = jBIProcessorManager;
    }

    public void start() {
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new AsyncContextCleaner(), 0L, 2000L);
        this.jbiProcessorThreadPool = this.jbiProcessorManager.getThreadPool();
        this.jbiProcessorObjectPool = this.jbiProcessorManager.getObjectPool();
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
    }

    public void addAsyncContext(Exchange exchange, AsyncContext asyncContext) {
        this.logger.fine("Add AsyncContext for exchange id: " + exchange.getExchangeId());
        exchange.setProperty(ASYNC_MESSAGE_PROPERTY, (Object)Boolean.toString(true));
        this.asynchronousContexts.put(exchange.getExchangeId(), asyncContext);
        if (!this.originalAsynchronousContexts.containsValue(asyncContext)) {
            asyncContext.getOriginalExchange().setProperty(ASYNC_ORIGINAL_MESSAGE_PROPERTY, (Object)Boolean.toString(true));
            asyncContext.setStartTime(System.currentTimeMillis());
            this.originalAsynchronousContexts.put(asyncContext.getOriginalExchange().getExchangeId(), asyncContext);
        }
    }

    public AsyncContext getAsyncContext(String string) {
        return this.asynchronousContexts.remove(string);
    }

    public AsyncContext removeAsyncContext(String string) {
        this.logger.fine("Remove Context with original exchange id : " + string);
        return this.originalAsynchronousContexts.remove(string);
    }

    public class AsyncContextCleaner
    extends TimerTask {
        @Override
        public void run() {
            ArrayList<AsyncContext> arrayList = new ArrayList<AsyncContext>();
            for (Map.Entry<String, AsyncContext> object2 : AsyncMessageManager.this.originalAsynchronousContexts.entrySet()) {
                if (object2.getValue().getExpirationTime() == 0L || System.currentTimeMillis() <= object2.getValue().getExpirationTime()) continue;
                object2.getValue().getOriginalExchange().setProperty(AsyncMessageManager.ASYNC_EXPIRED_MESSAGE_PROPERTY, (Object)Boolean.toString(true));
                arrayList.add(object2.getValue());
            }
            ArrayList arrayList2 = new ArrayList();
            for (Map.Entry<String, AsyncContext> entry : AsyncMessageManager.this.asynchronousContexts.entrySet()) {
                if (entry.getValue().getExpirationTime() == 0L || System.currentTimeMillis() <= entry.getValue().getExpirationTime()) continue;
                arrayList2.add(entry.getKey());
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AsyncMessageManager.this.asynchronousContexts.remove(string);
            }
            for (AsyncContext asyncContext : arrayList) {
                try {
                    MessageExchangeProcessor messageExchangeProcessor = (MessageExchangeProcessor)AsyncMessageManager.this.jbiProcessorObjectPool.borrowObject();
                    messageExchangeProcessor.setMessageExchange((ExchangeImpl)asyncContext.getOriginalExchange());
                    AsyncMessageManager.this.jbiProcessorThreadPool.execute(messageExchangeProcessor);
                }
                catch (Exception exception) {
                    AsyncMessageManager.this.logger.log(Level.WARNING, "Failed to borrow a Message Exchange Processor to process expired Asynchronous Context for original Exchange with id : " + asyncContext.getOriginalExchange().getExchangeId(), exception);
                }
            }
        }
    }
}

