/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.petals.commons.exception.ExceptionUtil;
import org.ow2.petals.component.framework.AbstractComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.JBIDescriptorBuilder;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.jbidescriptor.generated.SUInterceptors;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;
import org.ow2.petals.component.framework.util.EndpointUtil;
import org.ow2.petals.component.framework.util.ManagementMessageUtil;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.w3c.dom.Document;

public abstract class AbstractServiceUnitManager
implements ServiceUnitManager {
    protected final AbstractComponent component;
    protected Logger logger;
    private final ConcurrentMap<String, ServiceUnitDataHandler> serviceUnitDataHandlers;

    public AbstractServiceUnitManager(AbstractComponent abstractComponent) {
        this.component = abstractComponent;
        this.logger = abstractComponent.getLogger();
        this.serviceUnitDataHandlers = new ConcurrentHashMap<String, ServiceUnitDataHandler>();
    }

    private static final Description getWsdlDescription(URL uRL, Provides provides) throws PEtALSCDKException {
        if (uRL != null) {
            try {
                return WSDLUtilImpl.createWsdlDescription(uRL, false);
            }
            catch (WSDLException wSDLException) {
                throw new PEtALSCDKException((Throwable)wSDLException);
            }
        }
        try {
            return WSDLUtilImpl.createLightWSDL20Description(provides.getInterfaceName(), provides.getServiceName(), provides.getEndpointName());
        }
        catch (WSDLException wSDLException) {
            throw new PEtALSCDKException("Can not auto-generate a WSDL document", (Throwable)wSDLException);
        }
    }

    private static final URL getWsdlLocation(String string, Provides provides) throws PEtALSCDKException {
        String string2 = null;
        URL uRL = null;
        string2 = provides.getWsdl();
        if (StringHelper.isNullOrEmpty((String)provides.getWsdl())) {
            return null;
        }
        try {
            uRL = new URL(provides.getWsdl());
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string, string2);
            if (!file.exists()) {
                throw new PEtALSCDKException("Can not retrieve WSDL document from location : " + string2);
            }
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        return uRL;
    }

    private static final void validateDescription(Description description, Provides provides) throws JBIException {
        block6: {
            try {
                Service service = (Service)description.getService(provides.getServiceName());
                if (service == null) {
                    throw new JBIException("Failed to find provided service '" + provides.getServiceName() + "' in the WSDL description");
                }
                Endpoint endpoint = (Endpoint)service.getEndpoint(provides.getEndpointName());
                if (endpoint == null) {
                    throw new JBIException("Failed to find provided endpoint '" + provides.getEndpointName() + "' in the WSDL description");
                }
                if (service.getInterface() != null && ((InterfaceType)service.getInterface()).getQName() != null) {
                    if (!((InterfaceType)service.getInterface()).getQName().equals(provides.getInterfaceName())) {
                        throw new JBIException("Failed to match provided interface '" + provides.getInterfaceName() + "'. Found '" + ((InterfaceType)service.getInterface()).getQName() + "' in the WSDL description");
                    }
                    break block6;
                }
                throw new JBIException("Failed to find an interface in WSDL description bound the provided service " + service.getQName());
            }
            catch (WSDLException wSDLException) {
                throw new JBIException("Failed to parse the WSDL description bound to the provided service '" + provides.getEndpointName() + "'", (Throwable)wSDLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deploy(String string, String string2) throws DeploymentException {
        Object object;
        this.logger.log(Level.INFO, "Deploy Service Unit '" + string + "'");
        if (this.serviceUnitDataHandlers.containsKey(string)) {
            this.logger.log(Level.SEVERE, "Service Unit '" + string + "' not deployed");
            return ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "deploy", "FAILED", "1", "A service unit with the name {1} is already deployed", new String[]{string});
        }
        File file = new File(string2, "META-INF" + File.separator + "jbi.xml");
        Throwable throwable = null;
        Jbi jbi = null;
        InputStream inputStream = null;
        try {
            object = this.processProperties(file);
            inputStream = new ByteArrayInputStream(((String)object).getBytes());
            jbi = JBIDescriptorBuilder.buildJavaJBIDescriptor((InputStream)inputStream);
        }
        catch (CDKJBIDescriptorException cDKJBIDescriptorException) {
            throwable = cDKJBIDescriptorException;
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throwable = pEtALSCDKException;
        }
        catch (IOException iOException) {
            throwable = iOException;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (throwable == null) {
            object = new ServiceUnitDataHandler(string, string2, jbi);
            this.logger.log(Level.FINE, "Register a data handler for SU '" + string + "'");
            this.serviceUnitDataHandlers.put(string, (ServiceUnitDataHandler)object);
            try {
                this.processConsumesNodes((ServiceUnitDataHandler)object);
                this.processProvidesNodes((ServiceUnitDataHandler)object);
                this.doDeploy(string, string2, jbi);
            }
            catch (Exception exception) {
                this.logger.log(Level.FINE, "Unregister the data handler for SU : " + string);
                for (ServiceEndpoint serviceEndpoint : ((ServiceUnitDataHandler)object).getServiceEndpoints().values()) {
                    try {
                        this.component.getContext().deactivateEndpoint(serviceEndpoint);
                    }
                    catch (JBIException jBIException) {
                        this.logger.log(Level.WARNING, "Error during deployment cleanup of Service unit '" + string + "'", exception);
                    }
                }
                this.serviceUnitDataHandlers.remove(string);
                throwable = exception;
            }
        }
        if (throwable == null) {
            object = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "deploy", "SUCCESS");
            this.logger.log(Level.INFO, "Service Unit '" + string + "' deployed");
        } else {
            object = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "deploy", "FAILED", "ERROR", "1", "Failed to deploy Service Unit : {1}", new String[]{string}, ExceptionUtil.getExtendedMessage((Exception)throwable));
            this.logger.log(Level.SEVERE, "Service Unit '" + string + "' failed to deploy", throwable);
        }
        return object;
    }

    public Consumes getConsumesForEndpoint(String string) {
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes : serviceUnitDataHandler.getDescriptor().getServices().getConsumes()) {
                if (!string.equals(consumes.getEndpointName())) continue;
                return consumes;
            }
        }
        return null;
    }

    public Consumes getConsumesForInterface(QName qName) {
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes : serviceUnitDataHandler.getDescriptor().getServices().getConsumes()) {
                if (!qName.equals(consumes.getInterfaceName())) continue;
                return consumes;
            }
        }
        return null;
    }

    public Consumes getConsumesForService(QName qName) {
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes : serviceUnitDataHandler.getDescriptor().getServices().getConsumes()) {
                if (!qName.equals(consumes.getServiceName())) continue;
                return consumes;
            }
        }
        return null;
    }

    public Consumes getConsumesFromDestination(String string, QName qName, QName qName2) {
        Consumes consumes = null;
        if (string != null) {
            consumes = this.getConsumesForEndpoint(string);
        }
        if (consumes == null) {
            if (qName != null) {
                consumes = this.getConsumesForService(qName);
            }
            if (consumes == null && qName2 != null) {
                consumes = this.getConsumesForInterface(qName2);
            }
        }
        return consumes;
    }

    public Set<ServiceEndpoint> getEndpointsForServiceUnit(String string) {
        HashSet<ServiceEndpoint> hashSet = new HashSet<ServiceEndpoint>();
        for (ServiceEndpointKey serviceEndpointKey : ((ServiceUnitDataHandler)this.serviceUnitDataHandlers.get(string)).getServiceEndpoints().keySet()) {
            hashSet.add(((ServiceUnitDataHandler)this.serviceUnitDataHandlers.get(string)).getServiceEndpoints().get(serviceEndpointKey));
        }
        return hashSet;
    }

    public Provides getProvidesFromEndpoint(ServiceEndpoint serviceEndpoint) {
        if (serviceEndpoint != null) {
            ServiceEndpointKey serviceEndpointKey = new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
            for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
                Provides provides = serviceUnitDataHandler.getEpJBIDesc().get(serviceEndpointKey);
                if (provides == null) continue;
                return provides;
            }
        }
        return null;
    }

    public Document getServiceDescription(ServiceEndpoint serviceEndpoint) {
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            Document document = serviceUnitDataHandler.getEndpointDescription(serviceEndpoint);
            if (document == null) continue;
            return document;
        }
        return null;
    }

    public Map<String, ServiceUnitDataHandler> getServiceUnitDataHandlers() {
        return this.serviceUnitDataHandlers;
    }

    public ServiceUnitDataHandler getSUDataHandlerForConsumes(Consumes consumes) {
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            for (Consumes consumes2 : serviceUnitDataHandler.getDescriptor().getServices().getConsumes()) {
                if (!consumes.equals(consumes2)) continue;
                return serviceUnitDataHandler;
            }
        }
        return null;
    }

    public ServiceUnitDataHandler getSUDataHandlerForEndpoint(ServiceEndpoint serviceEndpoint) {
        ServiceEndpointKey serviceEndpointKey = new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            for (ServiceEndpointKey serviceEndpointKey2 : serviceUnitDataHandler.getEpJBIDesc().keySet()) {
                if (!serviceEndpointKey.equals(serviceEndpointKey2)) continue;
                return serviceUnitDataHandler;
            }
        }
        return null;
    }

    public ServiceUnitDataHandler getSUDataHandlerForProvides(Provides provides) {
        for (ServiceUnitDataHandler serviceUnitDataHandler : this.serviceUnitDataHandlers.values()) {
            for (Provides provides2 : serviceUnitDataHandler.getDescriptor().getServices().getProvides()) {
                if (!provides.equals(provides2)) continue;
                return serviceUnitDataHandler;
            }
        }
        return null;
    }

    public ServiceUnitDataHandler getSUDataHandlerForService(Object object) {
        ServiceUnitDataHandler serviceUnitDataHandler = null;
        if (object instanceof Consumes) {
            serviceUnitDataHandler = this.getSUDataHandlerForConsumes((Consumes)object);
        } else if (object instanceof Provides) {
            serviceUnitDataHandler = this.getSUDataHandlerForProvides((Provides)object);
        }
        return serviceUnitDataHandler;
    }

    public void init(String string, String string2) throws DeploymentException {
        this.logger.log(Level.INFO, "Init Service Unit '" + string + "'");
        try {
            this.doInit(string, string2);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new DeploymentException("Failed to init the Service Unit '" + string + "'", (Throwable)pEtALSCDKException);
        }
    }

    public void shutDown(String string) throws DeploymentException {
        this.logger.log(Level.INFO, "Shut down Service Unit '" + string + "'");
        try {
            this.doShutdown(string);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new DeploymentException("Failed to shut down the Service Unit '" + string + "'", (Throwable)pEtALSCDKException);
        }
    }

    public void start(String string) throws DeploymentException {
        this.logger.log(Level.INFO, "Start Service Unit '" + string + "'");
        try {
            this.doStart(string);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new DeploymentException("Failed to start the Service Unit '" + string + "'", (Throwable)pEtALSCDKException);
        }
    }

    public void stop(String string) throws DeploymentException {
        this.logger.log(Level.INFO, "Stop Service Unit '" + string + "'");
        try {
            this.doStop(string);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new DeploymentException("Failed to stop the Service Unit '" + string + "'", (Throwable)pEtALSCDKException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String undeploy(String string, String string2) throws DeploymentException {
        Object object;
        this.logger.log(Level.INFO, "Undeploy Service Unit " + string);
        Throwable throwable = null;
        ServiceUnitDataHandler serviceUnitDataHandler = (ServiceUnitDataHandler)this.serviceUnitDataHandlers.get(string);
        for (ServiceEndpoint serviceEndpoint : serviceUnitDataHandler.getServiceEndpoints().values()) {
            try {
                this.component.getContext().deactivateEndpoint(serviceEndpoint);
            }
            catch (JBIException jBIException) {
                if (throwable == null) {
                    throwable = jBIException;
                    continue;
                }
                this.logger.log(Level.WARNING, "Several errors during undeployment of Service unit '" + string + "'", jBIException);
            }
        }
        try {
            this.doUndeploy(string);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            if (throwable == null) {
                throwable = pEtALSCDKException;
            } else {
                this.logger.log(Level.WARNING, "Several errors during undeployment of Service unit '" + string + "'", pEtALSCDKException);
            }
        }
        finally {
            this.serviceUnitDataHandlers.remove(string);
        }
        if (throwable == null) {
            object = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "undeploy", "SUCCESS");
            this.logger.log(Level.INFO, "Service unit '" + string + "' undeploy");
        } else {
            object = ManagementMessageUtil.getComponentTaskResult(this.component.getContext().getComponentName(), "undeploy", "FAILED", "ERROR", "1", "Failed to undeploy Service Unit {1}", new String[]{string}, ExceptionUtil.getExtendedMessage((Exception)throwable));
            this.logger.log(Level.SEVERE, "Service unit '" + string + "' failed to undeploy", throwable);
        }
        return object;
    }

    protected void doDeploy(String string, String string2, Jbi jbi) throws PEtALSCDKException {
    }

    protected void doInit(String string, String string2) throws PEtALSCDKException {
    }

    protected void doShutdown(String string) throws PEtALSCDKException {
    }

    protected void doStart(String string) throws PEtALSCDKException {
    }

    protected void doStop(String string) throws PEtALSCDKException {
    }

    protected void doUndeploy(String string) throws PEtALSCDKException {
    }

    private void processConsumesNodes(ServiceUnitDataHandler serviceUnitDataHandler) throws JBIException {
        Jbi jbi = serviceUnitDataHandler.getDescriptor();
        List list = jbi.getServices().getConsumes();
        for (Consumes consumes : list) {
            this.processInterceptors(serviceUnitDataHandler, consumes);
        }
    }

    private void processInterceptors(ServiceUnitDataHandler serviceUnitDataHandler, Object object) throws JBIException {
        SUInterceptors sUInterceptors;
        if (object instanceof Consumes) {
            sUInterceptors = ((Consumes)object).getSuInterceptors();
        } else if (object instanceof Provides) {
            sUInterceptors = ((Provides)object).getSuInterceptors();
        } else {
            throw new PEtALSCDKException("The service parameter must either a Consumes class or a Provides class");
        }
        MessageInterceptorManager messageInterceptorManager = this.component.getComponentConfiguration().getPropertiesFile() != null && !StringHelper.isNullOrEmpty((String)this.component.getComponentConfiguration().getPropertiesFile().getValue()) ? new MessageInterceptorManager(this.component.getComponentConfiguration().getPropertiesFile().getValue(), this.logger) : new MessageInterceptorManager(this.logger);
        List list = null;
        List list2 = null;
        List list3 = null;
        List list4 = null;
        if (sUInterceptors != null) {
            if (sUInterceptors.getSend() != null) {
                list = sUInterceptors.getSend().getInterceptor();
            }
            if (sUInterceptors.getSendResponse() != null) {
                list2 = sUInterceptors.getSendResponse().getInterceptor();
            }
            if (sUInterceptors.getAccept() != null) {
                list3 = sUInterceptors.getAccept().getInterceptor();
            }
            if (sUInterceptors.getAcceptResponse() != null) {
                list4 = sUInterceptors.getAcceptResponse().getInterceptor();
            }
        }
        messageInterceptorManager.init(this.component.getInterceptors(), list3, list, list4, list2);
        serviceUnitDataHandler.addMessageInterceptorManager(object, messageInterceptorManager);
    }

    private String processProperties(File file) throws IOException, PEtALSCDKException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = SourceUtil.createString(new StreamSource(fileInputStream));
        fileInputStream.close();
        if (this.component.getComponentConfiguration().getPropertiesFile() != null && !StringHelper.isNullOrEmpty((String)this.component.getComponentConfiguration().getPropertiesFile().getValue())) {
            try {
                Properties properties = PropertiesUtil.loadProperties((String)this.component.getComponentConfiguration().getPropertiesFile().getValue());
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    string = string.replaceAll("\\$\\{" + entry.getKey() + "\\}", (String)entry.getValue());
                }
            }
            catch (PropertiesException propertiesException) {
                throw new PEtALSCDKException((Throwable)propertiesException);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceEndpoint processProvidesNode(ServiceUnitDataHandler serviceUnitDataHandler, Provides provides) throws CDKJBIDescriptorException, WSDLException, IOException, JBIException {
        FileOutputStream fileOutputStream;
        Object object;
        URL uRL = AbstractServiceUnitManager.getWsdlLocation(serviceUnitDataHandler.getInstallRoot(), provides);
        Description description = AbstractServiceUnitManager.getWsdlDescription(uRL, provides);
        String string = provides.getEndpointName();
        if ("autogenerate".equals(string)) {
            Object object2;
            string = EndpointUtil.generateEndpointName();
            provides.setEndpointName(string);
            object = new File(serviceUnitDataHandler.getInstallRoot(), "META-INF" + File.separator + "jbi.xml");
            fileOutputStream = new FileOutputStream((File)object);
            try {
                JBIDescriptorBuilder.buildXmlJBIdescriptor((Jbi)serviceUnitDataHandler.getDescriptor(), (OutputStream)fileOutputStream);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
            Service service = (Service)description.getService(provides.getServiceName());
            if (service != null) {
                object2 = (Endpoint)service.getEndpoint("autogenerate");
                if (object2 != null) {
                    object2.setName(string);
                }
            } else {
                throw new JBIException("Failed to find provided service '" + provides.getServiceName() + "' in the WSDL description");
            }
            if (uRL != null) {
                description.deleteImportedDocumentsInWsdl();
                object2 = WSDLUtilImpl.convertDescriptionToString(description);
                FileOutputStream fileOutputStream2 = new FileOutputStream(new File(uRL.getFile()));
                try {
                    ((OutputStream)fileOutputStream2).write(((String)object2).getBytes());
                }
                finally {
                    ((OutputStream)fileOutputStream2).close();
                }
                description.addImportedDocumentsInWsdl();
            }
        }
        object = WSDLUtilImpl.convertDescriptionToDocument(description);
        if (provides.getValidateWsdl() == null || provides.getValidateWsdl().isValue()) {
            this.logger.fine("Validating the provided WSDL description");
            AbstractServiceUnitManager.validateDescription(description, provides);
        }
        this.processInterceptors(serviceUnitDataHandler, provides);
        serviceUnitDataHandler.addEndpointDescription(provides.getServiceName(), string, (Document)object);
        serviceUnitDataHandler.addJBIDescription(provides.getServiceName(), string, provides);
        fileOutputStream = this.component.getContext().activateEndpoint(provides.getServiceName(), string);
        serviceUnitDataHandler.addServiceEndpoint((ServiceEndpoint)fileOutputStream);
        return fileOutputStream;
    }

    private void processProvidesNodes(ServiceUnitDataHandler serviceUnitDataHandler) throws WSDLException, CDKJBIDescriptorException, IOException, JBIException {
        Jbi jbi = serviceUnitDataHandler.getDescriptor();
        List list = jbi.getServices().getProvides();
        for (Provides provides : list) {
            ServiceEndpoint serviceEndpoint = this.processProvidesNode(serviceUnitDataHandler, provides);
            this.logger.log(Level.INFO, "New Service Endpoint deployed : " + serviceEndpoint);
        }
    }
}

