/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.util.List;
import javax.jbi.management.DeploymentException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.bc.AbstractBindingComponent;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.process.ExternalListenerManager;
import org.ow2.petals.component.framework.su.AbstractServiceUnitManager;
import org.ow2.petals.component.framework.su.ServiceUnitDataHandler;

public class BindingComponentServiceUnitManager
extends AbstractServiceUnitManager {
    private final ExternalListenerManager externalListenerManager;

    public BindingComponentServiceUnitManager(AbstractBindingComponent abstractBindingComponent) {
        super(abstractBindingComponent);
        this.externalListenerManager = new ExternalListenerManager(this.component);
    }

    @Override
    public void init(String string, String string2) throws DeploymentException {
        super.init(string, string2);
        try {
            this.externalListenerManager.createListeners(string, this.getConsumesForSU(string));
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            String string3 = "Failed to initialize SU : " + string;
            this.logger.severe(string3);
            throw new DeploymentException(string3, (Throwable)pEtALSCDKException);
        }
    }

    @Override
    public void start(String string) throws DeploymentException {
        super.start(string);
        try {
            this.externalListenerManager.startListening(string);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            String string2 = "Failed to start SU : " + string;
            this.logger.severe(string2);
            throw new DeploymentException(string2, (Throwable)pEtALSCDKException);
        }
    }

    @Override
    public void stop(String string) throws DeploymentException {
        try {
            this.externalListenerManager.stopListening(string);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            String string2 = "Failed to stop SU : " + string;
            this.logger.severe(string2);
            throw new DeploymentException(string2, (Throwable)pEtALSCDKException);
        }
        super.stop(string);
    }

    @Override
    public String undeploy(String string, String string2) throws DeploymentException {
        this.externalListenerManager.removeListeners(string);
        return super.undeploy(string, string2);
    }

    private List<Consumes> getConsumesForSU(String string) throws DeploymentException {
        ServiceUnitDataHandler serviceUnitDataHandler = this.getServiceUnitDataHandlers().get(string);
        if (serviceUnitDataHandler != null) {
            return serviceUnitDataHandler.getDescriptor().getServices().getConsumes();
        }
        throw new DeploymentException("No data handler for su : " + string + ". SU not deployed.");
    }
}

