/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.su;

import java.util.HashMap;
import java.util.Map;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.configuration.ConfigurationExtensions;
import org.ow2.petals.component.framework.interceptor.MessageInterceptorManager;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;
import org.ow2.petals.component.framework.util.ServiceEndpointKey;
import org.w3c.dom.Document;

public class ServiceUnitDataHandler {
    private Jbi descriptor;
    private Map<ServiceEndpointKey, Provides> epJBIDesc;
    private Map<ServiceEndpointKey, Document> epServiceDesc = new HashMap<ServiceEndpointKey, Document>();
    private final Map<ServiceEndpointKey, ServiceEndpoint> endpoints;
    private final Map<Object, MessageInterceptorManager> messageInterceptorManagersMap;
    private final Map<Object, ConfigurationExtensions> configurationExtensionsMap;
    private final Map<Consumes, ConfigurationExtensions> exchangePropertiesMap;
    private String installRoot;
    private String name;

    private ServiceUnitDataHandler() {
        this.epJBIDesc = new HashMap<ServiceEndpointKey, Provides>();
        this.endpoints = new HashMap<ServiceEndpointKey, ServiceEndpoint>();
        this.messageInterceptorManagersMap = new HashMap<Object, MessageInterceptorManager>();
        this.configurationExtensionsMap = new HashMap<Object, ConfigurationExtensions>();
        this.exchangePropertiesMap = new HashMap<Consumes, ConfigurationExtensions>();
    }

    public ServiceUnitDataHandler(String string, String string2, Jbi jbi) {
        this();
        this.name = string;
        this.installRoot = string2;
        this.descriptor = jbi;
        for (Consumes consumes : this.descriptor.getServices().getConsumes()) {
            this.configurationExtensionsMap.put(consumes, new ConfigurationExtensions(consumes.getAny()));
            if (consumes.getExchangeProperties() == null) continue;
            this.exchangePropertiesMap.put(consumes, new ConfigurationExtensions(consumes.getExchangeProperties().getExchangeProperty()));
        }
        for (Consumes consumes : this.descriptor.getServices().getProvides()) {
            this.configurationExtensionsMap.put(consumes, new ConfigurationExtensions(consumes.getAny()));
        }
    }

    public void addEndpointDescription(ServiceEndpoint serviceEndpoint, Document document) {
        this.addEndpointDescription(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName(), document);
    }

    public Document getEndpointDescription(ServiceEndpoint serviceEndpoint) {
        return this.epServiceDesc.get(new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()));
    }

    public void addEndpointDescription(QName qName, String string, Document document) {
        this.epServiceDesc.put(new ServiceEndpointKey(qName, string), document);
    }

    public void addJBIDescription(ServiceEndpoint serviceEndpoint, Provides provides) {
        this.addJBIDescription(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName(), provides);
    }

    public void addJBIDescription(QName qName, String string, Provides provides) {
        this.epJBIDesc.put(new ServiceEndpointKey(qName, string), provides);
    }

    public void addServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        this.endpoints.put(new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()), serviceEndpoint);
    }

    public Map<ServiceEndpointKey, ServiceEndpoint> getServiceEndpoints() {
        return this.endpoints;
    }

    public Jbi getDescriptor() {
        return this.descriptor;
    }

    public Map<ServiceEndpointKey, Provides> getEpJBIDesc() {
        return this.epJBIDesc;
    }

    public Map<ServiceEndpointKey, Document> getEpServiceDesc() {
        return this.epServiceDesc;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public String getName() {
        return this.name;
    }

    public void removeEndpoint(ServiceEndpoint serviceEndpoint) {
        ServiceEndpointKey serviceEndpointKey = new ServiceEndpointKey(serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName());
        this.epServiceDesc.remove(serviceEndpointKey);
        this.epJBIDesc.remove(serviceEndpointKey);
        this.endpoints.remove(serviceEndpointKey);
    }

    public void setEpJBIDesc(Map<ServiceEndpointKey, Provides> map) {
        this.epJBIDesc = map;
    }

    public void setEpServiceDesc(Map<ServiceEndpointKey, Document> map) {
        this.epServiceDesc = map;
    }

    public void addMessageInterceptorManager(Object object, MessageInterceptorManager messageInterceptorManager) {
        if (!(object instanceof Consumes) && !(object instanceof Provides)) {
            throw new IllegalArgumentException("The parameter service  is not an instance of Provides or Consumes Classes");
        }
        this.messageInterceptorManagersMap.put(object, messageInterceptorManager);
    }

    public MessageInterceptorManager getMessageInterceptorManager(Object object) {
        return this.messageInterceptorManagersMap.get(object);
    }

    public Map<Object, MessageInterceptorManager> getMessageInterceptorManagersMap() {
        return this.messageInterceptorManagersMap;
    }

    public ConfigurationExtensions getConfigurationExtensions(Object object) {
        return this.configurationExtensionsMap.get(object);
    }
}

