/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class FileNamePatternUtil {
    private static FileNamePatternUtil instance = new FileNamePatternUtil();

    private FileNamePatternUtil() {
    }

    public static FileNamePatternUtil getInstance() {
        return instance;
    }

    public RegexFileNameFilter buildFileNameFilterFromRegex(String string) {
        return new RegexFileNameFilter(string);
    }

    public RegexFileNameFilter buildFileNameFilterFromWildChar(String string) {
        return new RegexFileNameFilter(this.wildcharToRegex(string));
    }

    public RegexFileNameFilter buildFileNameFilterFromFilters(List<RegexFileNameFilter> list) {
        return new RegexFileNameFilterList(list);
    }

    public String regexToWildchar(String string) {
        String string2 = string.replaceAll("\\\\.", "\u00b2");
        String string3 = string2.replaceAll("\\.", "?");
        String string4 = string3.replaceAll("\u00b2", ".");
        return string4;
    }

    public String wildcharToRegex(String string) {
        return string.replaceAll("\\.", "\\\\.").replace("*", ".*").replaceAll("\\?", ".");
    }

    public static class RegexFileNameFilterList
    extends RegexFileNameFilter {
        private List<RegexFileNameFilter> list;

        public RegexFileNameFilterList(List<RegexFileNameFilter> list) {
            this.list = list;
        }

        @Override
        public boolean accept(File file, String string) {
            boolean bl = false;
            Iterator<RegexFileNameFilter> iterator = this.list.iterator();
            while (iterator.hasNext() && !bl) {
                bl = iterator.next().accept(null, string);
            }
            return bl;
        }
    }

    public static class RegexFileNameFilter
    implements FilenameFilter {
        private static final String ANY_VALUE = ".*";
        private String regex;

        public RegexFileNameFilter() {
            this(ANY_VALUE);
        }

        public RegexFileNameFilter(String string) {
            this.regex = string;
        }

        @Override
        public boolean accept(File file, String string) {
            return Pattern.compile(this.regex, 2).matcher(string).matches();
        }
    }
}

