/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MtomUtil {
    public static final String MTOM_NSURI = "http://www.w3.org/2004/08/xop/include";
    public static final String NODE_ATTACHMENTS = "attachments";

    public static boolean compare(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        try {
            String string3 = URLEncoder.encode(string2, "UTF-8");
            if (string.equals(string3)) {
                return true;
            }
            String string4 = string.replace("@", "%40");
            if (string4.equals(string3)) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public static final String convertQNameToString(QName qName) {
        return qName.getPrefix().length() > 0 ? qName.getPrefix() + ":" + qName.getLocalPart() : qName.getLocalPart();
    }

    @Deprecated
    public static Element extractAttachmentRootElement(Document document) throws MessagingException {
        NodeList nodeList = document.getElementsByTagNameNS("*", NODE_ATTACHMENTS);
        if (nodeList.getLength() != 1) {
            throw new MessagingException("xml element : 'attachments' not found.");
        }
        Element element = (Element)nodeList.item(0);
        return element;
    }

    public static Set<String> extractAttachmentsIdFromPayload(Element element) {
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        NodeList nodeList = element.getElementsByTagNameNS(MTOM_NSURI, "*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!"include".equalsIgnoreCase(MtomUtil.getNodeName(node))) continue;
            string = ((Element)node).getAttribute("href").replaceFirst("cid:", "");
            hashSet.add(string);
        }
        return hashSet;
    }

    public static DocumentFragment generateMtomStructure(Document document, List<String> list, QName qName) {
        DocumentFragment documentFragment = document.createDocumentFragment();
        String string = MtomUtil.convertQNameToString(qName);
        Element element = null;
        for (String string2 : list) {
            element = document.createElementNS(qName.getNamespaceURI(), string);
            element.appendChild(MtomUtil.generateMtomXopElement(document, string2));
            documentFragment.appendChild(element);
        }
        return documentFragment;
    }

    public static Node generateMtomStructure(Document document, List<String> list, QName qName, QName qName2) {
        Element element = document.createElementNS(qName.getNamespaceURI(), MtomUtil.convertQNameToString(qName));
        DocumentFragment documentFragment = MtomUtil.generateMtomStructure(document, list, qName2);
        element.appendChild(documentFragment);
        return element;
    }

    public static Node generateMtomXopElement(Document document, String string) {
        Element element = document.createElementNS(MTOM_NSURI, "xop:Include");
        element.setAttribute("href", "cid:" + string);
        return element;
    }

    @Deprecated
    public static Map<String, DataHandler> getAttachments(Document document, NormalizedMessage normalizedMessage) throws MessagingException {
        HashMap<String, DataHandler> hashMap = new HashMap<String, DataHandler>();
        Element element = MtomUtil.extractAttachmentRootElement(document);
        Set<String> set = MtomUtil.extractAttachmentsIdFromPayload(element);
        if (set.size() == 0) {
            throw new MessagingException("no attachment id was found in the message payload");
        }
        for (String string : set) {
            for (Object e : normalizedMessage.getAttachmentNames()) {
                String string2 = (String)e;
                if (!MtomUtil.compare(string, string2)) continue;
                hashMap.put(string2, normalizedMessage.getAttachment(string2));
            }
        }
        if (hashMap.size() != set.size()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("error when comparing the attachments id | ");
            stringBuilder.append("payload attachment id found : " + set.toString() + " | ");
            stringBuilder.append("normalized message attachment id found : " + normalizedMessage.getAttachmentNames().toString());
            throw new MessagingException(stringBuilder.toString());
        }
        return hashMap;
    }

    public static MtomMapping getMtomMapping(Exchange exchange, Element element) throws MessagingException {
        Object object;
        MtomMapping mtomMapping = null;
        if (element == null && (object = exchange.getInMessageContentAsDocument(true)) != null && object.getDocumentElement() != null) {
            element = object.getDocumentElement();
        }
        if (element != null) {
            mtomMapping = new MtomMapping();
            object = MtomUtil.extractAttachmentsIdFromPayload(element);
            ArrayList<DataHandler> arrayList = new ArrayList<DataHandler>();
            for (String string : exchange.getInMessageAttachmentNames()) {
                arrayList.add(exchange.getInMessageAttachment(string));
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string;
                string = (String)iterator.next();
                DataHandler dataHandler = null;
                for (String string2 : exchange.getInMessageAttachmentNames()) {
                    if (!MtomUtil.compare(string, string2)) continue;
                    dataHandler = exchange.getInMessageAttachment(string2);
                    break;
                }
                if (dataHandler != null) {
                    arrayList.remove(dataHandler);
                    mtomMapping.put(string, dataHandler);
                    continue;
                }
                mtomMapping.add(string);
            }
            mtomMapping.addAll(arrayList);
        }
        return mtomMapping;
    }

    public static String getNodeName(Node node) {
        String string;
        String string2 = string = node.getNamespaceURI() != null ? node.getLocalName() : node.getNodeName();
        if (string.contains(":")) {
            String[] stringArray = string.split(":");
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    public static class MtomMapping {
        private final Map<String, DataHandler> contentIdToDataHandler = new HashMap<String, DataHandler>();
        private final Set<String> orphanContentIds = new HashSet<String>();
        private final List<DataHandler> orphanDataHandlers = new ArrayList<DataHandler>();

        public Map<String, DataHandler> getContentIdToDataHandler() {
            return this.contentIdToDataHandler;
        }

        public Set<String> getOrphanContentIds() {
            return this.orphanContentIds;
        }

        public List<DataHandler> getOrphanDataHandlers() {
            return this.orphanDataHandlers;
        }

        boolean add(DataHandler dataHandler) {
            return this.orphanDataHandlers.add(dataHandler);
        }

        boolean add(String string) {
            return this.orphanContentIds.add(string);
        }

        boolean addAll(Collection<? extends DataHandler> collection) {
            return this.orphanDataHandlers.addAll(collection);
        }

        DataHandler put(String string, DataHandler dataHandler) {
            return this.contentIdToDataHandler.put(string, dataHandler);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.orphanContentIds.size() != 0) {
                stringBuilder.append("Orphan Content Id : ");
                stringBuilder.append(this.orphanContentIds.toString());
                stringBuilder.append("\n");
            }
            if (this.orphanDataHandlers.size() != 0) {
                stringBuilder.append("Orphan data handler name : [");
                for (DataHandler dataHandler : this.orphanDataHandlers) {
                    stringBuilder.append(dataHandler.getName() + ",");
                }
                stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length(), "]");
                stringBuilder.append("\n");
            }
            if (this.contentIdToDataHandler.size() != 0) {
                stringBuilder.append("Map associating content ID to DataHandler :");
                stringBuilder.append(this.contentIdToDataHandler.toString());
            }
            return stringBuilder.toString();
        }
    }
}

