/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.stream.InputStreamForker;
import com.ebmwebsourcing.easycommons.stream.ReaderInputStream;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.component.framework.api.exception.DocumentException;
import org.ow2.petals.component.framework.api.exception.FaultException;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SourceUtil {
    private static final String SOAPENV_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";

    private static final InputStream forkStreamSource(StreamSource streamSource) {
        InputStream inputStream = streamSource.getInputStream();
        InputStreamForker inputStreamForker = inputStream != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader()));
        try {
            streamSource.setInputStream(inputStreamForker.fork());
            return inputStreamForker.fork();
        }
        catch (IOException iOException) {
            throw new UncheckedException((Throwable)iOException);
        }
    }

    public static final Document createDocument(Source source) throws PEtALSCDKException {
        return SourceUtil.createDocument(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document createDocument(Source source, boolean bl) throws PEtALSCDKException {
        Document document;
        block14: {
            document = null;
            try {
                Object object;
                Object object2;
                if (source instanceof DOMSource) {
                    object2 = ((DOMSource)source).getNode();
                    if (object2 instanceof Document) {
                        object = (Document)object2;
                        if (bl) {
                            document = DocumentBuilders.newDocument();
                            document.appendChild(document.importNode(object.getDocumentElement(), true));
                        } else {
                            document = object;
                        }
                    } else {
                        document = DocumentBuilders.newDocument();
                        if (bl) {
                            document.appendChild(document.importNode((Node)object2, true));
                        } else {
                            document.appendChild(document.adoptNode((Node)object2));
                        }
                    }
                }
                if (document != null) break block14;
                object2 = source;
                if (bl && source instanceof StreamSource) {
                    object2 = new StreamSource(SourceUtil.forkStreamSource((StreamSource)source));
                }
                document = DocumentBuilders.newDocument();
                object = new DOMResult(document);
                Transformer transformer = Transformers.takeTransformer();
                try {
                    transformer.transform((Source)object2, (Result)object);
                }
                finally {
                    Transformers.releaseTransformer((Transformer)transformer);
                }
            }
            catch (TransformerException transformerException) {
                throw new PEtALSCDKException((Throwable)transformerException);
            }
            catch (PoolException poolException) {
                throw new PEtALSCDKException((Throwable)poolException);
            }
        }
        return document;
    }

    public static final DOMSource createDOMSource(Document document) {
        document.normalizeDocument();
        return new DOMSource(document);
    }

    public static final Document createSoapFaultDocument(Throwable throwable, QName qName) {
        Element element;
        Node node;
        Object object;
        Node node2;
        Object object2;
        String string;
        Object object3;
        QName qName2 = qName;
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = "null message";
        }
        URI uRI = null;
        if (throwable instanceof DocumentException) {
            qName2 = ((DocumentException)throwable).getFaultCode();
            uRI = ((DocumentException)throwable).getFaultActor();
            object3 = ((DocumentException)throwable).getDocument();
            if (object3 != null) {
                try {
                    string = XMLHelper.createStringFromDOMDocument((Node)object3);
                }
                catch (TransformerException transformerException) {
                    string = "An error occured when retrieving the exception document (" + transformerException.getMessage() + ").";
                }
                catch (PoolException poolException) {
                    string = "An error occured when retrieving the exception document (" + poolException.getMessage() + ").";
                }
            } else {
                string = "";
            }
        } else if (throwable instanceof FaultException) {
            qName2 = ((FaultException)throwable).getFaultCode();
            uRI = ((FaultException)throwable).getFaultActor();
            object3 = new StringWriter();
            object2 = new PrintWriter((Writer)object3);
            throwable.printStackTrace((PrintWriter)object2);
            string = ((StringWriter)object3).toString();
        } else {
            object3 = new StringWriter();
            object2 = new PrintWriter((Writer)object3);
            throwable.printStackTrace((PrintWriter)object2);
            string = ((StringWriter)object3).toString();
        }
        object3 = DocumentBuilders.newDocument();
        object2 = object3.createElementNS(SOAPENV_NAMESPACE, "soapenv:Fault");
        if (!SourceUtil.isDOM3((Document)object3)) {
            node2 = object3.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soapenv");
            node2.appendChild(object3.createTextNode(SOAPENV_NAMESPACE));
            object2.setAttributeNode((Attr)node2);
        }
        object3.appendChild((Node)object2);
        node2 = object3.createElement("faultcode");
        if (qName2 != null) {
            if (qName2.getNamespaceURI() != null) {
                if (qName2.getNamespaceURI().equals(SOAPENV_NAMESPACE)) {
                    node2.appendChild(object3.createTextNode("soapenv:" + qName2.getLocalPart()));
                } else {
                    object = qName2.getPrefix();
                    if (StringHelper.isNullOrEmpty((String)object)) {
                        object = "fcns";
                    }
                    node = object3.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)object);
                    node.appendChild(object3.createTextNode(qName2.getNamespaceURI()));
                    node2.setAttributeNode((Attr)node);
                    node2.appendChild(object3.createTextNode((String)object + ":" + qName2.getLocalPart()));
                }
            } else {
                node2.appendChild(object3.createTextNode(qName2.getLocalPart()));
            }
        }
        object = object3.createElement("faultstring");
        object.appendChild(object3.createCDATASection(string2));
        node = object3.createElement("detail");
        if (throwable instanceof DocumentException) {
            node.appendChild(object3.createCDATASection(string));
        } else {
            element = object3.createElement("stackTrace");
            node.appendChild(element);
            element.appendChild(object3.createCDATASection(string));
        }
        element = object3.createElement("faultactor");
        if (uRI != null) {
            element.appendChild(object3.createTextNode(uRI.toString()));
        }
        object2.appendChild(node2);
        object2.appendChild((Node)object);
        object2.appendChild(element);
        object2.appendChild(node);
        return object3;
    }

    public static final Source createSource(String string) throws PEtALSCDKException {
        String string2 = Charset.defaultCharset().displayName();
        return SourceUtil.createSource(string, string2);
    }

    public static final Source createSource(String string, String string2) throws PEtALSCDKException {
        StreamSource streamSource = new StreamSource();
        try {
            byte[] byArray = string.getBytes(string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            streamSource.setInputStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new PEtALSCDKException((Throwable)iOException);
        }
        return streamSource;
    }

    public static final StreamSource createStreamSource(Document document) throws PEtALSCDKException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException transformerException) {
            throw new PEtALSCDKException("Error while transform DOM document to StreamSource", (Throwable)transformerException);
        }
        catch (PoolException poolException) {
            throw new PEtALSCDKException("Error while transform DOM document to StreamSource", (Throwable)poolException);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return new StreamSource(byteArrayInputStream);
    }

    public static final String createString(Source source) throws PEtALSCDKException {
        return SourceUtil.createString(source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String createString(Source source, boolean bl) throws PEtALSCDKException {
        Source source2 = source;
        if (bl && source instanceof StreamSource) {
            source2 = new StreamSource(SourceUtil.forkStreamSource((StreamSource)source));
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            Transformer transformer = Transformers.takeTransformer();
            try {
                transformer.transform(source2, streamResult);
            }
            finally {
                Transformers.releaseTransformer((Transformer)transformer);
            }
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new PEtALSCDKException((Throwable)transformerException);
        }
        catch (PoolException poolException) {
            throw new PEtALSCDKException((Throwable)poolException);
        }
    }

    public static final boolean isDOM3(Document document) {
        boolean bl = true;
        try {
            document.getClass().getMethod("getBaseURI", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = false;
        }
        return bl;
    }
}

