/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.Constants;
import org.ow2.petals.component.framework.util.JVMDocumentBuilders;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class WSAHelper {
    private WSAHelper() {
    }

    public static final String getTo(Map<String, DocumentFragment> map) {
        return WSAHelper.getProperty(map, Constants.WSStar.Addressing.TO_QNAME.toString());
    }

    public static final String getFrom(Map<String, DocumentFragment> map) {
        return WSAHelper.getProperty(map, Constants.WSStar.Addressing.FROM_QNAME.toString());
    }

    public static final String getReplyTo(Map<String, DocumentFragment> map) {
        return WSAHelper.getProperty(map, Constants.WSStar.Addressing.REPLY_TO_QNAME.toString());
    }

    public static final DocumentFragment getElement(QName qName, String string) {
        DocumentFragment documentFragment = null;
        if (qName.equals(Constants.WSStar.Addressing.FROM_QNAME)) {
            documentFragment = WSAHelper.getFromFragment(string);
        } else if (qName.equals(Constants.WSStar.Addressing.REPLY_TO_QNAME)) {
            documentFragment = WSAHelper.getReplyToFragment(string);
        } else if (qName.equals(Constants.WSStar.Addressing.TO_QNAME)) {
            documentFragment = WSAHelper.getToFragment(string);
        }
        return documentFragment;
    }

    public static final DocumentFragment getToFragment(String string) {
        DocumentFragment documentFragment = WSAHelper.createDocumentFragment(Constants.WSStar.Addressing.TO_QNAME);
        documentFragment.getFirstChild().setTextContent(string);
        documentFragment.normalize();
        return documentFragment;
    }

    public static final DocumentFragment getFromFragment(String string) {
        DocumentFragment documentFragment = WSAHelper.createDocumentFragment(Constants.WSStar.Addressing.FROM_QNAME);
        Element element = WSAHelper.createAddressElement(string);
        documentFragment.getFirstChild().appendChild(documentFragment.getOwnerDocument().importNode(element, true));
        documentFragment.normalize();
        return documentFragment;
    }

    public static final DocumentFragment getReplyToFragment(String string) {
        DocumentFragment documentFragment = WSAHelper.createDocumentFragment(Constants.WSStar.Addressing.REPLY_TO_QNAME);
        Element element = WSAHelper.createAddressElement(string);
        documentFragment.getFirstChild().appendChild(documentFragment.getOwnerDocument().importNode(element, true));
        documentFragment.normalize();
        return documentFragment;
    }

    protected static final Element createAddressElement(String string) {
        Document document = JVMDocumentBuilders.newDocument();
        QName qName = Constants.WSStar.Addressing.ADDRESS_QNAME;
        Element element = document.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        element.setPrefix(qName.getPrefix());
        element.setTextContent(string);
        element.normalize();
        return element;
    }

    protected static final DocumentFragment createDocumentFragment(QName qName) {
        DocumentFragment documentFragment = null;
        Document document = JVMDocumentBuilders.newDocument();
        Element element = document.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        element.setPrefix(qName.getPrefix());
        documentFragment = document.createDocumentFragment();
        documentFragment.appendChild(document.importNode(element, true));
        documentFragment.normalize();
        return documentFragment;
    }

    private static final String getProperty(Map<String, DocumentFragment> map, String string) {
        String string2 = null;
        DocumentFragment documentFragment = map.get(string);
        if (documentFragment != null && documentFragment.getFirstChild() != null && documentFragment.getFirstChild() instanceof Element) {
            string2 = documentFragment.getTextContent();
        }
        return string2;
    }
}

