/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.util;

import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlFactory;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlReaders;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.WSDL4ComplexWsdlWriters;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlReader;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.WSDL4ComplexWsdlWriter;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.ow2.petals.component.framework.util.EndpointUtil;
import org.w3c.dom.Document;

public final class WSDLUtilImpl {
    public static final Description createLightWSDL20Description(QName qName, QName qName2, String string) throws WSDLException {
        if (!qName.getNamespaceURI().equals(qName2.getNamespaceURI())) {
            throw new WSDLException("The interface namespace '" + qName.getNamespaceURI() + "' must be the same than the service namespace '" + qName2.getNamespaceURI() + "' to build a light WSDL");
        }
        Description description = WSDL4ComplexWsdlFactory.newInstance().addComplexWsdlElmt2Description((AbsItfDescription)WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL20));
        description.setTargetNamespace(qName.getNamespaceURI());
        description.setQName(new QName("autoGenerated"));
        InterfaceType interfaceType = (InterfaceType)description.createInterface();
        interfaceType.setQName(qName);
        description.addInterface((AbsItfInterfaceType)interfaceType);
        Service service = (Service)description.createService();
        service.setQName(qName2);
        service.setInterface((AbsItfInterfaceType)interfaceType);
        Endpoint endpoint = (Endpoint)service.createEndpoint();
        endpoint.setName(string);
        service.addEndpoint((AbsItfEndpoint)endpoint);
        description.addService((AbsItfService)service);
        return description;
    }

    public static final List<Endpoint> getEndpointList(Description description, QName qName, String string) {
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        Endpoint endpoint = null;
        if (description != null) {
            if (qName == null) {
                List list = description.getServices();
                for (Service service : list) {
                    if (service == null) continue;
                    if (string == null) {
                        arrayList.addAll(service.getEndpoints());
                        continue;
                    }
                    endpoint = (Endpoint)service.getEndpoint(string);
                    if (endpoint == null) continue;
                    arrayList.add((Endpoint)service.getEndpoint(string));
                }
            } else {
                Service service = (Service)description.getService(qName);
                if (service != null) {
                    if (string == null) {
                        arrayList.addAll(service.getEndpoints());
                    } else {
                        endpoint = (Endpoint)service.getEndpoint(string);
                        if (endpoint != null) {
                            arrayList.add((Endpoint)service.getEndpoint(string));
                        }
                    }
                }
            }
        }
        return arrayList;
    }

    public static final List<Endpoint> getEndpointList(Description description) {
        return WSDLUtilImpl.getEndpointList(description, null, null);
    }

    public static final Description createWsdlDescription(URL uRL) throws WSDLException {
        return WSDLUtilImpl.createWsdlDescription(uRL, false, true);
    }

    public static final Description createWsdlDescription(URL uRL, boolean bl) throws WSDLException {
        return WSDLUtilImpl.createWsdlDescription(uRL, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Description createWsdlDescription(URL uRL, boolean bl, boolean bl2) throws WSDLException {
        Object object;
        block11: {
            String string = null;
            if (uRL == null) {
                return null;
            }
            WSDL4ComplexWsdlReader wSDL4ComplexWsdlReader = null;
            try {
                wSDL4ComplexWsdlReader = WSDL4ComplexWsdlReaders.takeWSDL4ComplexWsdlReader();
                Description description = wSDL4ComplexWsdlReader.read(uRL);
                if (bl2) {
                    description.addImportedDocumentsInWsdl();
                }
                if (bl) {
                    object = WSDLUtilImpl.getEndpointList(description, null, "autogenerate");
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Endpoint endpoint = (Endpoint)iterator.next();
                        string = EndpointUtil.generateEndpointName();
                        endpoint.setName(string);
                    }
                }
                object = description;
                if (wSDL4ComplexWsdlReader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (wSDL4ComplexWsdlReader != null) {
                        WSDL4ComplexWsdlReaders.releaseWSDL4ComplexWsdlReader((WSDL4ComplexWsdlReader)wSDL4ComplexWsdlReader);
                    }
                    throw throwable;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new WSDLException("Failed to parse the WSDL", (Throwable)uRISyntaxException);
                }
                catch (IOException iOException) {
                    throw new WSDLException("Failed to read the WSDL", (Throwable)iOException);
                }
            }
            WSDL4ComplexWsdlReaders.releaseWSDL4ComplexWsdlReader((WSDL4ComplexWsdlReader)wSDL4ComplexWsdlReader);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document convertDescriptionToDocument(Description description) throws WSDLException {
        WSDL4ComplexWsdlWriter wSDL4ComplexWsdlWriter = null;
        try {
            Document document;
            wSDL4ComplexWsdlWriter = WSDL4ComplexWsdlWriters.takeWSDL4ComplexWsdlWriter();
            Document document2 = document = wSDL4ComplexWsdlWriter.getDocument(description);
            return document2;
        }
        finally {
            if (wSDL4ComplexWsdlWriter != null) {
                WSDL4ComplexWsdlWriters.releaseWSDL4ComplexWsdlWriter((WSDL4ComplexWsdlWriter)wSDL4ComplexWsdlWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String convertDescriptionToString(Description description) throws WSDLException {
        WSDL4ComplexWsdlWriter wSDL4ComplexWsdlWriter = null;
        try {
            String string;
            wSDL4ComplexWsdlWriter = WSDL4ComplexWsdlWriters.takeWSDL4ComplexWsdlWriter();
            String string2 = string = wSDL4ComplexWsdlWriter.writeWSDL4ComplexWsdl(description);
            return string2;
        }
        finally {
            if (wSDL4ComplexWsdlWriter != null) {
                WSDL4ComplexWsdlWriters.releaseWSDL4ComplexWsdlWriter((WSDL4ComplexWsdlWriter)wSDL4ComplexWsdlWriter);
            }
        }
    }

    public static final boolean isDescriptionContaining(Description description, ServiceEndpoint serviceEndpoint) {
        if (serviceEndpoint == null || serviceEndpoint.getServiceName() == null || serviceEndpoint.getEndpointName() == null) {
            return false;
        }
        return !WSDLUtilImpl.getEndpointList(description, serviceEndpoint.getServiceName(), serviceEndpoint.getEndpointName()).isEmpty();
    }

    public static final void convertDescriptionToFile(Description description, File file) throws WSDLException {
        Document document = WSDLUtilImpl.convertDescriptionToDocument(description);
        StreamResult streamResult = new StreamResult(file);
        Transformer transformer = null;
        try {
            transformer = Transformers.takeTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (TransformerException transformerException) {
            throw new WSDLException("Failed to write the WSDL", (Throwable)transformerException);
        }
        catch (PoolException poolException) {
            throw new WSDLException("Failed to write the WSDL", (Throwable)poolException);
        }
        finally {
            if (transformer != null) {
                Transformers.releaseTransformer((Transformer)transformer);
            }
        }
    }
}

