/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.petals.component.framework.api.PetalsComponent;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.jbidescriptor.generated.Consumes;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

public abstract class Interceptor {
    protected PetalsComponent component;
    protected String name;
    protected Map<String, String> componentParameters;
    protected boolean active = false;
    protected Logger logger;

    public final void init(PetalsComponent petalsComponent, String string, boolean bl, Map<String, String> map, Logger logger) throws PEtALSCDKException {
        this.component = petalsComponent;
        this.componentParameters = map;
        this.logger = logger;
        this.name = string;
        this.active = bl;
        try {
            this.onInit();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Problem during interceptor initialization");
            throw new PEtALSCDKException("Interceptor initialization failure");
        }
    }

    protected void onInit() throws Exception {
    }

    public abstract void handleMessageSent(Exchange var1, Consumes var2, Map<String, String> var3);

    public abstract void handleMessageSentResponse(Exchange var1, Consumes var2, Map<String, String> var3);

    public abstract void handleMessageAccept(Exchange var1, Provides var2, Map<String, String> var3);

    public abstract void handleMessageAcceptResponse(Exchange var1, Provides var2, Map<String, String> var3);

    public final String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public Map<String, String> getComponentParameters() {
        return this.componentParameters;
    }
}

