/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.configuration;

import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import com.ebmwebsourcing.easycommons.properties.PropertiesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.petals.component.framework.api.configuration.ConfigurationElementCardinality;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.util.PropertiesUtil;
import org.ow2.petals.component.framework.jbidescriptor.generated.Param;
import org.w3c.dom.Element;

public class ConfigurationExtensions
implements Map<String, String> {
    private final Map<String, String> extensions = new ConcurrentHashMap<String, String>();
    private Properties properties;

    public ConfigurationExtensions(List<?> list, String string) throws PEtALSCDKException {
        this(list);
        if (string != null) {
            try {
                this.properties = PropertiesUtil.loadProperties(string);
            }
            catch (PropertiesException propertiesException) {
                throw new PEtALSCDKException(propertiesException);
            }
            PropertiesHelper.resolveMapWithNoException(this.extensions, (Properties)this.properties);
        }
    }

    public ConfigurationExtensions(List<?> list) {
        if (list != null && !list.isEmpty()) {
            List<ConfigurationElementCardinality> list2 = ConfigurationExtensions.getMultipleElements(list);
            for (Object obj : list) {
                boolean bl = false;
                for (ConfigurationElementCardinality configurationElementCardinality : list2) {
                    if (!configurationElementCardinality.name.equals(ConfigurationExtensions.getCfgEltName(obj))) continue;
                    ++configurationElementCardinality.suffixNumber;
                    this.extensions.put(configurationElementCardinality.name + Integer.valueOf(configurationElementCardinality.suffixNumber), ConfigurationExtensions.getCfgEltValue(obj));
                    bl = true;
                }
                if (bl) continue;
                this.extensions.put(ConfigurationExtensions.getCfgEltName(obj), ConfigurationExtensions.getCfgEltValue(obj));
            }
        }
    }

    @Override
    public void clear() {
        this.extensions.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.extensions.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.extensions.containsValue(object);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.extensions.entrySet();
    }

    @Override
    public String get(Object object) {
        return this.extensions.get(object);
    }

    public String get(Object object, String string) {
        String string2 = this.get(object);
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    @Override
    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.extensions.keySet();
    }

    @Override
    public String put(String string, String string2) {
        if (this.properties != null) {
            try {
                string2 = PropertiesHelper.resolveString((String)string2, (Properties)this.properties);
            }
            catch (PropertiesException propertiesException) {
                // empty catch block
            }
        }
        return this.extensions.put(string, string2);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        if (this.properties != null) {
            PropertiesHelper.resolveMapWithNoException(map, (Properties)this.properties);
        }
        this.extensions.putAll(map);
    }

    @Override
    public String remove(Object object) {
        return this.extensions.remove(object);
    }

    @Override
    public int size() {
        return this.extensions.size();
    }

    @Override
    public Collection<String> values() {
        return this.extensions.values();
    }

    private static final String getCfgEltName(Object object) {
        String string = null;
        if (object instanceof Element) {
            string = ((Element)object).getLocalName();
        } else if (object instanceof Param) {
            string = ((Param)object).getName();
        }
        return string;
    }

    private static final String getCfgEltValue(Object object) {
        String string = null;
        if (object instanceof Element) {
            string = ((Element)object).getTextContent();
        } else if (object instanceof Param) {
            string = ((Param)object).getValue();
        }
        return string;
    }

    private static final List<ConfigurationElementCardinality> getMultipleElements(List<?> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : list) {
            boolean bl = false;
            for (ConfigurationElementCardinality configurationElementCardinality : arrayList) {
                if (!configurationElementCardinality.name.equals(ConfigurationExtensions.getCfgEltName(object))) continue;
                ++configurationElementCardinality.cardinality;
                bl = true;
                break;
            }
            if (bl) continue;
            ConfigurationElementCardinality configurationElementCardinality = new ConfigurationElementCardinality();
            configurationElementCardinality.name = ConfigurationExtensions.getCfgEltName(object);
            arrayList.add(configurationElementCardinality);
        }
        ArrayList arrayList2 = new ArrayList();
        for (ConfigurationElementCardinality configurationElementCardinality : arrayList) {
            if (configurationElementCardinality.cardinality <= 1) continue;
            arrayList2.add(configurationElementCardinality);
        }
        return arrayList2;
    }

    public String toString() {
        return this.extensions.toString();
    }
}

