/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.api.util;

import com.ebmwebsourcing.easycommons.io.IOHelper;
import com.ebmwebsourcing.easycommons.properties.PropertiesException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class PropertiesUtil {
    public static final Properties loadProperties(String string) throws PropertiesException {
        Properties properties = new Properties();
        if (string != null) {
            InputStream inputStream = null;
            try {
                inputStream = PropertiesUtil.loadPropertiesFileFromUrl(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = PropertiesUtil.loadPropertiesFileFromRelativePath(string);
            }
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    String string2 = String.format("Cannot find properties at location : %s", string);
                    throw new PropertiesException(string2);
                }
                finally {
                    IOHelper.close((Closeable)inputStream);
                }
            } else {
                String string3 = String.format("Cannot find properties at location : %s", string);
                throw new PropertiesException(string3);
            }
        }
        return properties;
    }

    private static final InputStream loadPropertiesFileFromRelativePath(String string) throws PropertiesException {
        FileInputStream fileInputStream = null;
        String string2 = System.getenv("PETALS_HOME");
        if (string2 != null) {
            File file = new File(string2, string);
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string3 = String.format("Cannot load properties from the file %s", string);
                throw new PropertiesException(string3, (Throwable)fileNotFoundException);
            }
        } else {
            throw new PropertiesException("PETALS_HOME is not defined");
        }
        return fileInputStream;
    }

    private static final InputStream loadPropertiesFileFromUrl(URL uRL) throws PropertiesException {
        InputStream inputStream = null;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            String string = String.format("Cannot load properties from URL %s", uRL);
            throw new PropertiesException(string, (Throwable)iOException);
        }
        return inputStream;
    }
}

