/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.component.framework.jbidescriptor;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.ow2.petals.component.framework.jbidescriptor.CDKJBIDescriptorException;
import org.ow2.petals.component.framework.jbidescriptor.generated.Jbi;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JBIDescriptorBuilder {
    public static final String CDKJBI_XSD = "CDKjbi.xsd";
    public static final String ABSTRACT_CDKJBI_XSD = "abstractCDKjbi.xsd";
    public static final String CDKEXTENSIONS_XSD = "CDKextensions.xsd";
    private static SchemaFactory factory;
    private static Unmarshaller unmarshaller;
    private static Object unmarshallerSync;
    private static CDKJBIDescriptorException unmarshCreationEx;
    private static Marshaller marshaller;
    private static Object marshallerSync;
    private static CDKJBIDescriptorException marshallerCreationEx;

    public static void validateJBIDescriptor(InputStream inputStream) throws CDKJBIDescriptorException {
        Validator validator = JBIDescriptorBuilder.getUnMarshaller().getSchema().newValidator();
        try {
            validator.validate(new StreamSource(inputStream));
        }
        catch (SAXException sAXException) {
            throw new CDKJBIDescriptorException("Failed to validate JBI descriptor against JBI schema", sAXException);
        }
        catch (IOException iOException) {
            throw new CDKJBIDescriptorException("Failed to validate JBI descriptor against JBI schema", iOException);
        }
    }

    public static void validateJBIDescriptor(InputStream inputStream, String string) throws CDKJBIDescriptorException {
        URL uRL = JBIDescriptorBuilder.class.getResource("/CDKextensions.xsd");
        URL uRL2 = JBIDescriptorBuilder.class.getResource("/" + string + "extensions.xsd");
        URL uRL3 = JBIDescriptorBuilder.class.getResource("/abstractCDKjbi.xsd");
        URL uRL4 = JBIDescriptorBuilder.class.getResource("/" + string + "jbi.xsd");
        try {
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(uRL.openStream()), new StreamSource(uRL2.openStream()), new StreamSource(uRL3.openStream()), new StreamSource(uRL4.openStream())});
            schema.newValidator().validate(new StreamSource(inputStream));
        }
        catch (SAXException sAXException) {
            throw new CDKJBIDescriptorException("Failed to create the CDK component specific schema validation", sAXException);
        }
        catch (IOException iOException) {
            throw new CDKJBIDescriptorException("Failed to create the CDK component specific schema validation", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Jbi buildJavaJBIDescriptor(InputStream inputStream) throws CDKJBIDescriptorException {
        try {
            JAXBElement jAXBElement;
            Object object = unmarshallerSync;
            synchronized (object) {
                jAXBElement = JBIDescriptorBuilder.getUnMarshaller().unmarshal((Source)new StreamSource(inputStream), Jbi.class);
            }
            return (Jbi)jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new CDKJBIDescriptorException("Failed to build jbi descriptor", jAXBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlJBIdescriptor(Jbi jbi, Node node) throws CDKJBIDescriptorException {
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbi, node);
            }
        }
        catch (JAXBException jAXBException) {
            throw new CDKJBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", jAXBException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document buildXmlJBIdescriptor(Jbi jbi) throws CDKJBIDescriptorException {
        Document document = DocumentBuilders.newDocument();
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbi, (Node)document);
            }
        }
        catch (JAXBException jAXBException) {
            throw new CDKJBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", jAXBException);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlJBIdescriptor(Jbi jbi, OutputStream outputStream) throws CDKJBIDescriptorException {
        try {
            Object object = marshallerSync;
            synchronized (object) {
                JBIDescriptorBuilder.getMarshaller().marshal((Object)jbi, outputStream);
            }
        }
        catch (JAXBException jAXBException) {
            throw new CDKJBIDescriptorException("Failed to build XML binding from JBI descriptor Java classes", jAXBException);
        }
    }

    private static Unmarshaller getUnMarshaller() throws CDKJBIDescriptorException {
        if (unmarshCreationEx != null) {
            throw unmarshCreationEx;
        }
        return unmarshaller;
    }

    private static Marshaller getMarshaller() throws CDKJBIDescriptorException {
        if (marshallerCreationEx != null) {
            throw marshallerCreationEx;
        }
        return marshaller;
    }

    static {
        unmarshallerSync = new Object();
        marshallerSync = new Object();
        factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        URL uRL = JBIDescriptorBuilder.class.getResource("/CDKjbi.xsd");
        URL uRL2 = JBIDescriptorBuilder.class.getResource("/CDKextensions.xsd");
        try {
            InputStream inputStream = uRL2.openStream();
            InputStream inputStream2 = uRL.openStream();
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(inputStream), new StreamSource(inputStream2)});
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Jbi.class});
            try {
                unmarshaller = jAXBContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException jAXBException) {
                unmarshCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB unmarshaller", jAXBException);
            }
            try {
                marshaller = jAXBContext.createMarshaller();
                marshaller.setSchema(schema);
                marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            }
            catch (JAXBException jAXBException) {
                marshallerCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB marshaller", jAXBException);
            }
            inputStream.close();
            inputStream2.close();
        }
        catch (Exception exception) {
            unmarshCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB unmarshaller", exception);
            marshallerCreationEx = new CDKJBIDescriptorException("Failed to create the JAXB marshaller and unmarshaller", exception);
        }
    }
}

