/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.commons;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;
import java.io.File;
import javax.jbi.messaging.FlowAttributes;
import javax.xml.namespace.QName;

public final class PetalsExecutionContext {
    private static final SimpleUUIDGenerator simpleUUIDGenerator = new SimpleUUIDGenerator();

    public static final void putDefaultProperties() {
        ExecutionContext.getProperties().setProperty("logSubdir", "");
        ExecutionContext.getProperties().setProperty("logFilename", "petals.log");
    }

    public static final void putFlowInstanceId(String string) {
        assert (string != null);
        ExecutionContext.getProperties().setProperty("flowInstanceId", string);
        ExecutionContext.getProperties().setProperty("logSubdir", "flow-monitoring" + File.separator + string);
        ExecutionContext.getProperties().setProperty("logFilename", "flow.log");
    }

    public static final void initFlowInstanceId() {
        PetalsExecutionContext.putFlowInstanceId(simpleUUIDGenerator.getNewID());
    }

    public static final void putFlowStepId(String string) {
        assert (string != null);
        ExecutionContext.getProperties().setProperty("flowStepId", string);
    }

    public static final void putFlowAttributes(FlowAttributes flowAttributes) {
        assert (flowAttributes != null);
        PetalsExecutionContext.putFlowInstanceId(flowAttributes.getFlowInstanceId());
        PetalsExecutionContext.putFlowStepId(flowAttributes.getFlowStepId());
    }

    public static final FlowAttributes getFlowAttributes() {
        String string = ExecutionContext.getProperties().getProperty("flowInstanceId");
        if (string == null) {
            return null;
        }
        String string2 = ExecutionContext.getProperties().getProperty("flowStepId");
        if (string2 == null) {
            return null;
        }
        return new FlowAttributes(string, string2);
    }

    public static void putPetalsFileHandlerBaseDir(String string) {
        ExecutionContext.getProperties().setProperty("petalsFileHandlerBasedir", string);
    }

    public static void nextFlowStepId() {
        if (ExecutionContext.getProperties().getProperty("flowStepId") != null) {
            ExecutionContext.getProperties().setProperty("flowPreviousStepId", ExecutionContext.getProperties().getProperty("flowStepId"));
        }
        ExecutionContext.getProperties().setProperty("flowStepId", simpleUUIDGenerator.getNewID());
    }

    public static final void putFlowStepInterfaceName(QName qName) {
        assert (qName != null);
        ExecutionContext.getProperties().setProperty("flowStepInterfaceName", qName.toString());
    }

    public static final void putFlowStepOperationName(QName qName) {
        assert (qName != null);
        ExecutionContext.getProperties().setProperty("flowStepOperationName", qName.toString());
    }

    public static final void putFlowStepServiceName(QName qName) {
        assert (qName != null);
        ExecutionContext.getProperties().setProperty("flowStepServiceName", qName.toString());
    }

    public static final void putFlowStepEndpointName(String string) {
        assert (string != null);
        ExecutionContext.getProperties().setProperty("flowStepEndpointName", string);
    }
}

