/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.util.Arrays;
import java.util.List;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.ow2.petals.component.framework.api.Message;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.util.MtomUtil;
import org.ow2.petals.component.framework.util.SourceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FTPUtil {
    public static String getOperationValidMep(String string, Message.MEPConstants ... mEPConstantsArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Exchange pattern for the " + string.toUpperCase() + " operation must be ");
        for (int i = 0; i < mEPConstantsArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append(mEPConstantsArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String generateFileNameList(List<String> list, QName qName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tns:" + qName.getLocalPart() + "Response xmlns:tns='");
        stringBuffer.append(qName.getNamespaceURI());
        stringBuffer.append("'>");
        for (String string : list) {
            stringBuffer.append("<tns:filename>");
            stringBuffer.append(string);
            stringBuffer.append("</tns:filename>");
        }
        stringBuffer.append("</tns:" + qName.getLocalPart() + "Response>");
        return stringBuffer.toString();
    }

    public static Document generateMTOMListResponse(List<String> list, QName qName) {
        Document document = DocumentBuilders.newDocument();
        Element element = document.createElementNS(qName.getNamespaceURI(), "tns:" + qName.getLocalPart() + "Response");
        element.appendChild(MtomUtil.generateMtomStructure((Document)document, list, (QName)new QName(qName.getNamespaceURI(), "attachments", "tns"), (QName)new QName(qName.getNamespaceURI(), "filename", "tns")));
        document.appendChild(element);
        return document;
    }

    public static Document generateMTOMResponse(String string, QName qName) {
        Document document = DocumentBuilders.newDocument();
        Element element = document.createElementNS(qName.getNamespaceURI(), "tns:" + qName.getLocalPart() + "Response");
        element.appendChild(MtomUtil.generateMtomStructure((Document)document, Arrays.asList(string), (QName)new QName(qName.getNamespaceURI(), "attachment", "tns"), (QName)new QName(qName.getNamespaceURI(), "filename", "tns")));
        document.appendChild(element);
        return document;
    }

    public static void setIOFaultOnExchange(Exchange exchange, String string) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tns:ioFault xmlns:tns='");
        stringBuffer.append(exchange.getOperation().getNamespaceURI());
        stringBuffer.append("'><tns:message>");
        stringBuffer.append(string);
        stringBuffer.append("</tns:message></tns:ioFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(SourceUtil.createSource((String)stringBuffer.toString()));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException(pEtALSCDKException.getMessage());
        }
    }

    public static void setMissingElementFaultOnExchange(Exchange exchange, String string) throws MessagingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tns:missingElementFault xmlns:tns='");
        stringBuffer.append(exchange.getOperation().getNamespaceURI());
        stringBuffer.append("'><tns:element>");
        stringBuffer.append(string);
        stringBuffer.append("</tns:element></tns:missingElementFault>");
        Fault fault = exchange.createFault();
        try {
            fault.setContent(SourceUtil.createSource((String)stringBuffer.toString()));
            exchange.setFault(fault);
        }
        catch (PEtALSCDKException pEtALSCDKException) {
            throw new MessagingException(pEtALSCDKException.getMessage());
        }
    }
}

