/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.connection;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.component.framework.util.FileNamePatternUtil;
import org.ow2.petals.component.framework.util.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WrappedFTPClient
extends FTPClient {
    private final FTPConnectionInfo connectionInfo;
    private final transient Logger logger;

    public WrappedFTPClient(FTPConnectionInfo fTPConnectionInfo, Logger logger) {
        this.connectionInfo = fTPConnectionInfo;
        this.logger = logger;
    }

    public void configureConnection() throws IOException {
        boolean bl = true;
        if (!StringHelper.isNullOrEmpty((String)this.connectionInfo.getDirectory())) {
            bl = this.changeWorkingDirectory(this.connectionInfo.getDirectory());
        }
        if (!bl) {
            throw new IOException("Failed to change directory. Target directory : [" + this.connectionInfo.getDirectory() + "]");
        }
        this.logger.finest("FTP server working directory is : " + this.printWorkingDirectory());
        if (this.connectionInfo.isPassiveMode()) {
            this.enterLocalPassiveMode();
            this.logger.finest("enter Passive mode");
        }
        if (this.connectionInfo.isAsciiTransferType()) {
            this.setFileType(0);
            this.logger.finest("ascii transfer mode enable");
        } else if (this.connectionInfo.isBinaryTransferType()) {
            this.setFileType(2);
            this.logger.finest("binary transfer mode enable");
        }
    }

    public void del(String string) throws IOException {
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        boolean bl = false;
        while (!bl) {
            if (++n > n2) {
                throw new IOException("Error occurred while deleting '" + string + "' file from the FTP server");
            }
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start deleting '" + string + "' file from the FTP server");
                }
                bl = this.deleteFile(string);
            }
            catch (IOException iOException) {
                if (n == n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to delete the file '" + string + "' failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
    }

    public Document get(String string) throws IOException {
        Document document = null;
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        while (document == null) {
            if (++n > n2) {
                throw new IOException("Error occurred while getting '" + string + "' file from the FTP server");
            }
            try {
                this.logger.finest("start getting '" + string + "' file from the FTP server");
                FTPFile[] fTPFileArray = this.listFiles(string);
                if (fTPFileArray != null && fTPFileArray.length > 0) {
                    document = this.getAsDocument(fTPFileArray[0].getName());
                    continue;
                }
                throw new IOException("Can not find the specified resource");
            }
            catch (IOException iOException) {
                if (n == n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to get the file '" + string + "' failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
        return document;
    }

    public FTPConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public DataHandler getFileAsAttachment(String string) throws IOException {
        DataHandler dataHandler = null;
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        while (dataHandler == null) {
            if (++n > n2) {
                throw new IOException("Error occurred while getting '" + string + "' file from the FTP server");
            }
            try {
                this.logger.finest("start getting '" + string + "' file from the FTP server");
                FTPFile[] fTPFileArray = this.listFiles(string);
                if (fTPFileArray != null && fTPFileArray.length > 0) {
                    dataHandler = this.getAsDataHandler(fTPFileArray[0]);
                    continue;
                }
                throw new IOException("Can not find the specified resource");
            }
            catch (IOException iOException) {
                if (n == n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to get the file '" + string + "' failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
        return dataHandler;
    }

    public void connectAndLog() throws IOException {
        this.logger.finest("create FTP connection to " + this.connectionInfo.getServer());
        this.setControlEncoding(this.connectionInfo.getEncoding());
        this.connect(this.connectionInfo.getServer(), this.connectionInfo.getPort());
        int n = this.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)n)) {
            this.disconnect();
            throw new IOException("connection to FTP server failed.");
        }
        boolean bl = this.login(this.connectionInfo.getUser(), this.connectionInfo.getPassword());
        if (!bl) {
            throw new IOException("authentication failed.");
        }
        this.logger.finest(this.connectionInfo.toString());
    }

    public List<String> listFolderContent() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        while (!bl) {
            try {
                this.logger.finest("start listing a directory from the FTP server");
                for (FTPFile fTPFile : this.listFiles()) {
                    if (!fTPFile.isFile()) continue;
                    arrayList.add(fTPFile.getName());
                }
                bl = true;
            }
            catch (IOException iOException) {
                if (++n == n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to list a directory failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
        return arrayList;
    }

    public void mDel(List<String> list) throws IOException {
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        boolean bl = false;
        while (!bl) {
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start deleting '" + list.toString() + "' file from the FTP server");
                }
                for (String string : list) {
                    this.deleteFile(string);
                }
                bl = true;
            }
            catch (IOException iOException) {
                if (n == n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to delete the file '" + list + "' failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
    }

    public Map<String, DataHandler> mGet(List<String> list) throws IOException {
        boolean bl = false;
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        HashMap<String, DataHandler> hashMap = new HashMap<String, DataHandler>();
        LinkedList<FileNamePatternUtil.RegexFileNameFilter> linkedList = new LinkedList<FileNamePatternUtil.RegexFileNameFilter>();
        for (String fTPFileArray : list) {
            linkedList.add(FileNamePatternUtil.getInstance().buildFileNameFilterFromWildChar(fTPFileArray));
        }
        FileNamePatternUtil.RegexFileNameFilter regexFileNameFilter = FileNamePatternUtil.getInstance().buildFileNameFilterFromFilters(linkedList);
        while (!bl) {
            try {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("start getting files from the FTP server");
                }
                for (FTPFile fTPFile : this.listFiles()) {
                    if (!fTPFile.isFile() || !regexFileNameFilter.accept(null, fTPFile.getName())) continue;
                    hashMap.put(fTPFile.getName(), this.getAsDataHandler(fTPFile));
                }
                bl = true;
            }
            catch (IOException iOException) {
                if (++n >= n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to get a file failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
        return hashMap;
    }

    public void mPut(Map<String, DataHandler> map) throws IOException {
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        for (Map.Entry<String, DataHandler> entry : map.entrySet()) {
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                if (n == n2) {
                    throw new IOException("Error occurred while storing '" + entry.getKey() + "' file on the FTP server");
                }
                try {
                    this.logger.finest("start sending '" + entry.getKey() + "' file on the FTP server");
                    bl2 = this.fileExistOnRemoteDirectory(entry.getKey());
                    if (bl2 && !this.connectionInfo.isOverwrite()) {
                        n = n2;
                        throw new IOException("File [" + entry.getKey() + "] already exists");
                    }
                    InputStream inputStream = entry.getValue().getInputStream();
                    bl = this.storeFile(entry.getKey(), inputStream);
                    inputStream.close();
                    if (bl) {
                        this.logger.finest("'" + entry.getKey() + "' sent on the FTP server");
                        continue;
                    }
                    ++n;
                }
                catch (IOException iOException) {
                    if (++n >= n2) {
                        throw iOException;
                    }
                    this.logger.warning("An attempt to put the file '" + entry.getKey() + "' failed : " + iOException.getMessage());
                    try {
                        Thread.sleep(this.connectionInfo.getDelay());
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                }
            }
        }
    }

    public void putString(String string, String string2) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = this.connectionInfo.getAttempt();
        while (!bl) {
            if (++n > n2) {
                throw new IOException("Error occurred while storing '" + string + "' file on the FTP server");
            }
            try {
                this.logger.finest("start sending '" + string + "' file on the FTP server");
                bl2 = this.fileExistOnRemoteDirectory(string);
                if (!bl2 || this.connectionInfo.isOverwrite()) {
                    OutputStream outputStream = this.storeFileStream(string);
                    outputStream.write(string2.getBytes());
                    outputStream.flush();
                    outputStream.close();
                    bl = this.completePendingCommand();
                    continue;
                }
                n = n2;
                throw new IOException("File [" + string + "] already exists");
            }
            catch (IOException iOException) {
                if (n >= n2) {
                    throw iOException;
                }
                this.logger.warning("An attempt to put the file '" + string + "' failed : " + iOException.getMessage());
                try {
                    Thread.sleep(this.connectionInfo.getDelay());
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException);
                }
            }
        }
        this.logger.finest("'" + string + "' sent on the FTP server");
    }

    private boolean fileExistOnRemoteDirectory(String string) throws IOException {
        String[] stringArray;
        boolean bl = false;
        for (String string2 : stringArray = this.listNames()) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private DataHandler getAsDataHandler(FTPFile fTPFile) throws IOException {
        this.logger.info("start receiving file " + fTPFile.getName() + " from FTP server");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)fTPFile.getSize());
        try {
            this.retrieveFile(fTPFile.getName(), byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            byteArrayOutputStream.close();
        }
        this.logger.finest(fTPFile.getName() + " file received from FTP server");
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byteArrayOutputStream.toByteArray(), FileTypeMap.getDefaultFileTypeMap().getContentType(fTPFile.getName()));
        byteArrayDataSource.setName(fTPFile.getName());
        DataHandler dataHandler = new DataHandler((DataSource)byteArrayDataSource);
        this.logger.finest(fTPFile.getName() + " set as DataHandler");
        return dataHandler;
    }

    private Document getAsDocument(String string) throws IOException {
        Document document;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("start receiving file " + string + " from FTP server");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.retrieveFile(string, byteArrayOutputStream);
        byteArrayOutputStream.flush();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            document = XMLUtil.loadDocument((InputStream)byteArrayInputStream);
        }
        catch (SAXException sAXException) {
            throw new IOException("processed file '" + string + "' is not a valid xml file : " + sAXException.getMessage());
        }
        finally {
            byteArrayOutputStream.close();
            byteArrayInputStream.close();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(string + " file received from FTP server and set as document");
        }
        return document;
    }
}

