/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.bc.ftp.listener;

import com.ebmwebsourcing.easycommons.lang.StringHelper;
import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import java.io.IOException;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;
import org.ow2.petals.bc.ftp.FTPComponent;
import org.ow2.petals.bc.ftp.FTPUtil;
import org.ow2.petals.bc.ftp.MissingElementException;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfo;
import org.ow2.petals.bc.ftp.connection.FTPConnectionInfoBuilder;
import org.ow2.petals.bc.ftp.connection.WrappedFTPClient;
import org.ow2.petals.bc.ftp.service.FTPService;
import org.ow2.petals.component.framework.api.Wsdl;
import org.ow2.petals.component.framework.api.message.Exchange;
import org.ow2.petals.component.framework.listener.AbstractJBIListener;
import org.ow2.petals.component.framework.util.WSDLUtilImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JBIListener
extends AbstractJBIListener {
    private transient FTPService service = null;

    public void init() {
        this.service = new FTPService(this.getLogger());
    }

    private static final void validateExchange(Exchange exchange) throws MessagingException {
        QName qName = exchange.getOperation();
        if (qName == null) {
            throw new MessagingException("The JBI operation must be set by the consumer of the service.");
        }
        if (StringHelper.isNullOrEmpty((String)qName.getNamespaceURI())) {
            exchange.setOperation(new QName("http://petals.ow2.org/components/ftp/version-3", qName.getLocalPart()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean onJBIMessage(Exchange exchange) {
        block48: {
            GenericObjectPool genericObjectPool = null;
            WrappedFTPClient wrappedFTPClient = null;
            if (exchange.isActiveStatus()) {
                block47: {
                    Object object;
                    JBIListener.validateExchange(exchange);
                    QName qName = exchange.getOperation();
                    Document document = exchange.getInMessageContentAsDocument();
                    Wsdl wsdl = this.component.getNativeWsdl();
                    if (wsdl != null && WSDLUtilImpl.isDescriptionContaining((Description)wsdl.getDescription(), (ServiceEndpoint)exchange.getEndpoint())) {
                        object = XMLHelper.findChild((Node)document.getFirstChild(), null, (String)"connection", (boolean)false);
                        FTPConnectionInfo fTPConnectionInfo = FTPConnectionInfoBuilder.buildFTPConnectionInfo((Node)object);
                        wrappedFTPClient = new WrappedFTPClient(fTPConnectionInfo, this.getLogger());
                        wrappedFTPClient.connectAndLog();
                        wrappedFTPClient.configureConnection();
                    } else {
                        genericObjectPool = ((FTPComponent)this.component).getMapOfPool().get(this.getProvides());
                        wrappedFTPClient = (WrappedFTPClient)((Object)genericObjectPool.borrowObject());
                    }
                    if ("dir".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processDir(exchange, wrappedFTPClient);
                        break block47;
                    }
                    if ("get".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processGet(exchange, document, wrappedFTPClient);
                        break block47;
                    }
                    if ("getAsAttachment".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processGetAsAttachment(exchange, document, wrappedFTPClient);
                        break block47;
                    }
                    if ("mget".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processMGet(exchange, document, wrappedFTPClient);
                        break block47;
                    }
                    if ("put".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processPut(exchange, document, wrappedFTPClient);
                        break block47;
                    }
                    if ("mput".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processMPut(exchange, document, wrappedFTPClient);
                        break block47;
                    }
                    if ("del".equalsIgnoreCase(qName.getLocalPart())) {
                        this.service.processDel(exchange, document, wrappedFTPClient);
                        break block47;
                    }
                    object = "The operation '" + qName + "' is not recognized";
                    throw new MessagingException((String)object);
                }
                try {
                    if (genericObjectPool == null) {
                        if (wrappedFTPClient != null && wrappedFTPClient.isConnected()) {
                            this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                            wrappedFTPClient.logout();
                            wrappedFTPClient.disconnect();
                        }
                    } else if (wrappedFTPClient != null) {
                        this.getLogger().finest("Return FTPClient to the pool");
                        genericObjectPool.returnObject((Object)wrappedFTPClient);
                    }
                    break block48;
                }
                catch (IOException iOException) {
                    this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + iOException.getMessage() + "]");
                }
                catch (Exception exception) {
                    this.getLogger().finest("Cannot release object of the pool : [" + exception.getMessage() + "]");
                }
                break block48;
                catch (MissingElementException missingElementException) {
                    block49: {
                        this.getLogger().log(Level.WARNING, missingElementException.getClass().getSimpleName() + " : " + missingElementException.getMessage());
                        if (exchange.isInOnlyPattern()) {
                            exchange.setError((Exception)missingElementException);
                            break block49;
                        }
                        try {
                            FTPUtil.setMissingElementFaultOnExchange(exchange, missingElementException.getElement());
                        }
                        catch (MessagingException messagingException) {
                            exchange.setError((Exception)((Object)messagingException));
                        }
                    }
                    try {
                        if (genericObjectPool == null) {
                            if (wrappedFTPClient != null && wrappedFTPClient.isConnected()) {
                                this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                                wrappedFTPClient.logout();
                                wrappedFTPClient.disconnect();
                            }
                        } else if (wrappedFTPClient != null) {
                            this.getLogger().finest("Return FTPClient to the pool");
                            genericObjectPool.returnObject((Object)wrappedFTPClient);
                        }
                    }
                    catch (IOException iOException) {
                        this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + iOException.getMessage() + "]");
                    }
                    catch (Exception exception) {
                        this.getLogger().finest("Cannot release object of the pool : [" + exception.getMessage() + "]");
                    }
                }
                catch (Exception exception) {
                    this.getLogger().log(Level.WARNING, exception.getClass().getSimpleName() + " : " + exception.getMessage());
                    exchange.setError(exception);
                    {
                        catch (Throwable throwable) {
                            try {
                                if (genericObjectPool == null) {
                                    if (wrappedFTPClient != null && wrappedFTPClient.isConnected()) {
                                        this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                                        wrappedFTPClient.logout();
                                        wrappedFTPClient.disconnect();
                                    }
                                } else if (wrappedFTPClient != null) {
                                    this.getLogger().finest("Return FTPClient to the pool");
                                    genericObjectPool.returnObject(wrappedFTPClient);
                                }
                            }
                            catch (IOException iOException) {
                                this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + iOException.getMessage() + "]");
                            }
                            catch (Exception exception2) {
                                this.getLogger().finest("Cannot release object of the pool : [" + exception2.getMessage() + "]");
                            }
                            throw throwable;
                        }
                    }
                    try {
                        if (genericObjectPool == null) {
                            if (wrappedFTPClient != null && wrappedFTPClient.isConnected()) {
                                this.getLogger().finest("Disconnect FTPClient for the generic service connection");
                                wrappedFTPClient.logout();
                                wrappedFTPClient.disconnect();
                            }
                        } else if (wrappedFTPClient != null) {
                            this.getLogger().finest("Return FTPClient to the pool");
                            genericObjectPool.returnObject((Object)wrappedFTPClient);
                        }
                    }
                    catch (IOException iOException) {
                        this.getLogger().finest("Cannot disconnect the FTPClient for the generic service connection : [" + iOException.getMessage() + "]");
                    }
                    catch (Exception exception3) {
                        this.getLogger().finest("Cannot release object of the pool : [" + exception3.getMessage() + "]");
                    }
                }
            }
        }
        return true;
    }
}

